/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.jei.extendedterminal.handler.pnael;

import appeng.core.localization.ItemModText;
import appeng.core.network.serverbound.FillCraftingGridFromRecipePacket;
import appeng.menu.me.items.CraftingTermMenu;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.api.adapter.recipe.table.ITableRecipeAdapter;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.integration.jei.extendedterminal.handler.ETTerminalBaseRecipeTransfer;
import me.myogoo.extendedterminal.integration.jei.handler.IAbstractRecipeHandler;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMenu;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ETCraftingRecipeTransfer<T extends ETTerminalMenu>
extends ETTerminalBaseRecipeTransfer<T, RecipeHolder<CraftingRecipe>> {
    public ETCraftingRecipeTransfer(MenuType<T> menuType, Class<T> containerClass, IRecipeTransferHandlerHelper helper) {
        super(menuType, containerClass, helper);
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T menu, RecipeHolder<CraftingRecipe> recipeHolder, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        if (recipe.getIngredients().isEmpty()) {
            return IAbstractRecipeHandler.Result.createInCompatibleError(this.helper);
        }
        boolean craftingMissing = AbstractContainerScreen.hasControlDown();
        List inputSlots = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        Map slotToIngredientMap = this.helper.getGuiSlotIndexToIngredientMap(recipeHolder);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((ETTerminalBaseMenu)((Object)menu)).findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            List<IRecipeSlotView> missingSlotViews = missingSlots.missingSlots().stream().map(idx -> idx < inputSlots.size() ? (IRecipeSlotView)inputSlots.get((int)idx) : null).filter(Objects::nonNull).toList();
            return this.helper.createUserErrorForMissingSlots((Component)ItemModText.NO_ITEMS.text(), missingSlotViews);
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                int color = missingSlots.anyMissing() ? -2130729728 : -2142943745;
                return new IAbstractRecipeHandler.Result.PartiallyCraftable(missingSlots, color, craftingMissing);
            }
        } else {
            this.performTransfer((ETTerminalMenu)((Object)menu), recipeHolder, craftingMissing);
        }
        return IAbstractRecipeHandler.Result.createSuccessful();
    }

    @Override
    protected Map<Integer, Ingredient> getGuiSlotToIngredientMap(ETTerminalMenu menu, RecipeHolder<CraftingRecipe> recipeHolder) {
        int width;
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        NonNullList ingredients = recipe.getIngredients();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            width = shapedRecipe.getWidth();
        } else {
            width = 3;
        }
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            int guiSlot = i / width * 3 + i % width;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.isEmpty()) continue;
            result.put(guiSlot, ingredient);
        }
        return result;
    }

    @Override
    protected void performTransfer(ETTerminalMenu menu, RecipeHolder<CraftingRecipe> recipeHolder, boolean craftingMissing) {
        ResourceLocation recipeId = recipeHolder.id();
        NonNullList<ItemStack> templateItems = ItemListTermCraftingHelper.findGoodTemplateItems(ITableRecipeAdapter.of((CraftingRecipe)recipeHolder.value()), menu);
        if (menu.getPlayer().level().getRecipeManager().byKey(recipeId).isEmpty()) {
            ExtendedTerminal.LOGGER.warn("ETCraftingRecipeTransfer#performTransfer: recipe with id {} not found in recipe manager", (Object)recipeId);
            recipeId = null;
        }
        FillCraftingGridFromRecipePacket message = new FillCraftingGridFromRecipePacket(recipeHolder.id(), templateItems, craftingMissing);
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }
}

