/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.jei.handler;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.myogoo.extendedterminal.api.adapter.recipe.table.IShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.table.ITableRecipeAdapter;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.integration.jei.handler.IAbstractRecipeHandler;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.network.serverbound.FillTableCraftingGridFromRecipePacket;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTableHolderRecipeHandler<T extends ETTerminalBaseMenu<R>, R extends Recipe<?>, H extends RecipeHolder<R>>
implements IRecipeTransferHandler<T, H>,
IAbstractRecipeHandler {
    private final Class<T> containerClass;
    private final MenuType<T> menuType;
    private final RecipeType<H> recipeType;

    public AbstractTableHolderRecipeHandler(Class<T> containerClass, MenuType<T> menuType, RecipeType<H> recipeType) {
        this.containerClass = containerClass;
        this.menuType = menuType;
        this.recipeType = recipeType;
    }

    @NotNull
    public Class<? extends T> getContainerClass() {
        return this.containerClass;
    }

    @NotNull
    public Optional<MenuType<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    @NotNull
    public RecipeType<H> getRecipeType() {
        return this.recipeType;
    }

    protected abstract Map<Integer, Ingredient> getGuiSlotToIngredientMap(T var1, ITableRecipeAdapter var2);

    protected void performTransfer(T menu, ITableRecipeAdapter recipe, boolean craftMissing, ResourceLocation recipeId) {
        NonNullList<ItemStack> templateItems = ItemListTermCraftingHelper.findGoodTemplateItems(recipe, menu);
        int recipeWidth = -1;
        int recipeHeight = -1;
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedRecipe = (IShapedTableRecipeAdapter)recipe;
            recipeWidth = shapedRecipe.width();
            recipeHeight = shapedRecipe.height();
        }
        FillTableCraftingGridFromRecipePacket message = new FillTableCraftingGridFromRecipePacket(recipeId, (List<ItemStack>)templateItems, craftMissing, recipeWidth, recipeHeight);
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

