/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.jei.handler;

import appeng.core.localization.ItemModText;
import appeng.integration.modules.itemlists.TransferHelper;
import appeng.menu.me.items.CraftingTermMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IAbstractRecipeHandler {
    public static final int BLUE_SLOT_HIGHLIGHT_COLOR = 0x400000FF;
    public static final int RED_SLOT_HIGHLIGHT_COLOR = 0x66FF0000;

    public static abstract class Result
    implements IRecipeTransferError {
        @NotNull
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        @Nullable
        public static IRecipeTransferError createSuccessful() {
            return null;
        }

        public static IRecipeTransferError createNotApplicable(IRecipeTransferHandlerHelper helper) {
            return helper.createInternalError();
        }

        public static IRecipeTransferError createInCompatibleError(IRecipeTransferHandlerHelper helper) {
            return helper.createUserErrorWithTooltip((Component)ItemModText.INCOMPATIBLE_RECIPE.text());
        }

        public static IRecipeTransferError createNotSupportedError(IRecipeTransferHandlerHelper helper) {
            return helper.createUserErrorWithTooltip((Component)Component.translatable((String)"extendedterminal.jei.notsupportederror"));
        }

        public static IRecipeTransferError createRecipeToLargeError(IRecipeTransferHandlerHelper helper) {
            return helper.createUserErrorWithTooltip((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }

        public static final class PartiallyCraftable
        extends Result {
            private final CraftingTermMenu.MissingIngredientSlots missingSlots;
            private final boolean craftMissing;
            private final int color;

            public PartiallyCraftable(CraftingTermMenu.MissingIngredientSlots missingSlots, int color, boolean craftMissing) {
                this.missingSlots = missingSlots;
                this.craftMissing = craftMissing;
                this.color = color;
            }

            public int getButtonHighlightColor() {
                return this.color;
            }

            public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView slots, int recipeX, int recipeY) {
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate((float)recipeX, (float)recipeY, 0.0f);
                List slotViews = slots.getSlotViews(RecipeIngredientRole.INPUT);
                for (int i = 0; i < slotViews.size(); ++i) {
                    IRecipeSlotView slotView = (IRecipeSlotView)slotViews.get(i);
                    boolean missing = this.missingSlots.missingSlots().contains(i);
                    boolean craftable = this.missingSlots.craftableSlots().contains(i);
                    if (!missing && !craftable) continue;
                    slotView.drawHighlight(guiGraphics, missing ? 0x66FF0000 : 0x400000FF);
                }
                poseStack.popPose();
            }

            public int getMissingCountHint() {
                return this.missingSlots.missingSlots().size();
            }

            public void getTooltip(ITooltipBuilder tooltip) {
                tooltip.addAll((Collection)TransferHelper.createCraftingTooltip((CraftingTermMenu.MissingIngredientSlots)this.missingSlots, (boolean)this.craftMissing, (boolean)false));
            }
        }
    }
}

