/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu;

import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.menu.ETSlotSemantics;
import me.myogoo.extendedterminal.util.mod.ModIntegrationManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;

public enum ETMenuType implements IExtensibleEnum
{
    ET_TERMINAL(3, -1, SlotSemantics.CRAFTING_GRID, SlotSemantics.CRAFTING_RESULT),
    EX_PATTERN_TERMINAL(9, -1, ETSlotSemantics.BASIC_CRAFTING_GRID, ETSlotSemantics.BASIC_CRAFTING_RESULT),
    BASIC_TERMINAL(3, 1, ETSlotSemantics.BASIC_CRAFTING_GRID, ETSlotSemantics.BASIC_CRAFTING_RESULT),
    ADVANCED_TERMINAL(5, 2, ETSlotSemantics.ADVANCED_CRAFTING_GRID, ETSlotSemantics.ADVANCED_CRAFTING_RESULT),
    ELITE_TERMINAL(7, 3, ETSlotSemantics.ELITE_CRAFTING_GRID, ETSlotSemantics.ELITE_CRAFTING_RESULT),
    ULTIMATE_TERMINAL(9, 4, ETSlotSemantics.ULTIMATE_CRAFTING_GRID, ETSlotSemantics.ULTIMATE_CRAFTING_RESULT),
    EXTENDED_CRAFTING_UNIVERSAL_TERMINAL(9, 0, ETSlotSemantics.EXTENDED_CRAFTING_UNIVERSAL_GRID, ETSlotSemantics.EXTENDED_CRAFTING_UNIVERSAL_RESULT),
    SCULK_TERMINAL(3, 1, ETSlotSemantics.SCULK_CRAFTING_GRID, ETSlotSemantics.SCULK_CRAFTING_RESULT),
    NETHER_TERMINAL(5, 2, ETSlotSemantics.NETHER_CRAFTING_GRID, ETSlotSemantics.NETHER_CRAFTING_RESULT),
    END_TERMINAL(7, 3, ETSlotSemantics.END_CRAFTING_GRID, ETSlotSemantics.END_CRAFTING_RESULT),
    EXTREME_TERMINAL(9, 4, ETSlotSemantics.EXTREME_CRAFTING_GRID, ETSlotSemantics.EXTREME_CRAFTING_RESULT),
    NEO_EXTREME_TERMINAL(9, 4, ETSlotSemantics.EXTREME_CRAFTING_GRID, ETSlotSemantics.EXTREME_CRAFTING_RESULT);

    private final SlotSemantic slotSemantic_GRID;
    private final SlotSemantic slotSemantic_RESULT;
    private final int sideLength;
    private final int tier;

    private ETMenuType(int sideLength, int tier, SlotSemantic slotSemantic_GRID, SlotSemantic slotSemantic_RESULT) {
        this.slotSemantic_GRID = slotSemantic_GRID;
        this.slotSemantic_RESULT = slotSemantic_RESULT;
        this.sideLength = sideLength;
        this.tier = tier;
    }

    public int getGridSize() {
        return this.sideLength * this.sideLength;
    }

    public int getGridSideLength() {
        return this.sideLength;
    }

    public ResourceLocation getCraftingInventory() {
        return ExtendedTerminal.makeId(this.getIdAsString() + "_inventory");
    }

    public SlotSemantic getSlotSemanticGrid() {
        return this.slotSemantic_GRID;
    }

    public SlotSemantic getSlotSemanticResult() {
        return this.slotSemantic_RESULT;
    }

    public int getTier() {
        return this.tier;
    }

    public ResourceLocation getId() {
        return ExtendedTerminal.makeId(this.getIdAsString());
    }

    public String getIdAsString() {
        return this.name().toLowerCase();
    }

    public String getWTIdAsString() {
        return "wireless_" + this.name().toLowerCase();
    }

    public String getEnglishName() {
        return this.name().toLowerCase().replace("_", " ");
    }

    public boolean canLoad() {
        try {
            Field field = ETMenuType.class.getField(this.name());
            if (field.getDeclaredAnnotations().length == 0) {
                return true;
            }
            return Arrays.stream(field.getDeclaredAnnotations()).map(Annotation::annotationType).allMatch(ModIntegrationManager::isLoaded);
        }
        catch (NoSuchFieldException e) {
            ExtendedTerminal.LOGGER.error("Menu type {} is not loaded due to missing field in ETMenuType", (Object)this.name());
            return false;
        }
    }

    public static ExtensionInfo getExtensionInfo() {
        return ExtensionInfo.nonExtended(ETMenuType.class);
    }
}

