/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.extendedcrafting.slot;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.helpers.ICraftingGridMenu;
import appeng.items.storage.ViewCellItem;
import appeng.util.prioritylist.IPartitionList;
import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.extendedcrafting.ExtendedTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.slot.ETCraftingBaseSlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;

public class ExCraftingTerminalSlot
extends ETCraftingBaseSlot<ITableRecipe, TableCraftingInput> {
    public ExCraftingTerminalSlot(Player player, IActionSource mySrc, IEnergySource energySrc, MEStorage storage, InternalInventory cMatrix, InternalInventory secondMatrix, ICraftingGridMenu ccp, ETMenuType menuType) {
        super(player, mySrc, energySrc, storage, cMatrix, secondMatrix, ccp, menuType);
    }

    @Override
    protected RecipeHolder<ITableRecipe> findRecipe(TableCraftingInput ic, Level level) {
        ExtendedTerminalBaseMenu terminalMenu;
        RecipeHolder recipe;
        ICraftingGridMenu iCraftingGridMenu = this.menu;
        if (iCraftingGridMenu instanceof ExtendedTerminalBaseMenu && (recipe = (terminalMenu = (ExtendedTerminalBaseMenu)iCraftingGridMenu).getCurrentRecipe()) != null && ((ITableRecipe)recipe.value()).matches((RecipeInput)ic, level)) {
            return terminalMenu.getCurrentRecipe();
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)ic, level).orElse(null);
    }

    @Override
    protected NonNullList<ItemStack> getETRemainingItems(TableCraftingInput ic, Level level) {
        ExtendedTerminalBaseMenu terminalMenu;
        RecipeHolder recipe;
        ICraftingGridMenu iCraftingGridMenu = this.menu;
        if (iCraftingGridMenu instanceof ExtendedTerminalBaseMenu && (recipe = (terminalMenu = (ExtendedTerminalBaseMenu)iCraftingGridMenu).getCurrentRecipe()) != null && ((ITableRecipe)recipe.value()).matches((RecipeInput)ic, level)) {
            return ((ITableRecipe)terminalMenu.getCurrentRecipe().value()).getRemainingItems((RecipeInput)ic);
        }
        return super.getRemainingItems((CraftingInput)ic, level);
    }

    @Override
    protected void makeItem(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        NonNullList items = NonNullList.withSize((int)this.craftInv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.craftInv.size(); ++i) {
            items.set(i, (Object)this.craftInv.getStackInSlot(i));
        }
        TableCraftingInput positioned = TableCraftingInput.of((int)this.menuType.getGridSideLength(), (int)this.menuType.getGridSideLength(), (List)items, (int)this.menuType.getTier());
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList<ItemStack> remainingItems = this.getETRemainingItems(positioned, player.level());
        CommonHooks.setCraftingPlayer(null);
        for (int y = 0; y < this.menuType.getGridSideLength(); ++y) {
            for (int x = 0; x < this.menuType.getGridSideLength(); ++x) {
                ItemStack remainingInSlot;
                int slotIdx = y * this.menuType.getGridSideLength() + x;
                int remainderIdx = (y - positioned.top()) * 3 + (x - positioned.left());
                this.craftInv.extractItem(slotIdx, 1, false);
                if (remainderIdx < 0 || remainderIdx >= remainingItems.size() || (remainingInSlot = (ItemStack)remainingItems.get(remainderIdx)).isEmpty()) continue;
                if (this.craftInv.getStackInSlot(slotIdx).isEmpty()) {
                    this.craftInv.setItemDirect(slotIdx, remainingInSlot);
                    continue;
                }
                if (player.getInventory().add(remainingInSlot)) continue;
                player.drop(remainingInSlot, false);
            }
        }
    }

    @Override
    protected ItemStack craftItem(Player p, MEStorage inv, KeyCounter all) {
        ItemStack is = this.getItem().copy();
        if (is.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Object[] set = new ItemStack[this.getPattern().size()];
        Arrays.fill(set, ItemStack.EMPTY);
        Level level = p.level();
        if (!level.isClientSide()) {
            NonNullList ic = NonNullList.withSize((int)this.menuType.getGridSize(), (Object)ItemStack.EMPTY);
            for (int x = 0; x < this.menuType.getGridSize(); ++x) {
                ic.set(x, (Object)this.getPattern().getStackInSlot(x));
            }
            TableCraftingInput recipeInput = TableCraftingInput.of((int)this.menuType.getGridSideLength(), (int)this.menuType.getGridSideLength(), (List)ic, (int)this.menuType.getTier());
            RecipeHolder<ITableRecipe> r = this.findRecipe(recipeInput, level);
            this.setRecipeUsed(r);
            if (r == null) {
                return ItemStack.EMPTY;
            }
            is = ((ITableRecipe)r.value()).assemble((RecipeInput)recipeInput, (HolderLookup.Provider)level.registryAccess());
            if (inv != null) {
                IPartitionList filter = ViewCellItem.createItemFilter((Collection)this.menu.getViewCells());
                for (int x = 0; x < this.getPattern().size(); ++x) {
                    if (this.getPattern().getStackInSlot(x).isEmpty()) continue;
                    set[x] = ExCraftingTerminalSlot.extractItemsByRecipe(this.energySrc, this.mySrc, inv, level, (ITableRecipe)r.value(), is, recipeInput.width(), recipeInput.height(), (List<ItemStack>)ic, this.getPattern().getStackInSlot(x), x, all, filter, this.menuType);
                    ic.set(x, set[x]);
                }
            }
        }
        this.makeItem(p, is);
        this.postCraft(p, inv, (ItemStack[])set, is);
        p.containerMenu.slotsChanged(this.craftInv.toContainer());
        return is;
    }

    private static ItemStack extractItemsByRecipe(IEnergySource energySrc, IActionSource mySrc, MEStorage src, Level level, ITableRecipe r, ItemStack output, int gridWidth, int gridHeight, List<ItemStack> craftingItems, ItemStack providedTemplate, int slot, KeyCounter items, IPartitionList filter, ETMenuType menuType) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            long extracted;
            if (providedTemplate == null) {
                return ItemStack.EMPTY;
            }
            AEItemKey ae_req = AEItemKey.of((ItemStack)providedTemplate);
            if ((filter == null || filter.isListed((AEKey)ae_req)) && (extracted = src.extract((AEKey)ae_req, 1L, Actionable.MODULATE, mySrc)) > 0L) {
                energySrc.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
                return ae_req.toStack();
            }
            boolean bl = checkFuzzy = !providedTemplate.getComponents().isEmpty() || providedTemplate.isDamageableItem();
            if (items != null && checkFuzzy) {
                ArrayList<ItemStack> craftingInputItems = new ArrayList<ItemStack>(craftingItems);
                for (Object2LongMap.Entry x : items) {
                    long ex;
                    Object object = x.getKey();
                    if (!(object instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)object;
                    if (providedTemplate.getItem() != itemKey.getItem() || itemKey.matches(output)) continue;
                    craftingInputItems.set(slot, itemKey.toStack());
                    TableCraftingInput adjustedCraftingInput = TableCraftingInput.of((int)gridWidth, (int)gridHeight, craftingInputItems, (int)menuType.getTier());
                    if (!r.matches((RecipeInput)adjustedCraftingInput, level) || !ItemStack.matches((ItemStack)r.assemble((RecipeInput)adjustedCraftingInput, (HolderLookup.Provider)level.registryAccess()), (ItemStack)output) || filter != null && !filter.isListed((AEKey)itemKey) || (ex = src.extract((AEKey)itemKey, 1L, Actionable.MODULATE, mySrc)) <= 0L) continue;
                    energySrc.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    return itemKey.toStack();
                }
            }
        }
        return ItemStack.EMPTY;
    }
}

