/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.extendedterminal.slot;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.helpers.ICraftingGridMenu;
import appeng.items.storage.ViewCellItem;
import appeng.util.prioritylist.IPartitionList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMenu;
import me.myogoo.extendedterminal.menu.slot.ETCraftingBaseSlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;

public class ETSmithingSlot
extends ETCraftingBaseSlot<SmithingRecipe, SmithingRecipeInput> {
    private static final int SMITHING_SLOT_SIZE = 3;

    public ETSmithingSlot(Player player, IActionSource mySrc, IEnergySource energySrc, MEStorage storage, InternalInventory cMatrix, InternalInventory secondMatrix, ICraftingGridMenu ccp) {
        super(player, mySrc, energySrc, storage, cMatrix, secondMatrix, ccp, ETMenuType.ET_TERMINAL);
    }

    @Override
    protected RecipeHolder<SmithingRecipe> findRecipe(SmithingRecipeInput ic, Level level) {
        ETTerminalMenu terminalMenu;
        RecipeHolder<SmithingRecipe> recipe;
        ICraftingGridMenu iCraftingGridMenu = this.menu;
        if (iCraftingGridMenu instanceof ETTerminalMenu && (recipe = (terminalMenu = (ETTerminalMenu)iCraftingGridMenu).getSmithingRecipe()) != null && ((SmithingRecipe)recipe.value()).matches((RecipeInput)ic, level)) {
            return terminalMenu.getSmithingRecipe();
        }
        return level.getRecipeManager().getRecipeFor(RecipeType.SMITHING, (RecipeInput)ic, level).orElse(null);
    }

    @Override
    protected NonNullList<ItemStack> getETRemainingItems(SmithingRecipeInput ic, Level level) {
        ETTerminalMenu terminalMenu;
        RecipeHolder<SmithingRecipe> recipe;
        ICraftingGridMenu iCraftingGridMenu = this.menu;
        if (iCraftingGridMenu instanceof ETTerminalMenu && (recipe = (terminalMenu = (ETTerminalMenu)iCraftingGridMenu).getSmithingRecipe()) != null && ((SmithingRecipe)recipe.value()).matches((RecipeInput)ic, level)) {
            return ((SmithingRecipe)terminalMenu.getSmithingRecipe().value()).getRemainingItems((RecipeInput)ic);
        }
        return NonNullList.create();
    }

    @Override
    protected void makeItem(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        NonNullList items = NonNullList.withSize((int)this.craftInv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.craftInv.size(); ++i) {
            items.set(i, (Object)this.craftInv.getStackInSlot(i));
        }
        SmithingRecipeInput input = new SmithingRecipeInput((ItemStack)items.get(0), (ItemStack)items.get(1), (ItemStack)items.get(2));
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList<ItemStack> remainingItems = this.getETRemainingItems(input, player.level());
        CommonHooks.setCraftingPlayer(null);
        for (int i = 0; i < 3; ++i) {
            ItemStack remainingInSlot;
            this.craftInv.extractItem(i, 1, false);
            if (i >= remainingItems.size() || (remainingInSlot = (ItemStack)remainingItems.get(i)).isEmpty()) continue;
            if (this.craftInv.getStackInSlot(i).isEmpty()) {
                this.craftInv.setItemDirect(i, remainingInSlot);
                continue;
            }
            if (player.getInventory().add(remainingInSlot)) continue;
            player.drop(remainingInSlot, false);
        }
    }

    @Override
    protected ItemStack craftItem(Player p, MEStorage inv, KeyCounter all) {
        ItemStack is = this.getItem().copy();
        if (is.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Object[] set = new ItemStack[this.getPattern().size()];
        Arrays.fill(set, ItemStack.EMPTY);
        Level level = p.level();
        if (!level.isClientSide()) {
            NonNullList ic = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
            for (int x = 0; x < ic.size(); ++x) {
                ic.set(x, (Object)this.getPattern().getStackInSlot(x));
            }
            SmithingRecipeInput recipeInput = new SmithingRecipeInput((ItemStack)ic.get(0), (ItemStack)ic.get(1), (ItemStack)ic.get(2));
            RecipeHolder<SmithingRecipe> r = this.findRecipe(recipeInput, level);
            this.setRecipeUsed(r);
            if (r == null) {
                return ItemStack.EMPTY;
            }
            is = ((SmithingRecipe)r.value()).assemble((RecipeInput)recipeInput, (HolderLookup.Provider)level.registryAccess());
            if (inv != null) {
                IPartitionList filter = ViewCellItem.createItemFilter((Collection)this.menu.getViewCells());
                for (int x = 0; x < this.getPattern().size(); ++x) {
                    if (this.getPattern().getStackInSlot(x).isEmpty()) continue;
                    set[x] = ETSmithingSlot.extractItemsByRecipe(this.energySrc, this.mySrc, inv, level, (SmithingRecipe)r.value(), is, (List<ItemStack>)ic, this.getPattern().getStackInSlot(x), x, all, filter);
                    ic.set(x, set[x]);
                }
            }
        }
        this.makeItem(p, is);
        this.postCraft(p, inv, (ItemStack[])set, is);
        p.containerMenu.slotsChanged(this.craftInv.toContainer());
        return is;
    }

    private static ItemStack extractItemsByRecipe(IEnergySource energySrc, IActionSource mySrc, MEStorage src, Level level, SmithingRecipe r, ItemStack output, List<ItemStack> craftingItems, ItemStack providedTemplate, int slot, KeyCounter items, IPartitionList filter) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            long extracted;
            if (providedTemplate == null) {
                return ItemStack.EMPTY;
            }
            AEItemKey ae_req = AEItemKey.of((ItemStack)providedTemplate);
            if ((filter == null || filter.isListed((AEKey)ae_req)) && (extracted = src.extract((AEKey)ae_req, 1L, Actionable.MODULATE, mySrc)) > 0L) {
                energySrc.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
                return ae_req.toStack();
            }
            boolean bl = checkFuzzy = !providedTemplate.getComponents().isEmpty() || providedTemplate.isDamageableItem();
            if (items != null && checkFuzzy) {
                ArrayList<ItemStack> craftingInputItems = new ArrayList<ItemStack>(craftingItems);
                for (Object2LongMap.Entry x : items) {
                    long ex;
                    Object object = x.getKey();
                    if (!(object instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)object;
                    if (providedTemplate.getItem() != itemKey.getItem() || itemKey.matches(output)) continue;
                    craftingInputItems.set(slot, itemKey.toStack());
                    SmithingRecipeInput adjustedCraftingInput = new SmithingRecipeInput(craftingInputItems.get(0), craftingInputItems.get(1), craftingInputItems.get(2));
                    if (!r.matches((RecipeInput)adjustedCraftingInput, level) || !ItemStack.matches((ItemStack)r.assemble((RecipeInput)adjustedCraftingInput, (HolderLookup.Provider)level.registryAccess()), (ItemStack)output) || filter != null && !filter.isListed((AEKey)itemKey) || (ex = src.extract((AEKey)itemKey, 1L, Actionable.MODULATE, mySrc)) <= 0L) continue;
                    energySrc.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    return itemKey.toStack();
                }
            }
        }
        return ItemStack.EMPTY;
    }
}

