/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.extendedterminal.slot;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.helpers.ICraftingGridMenu;
import appeng.items.storage.ViewCellItem;
import appeng.util.prioritylist.IPartitionList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMenu;
import me.myogoo.extendedterminal.menu.slot.ETCraftingBaseSlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;

public class ETStoneCutterSlot
extends ETCraftingBaseSlot<StonecutterRecipe, SingleRecipeInput> {
    public ETStoneCutterSlot(Player player, IActionSource mySrc, IEnergySource energySrc, MEStorage storage, InternalInventory cMatrix, InternalInventory secondMatrix, ICraftingGridMenu ccp) {
        super(player, mySrc, energySrc, storage, cMatrix, secondMatrix, ccp, ETMenuType.ET_TERMINAL);
    }

    @Override
    protected RecipeHolder<StonecutterRecipe> findRecipe(SingleRecipeInput ic, Level level) {
        Recipe recipe;
        ICraftingGridMenu iCraftingGridMenu = this.menu;
        if (!(iCraftingGridMenu instanceof ETTerminalMenu)) {
            return null;
        }
        ETTerminalMenu terminalMenu = (ETTerminalMenu)iCraftingGridMenu;
        Optional recipe2 = level.getRecipeManager().byKey(terminalMenu.getStoneCutterRecipeId());
        if (recipe2.isPresent() && (recipe = ((RecipeHolder)recipe2.get()).value()) instanceof StonecutterRecipe) {
            StonecutterRecipe stonecutterRecipe = (StonecutterRecipe)recipe;
            return (RecipeHolder)recipe2.get();
        }
        return null;
    }

    @Override
    protected NonNullList<ItemStack> getETRemainingItems(SingleRecipeInput ic, Level level) {
        StonecutterRecipe stonecutterRecipe;
        Recipe recipe;
        Optional recipe2;
        ETTerminalMenu terminalMenu;
        ResourceLocation recipeId;
        ICraftingGridMenu iCraftingGridMenu = this.menu;
        if (iCraftingGridMenu instanceof ETTerminalMenu && (recipeId = (terminalMenu = (ETTerminalMenu)iCraftingGridMenu).getStoneCutterRecipeId()) != null && (recipe2 = level.getRecipeManager().byKey(recipeId)).isPresent() && (recipe = ((RecipeHolder)recipe2.get()).value()) instanceof StonecutterRecipe && (stonecutterRecipe = (StonecutterRecipe)recipe).matches(ic, level)) {
            return stonecutterRecipe.getRemainingItems((RecipeInput)ic);
        }
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[0]);
    }

    @Override
    protected void makeItem(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        ItemStack item = this.craftInv.getStackInSlot(0);
        SingleRecipeInput input = new SingleRecipeInput(item);
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList<ItemStack> remainingItems = this.getETRemainingItems(input, player.level());
        CommonHooks.setCraftingPlayer(null);
        this.craftInv.extractItem(0, 1, false);
        ItemStack remainingInSlot = (ItemStack)remainingItems.get(0);
        if (!remainingInSlot.isEmpty()) {
            if (this.craftInv.getStackInSlot(0).isEmpty()) {
                this.craftInv.setItemDirect(0, remainingInSlot);
            } else if (!player.getInventory().add(remainingInSlot)) {
                player.drop(remainingInSlot, false);
            }
        }
    }

    @Override
    protected ItemStack craftItem(Player p, MEStorage inv, KeyCounter all) {
        ItemStack is = this.getItem().copy();
        if (is.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Object[] set = new ItemStack[this.getPattern().size()];
        Arrays.fill(set, ItemStack.EMPTY);
        Level level = p.level();
        if (!level.isClientSide()) {
            NonNullList ic = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            for (int x = 0; x < ic.size(); ++x) {
                ic.set(x, (Object)this.getPattern().getStackInSlot(x));
            }
            SingleRecipeInput recipeInput = new SingleRecipeInput((ItemStack)ic.getFirst());
            RecipeHolder<StonecutterRecipe> r = this.findRecipe(recipeInput, level);
            this.setRecipeUsed(r);
            if (r == null) {
                return ItemStack.EMPTY;
            }
            is = ((StonecutterRecipe)r.value()).assemble(recipeInput, (HolderLookup.Provider)level.registryAccess());
            if (inv != null) {
                IPartitionList filter = ViewCellItem.createItemFilter((Collection)this.menu.getViewCells());
                for (int x = 0; x < this.getPattern().size(); ++x) {
                    if (this.getPattern().getStackInSlot(x).isEmpty()) continue;
                    set[x] = ETStoneCutterSlot.extractItemsByRecipe(this.energySrc, this.mySrc, inv, level, (StonecutterRecipe)r.value(), is, (List<ItemStack>)ic, this.getPattern().getStackInSlot(x), x, all, filter);
                    ic.set(x, set[x]);
                }
            }
        }
        this.makeItem(p, is);
        this.postCraft(p, inv, (ItemStack[])set, is);
        p.containerMenu.slotsChanged(this.craftInv.toContainer());
        return is;
    }

    private static ItemStack extractItemsByRecipe(IEnergySource energySrc, IActionSource mySrc, MEStorage src, Level level, StonecutterRecipe r, ItemStack output, List<ItemStack> craftingItems, ItemStack providedTemplate, int slot, KeyCounter items, IPartitionList filter) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            long extracted;
            if (providedTemplate == null) {
                return ItemStack.EMPTY;
            }
            AEItemKey ae_req = AEItemKey.of((ItemStack)providedTemplate);
            if ((filter == null || filter.isListed((AEKey)ae_req)) && (extracted = src.extract((AEKey)ae_req, 1L, Actionable.MODULATE, mySrc)) > 0L) {
                energySrc.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
                return ae_req.toStack();
            }
            boolean bl = checkFuzzy = !providedTemplate.getComponents().isEmpty() || providedTemplate.isDamageableItem();
            if (items != null && checkFuzzy) {
                ArrayList<ItemStack> craftingInputItems = new ArrayList<ItemStack>(craftingItems);
                for (Object2LongMap.Entry x : items) {
                    long ex;
                    Object object = x.getKey();
                    if (!(object instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)object;
                    if (providedTemplate.getItem() != itemKey.getItem() || itemKey.matches(output)) continue;
                    craftingInputItems.set(slot, itemKey.toStack());
                    SingleRecipeInput adjustedCraftingInput = new SingleRecipeInput(craftingInputItems.getFirst());
                    if (!r.matches(adjustedCraftingInput, level) || !ItemStack.matches((ItemStack)r.assemble(adjustedCraftingInput, (HolderLookup.Provider)level.registryAccess()), (ItemStack)output) || filter != null && !filter.isListed((AEKey)itemKey) || (ex = src.extract((AEKey)itemKey, 1L, Actionable.MODULATE, mySrc)) <= 0L) continue;
                    energySrc.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    return itemKey.toStack();
                }
            }
        }
        return ItemStack.EMPTY;
    }
}

