/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.network.serverbound;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.network.ServerboundPacket;
import appeng.helpers.ICraftingGridMenu;
import appeng.items.storage.ViewCellItem;
import appeng.me.storage.NullInventory;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMenu;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMode;
import me.myogoo.extendedterminal.network.serverbound.FillRecipeBasePacket;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleItemRecipe;

public class FillStonecutterGridFromRecipePacket
extends FillRecipeBasePacket
implements ServerboundPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, FillStonecutterGridFromRecipePacket> STREAM_CODEC = StreamCodec.ofMember(FillStonecutterGridFromRecipePacket::write, FillStonecutterGridFromRecipePacket::decode);
    public static final CustomPacketPayload.Type<FillStonecutterGridFromRecipePacket> TYPE = new CustomPacketPayload.Type(ExtendedTerminal.makeId("fill_stonecutter_grid_from_recipe"));
    private final ResourceLocation recipeId;
    private final boolean craftMissing;
    private final ItemStack ingredientTemplate;

    private void write(RegistryFriendlyByteBuf stream) {
        if (this.recipeId != null) {
            stream.writeBoolean(true);
            stream.writeResourceLocation(this.recipeId);
        } else {
            stream.writeBoolean(false);
        }
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)stream, (Object)this.ingredientTemplate);
        stream.writeBoolean(this.craftMissing);
    }

    private static FillStonecutterGridFromRecipePacket decode(RegistryFriendlyByteBuf stream) {
        ResourceLocation recipeId = null;
        if (stream.readBoolean()) {
            recipeId = stream.readResourceLocation();
        }
        ItemStack ingredientTemplate = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)stream);
        boolean craftMissing = stream.readBoolean();
        return new FillStonecutterGridFromRecipePacket(recipeId, ingredientTemplate, craftMissing);
    }

    public FillStonecutterGridFromRecipePacket(ResourceLocation recipeId, ItemStack ingredientTemplate, boolean craftMissing) {
        this.recipeId = recipeId;
        this.craftMissing = craftMissing;
        this.ingredientTemplate = ingredientTemplate;
    }

    public void handleOnServer(ServerPlayer player) {
        KeyCounter cachedStorage;
        MEStorage networkStorage;
        IStorageService storageService;
        ICraftingService craftingService;
        AbstractContainerMenu menu = player.containerMenu;
        if (!(menu instanceof ETTerminalMenu)) {
            return;
        }
        ETTerminalMenu cct = (ETTerminalMenu)menu;
        IEnergySource energy = cct.getEnergySource();
        IGridNode node = cct.getGridNode();
        if (node != null && cct.getLinkStatus().connected()) {
            craftingService = node.getGrid().getCraftingService();
            storageService = node.getGrid().getStorageService();
            networkStorage = storageService.getInventory();
            cachedStorage = storageService.getCachedInventory();
        } else {
            craftingService = null;
            storageService = null;
            networkStorage = NullInventory.of();
            cachedStorage = new KeyCounter();
        }
        InternalInventory craftMatrix = cct.getStoneCutterInventory();
        IPartitionList filter = ViewCellItem.createItemFilter((Collection)cct.getViewCells());
        NonNullList<Ingredient> ingredients = this.getDesiredIngredients((Player)player);
        LinkedHashMap toAutoCraft = new LinkedHashMap();
        boolean touchedGridStorage = false;
        for (int x = 0; x < craftMatrix.size(); ++x) {
            ItemStack currentItem = craftMatrix.getStackInSlot(0);
            Ingredient ingredient = (Ingredient)ingredients.getFirst();
            if (!currentItem.isEmpty()) {
                if (ingredient.test(currentItem)) {
                    if (cct.getStoneCutterRecipeId() != null && (cct.getStoneCutterRecipeId() == null || cct.getStoneCutterRecipeId().equals((Object)this.recipeId))) continue;
                    cct.setStoneCutterRecipeId(this.recipeId);
                    continue;
                }
                AEItemKey in = AEItemKey.of((ItemStack)currentItem);
                long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkStorage, (AEKey)in, (long)currentItem.getCount(), (IActionSource)cct.getActionSource());
                if (inserted > 0L) {
                    touchedGridStorage = true;
                }
                if (inserted < (long)currentItem.getCount()) {
                    currentItem = currentItem.copy();
                    currentItem.shrink((int)inserted);
                } else {
                    currentItem = ItemStack.EMPTY;
                }
                player.getInventory().add(currentItem);
                craftMatrix.setItemDirect(x, currentItem.isEmpty() ? ItemStack.EMPTY : currentItem);
            }
            if (ingredient.isEmpty()) continue;
            if (currentItem.isEmpty()) {
                List<AEItemKey> request = this.findBestMatchingItemStack(ingredient, filter, cachedStorage);
                for (AEItemKey what : request) {
                    long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)networkStorage, (AEKey)what, (long)1L, (IActionSource)cct.getActionSource());
                    if (extracted <= 0L) continue;
                    touchedGridStorage = true;
                    currentItem = what.toStack(Ints.saturatedCast((long)extracted));
                    break;
                }
            }
            if (currentItem.isEmpty()) {
                currentItem = this.takeIngredientFromPlayer(cct, player, ingredient);
            }
            if (currentItem.isEmpty() && cct.getStoneCutterInventory() != null) {
                currentItem = this.takeIngredientFromOtherGrid(cct, ingredient);
            }
            craftMatrix.setItemDirect(x, currentItem);
            if (!currentItem.isEmpty()) {
                cct.setStoneCutterRecipeId(this.recipeId);
            }
            if (!currentItem.isEmpty() || !this.craftMissing || craftingService == null) continue;
            int slot = x;
            this.findCraftableKey(ingredient, craftingService).ifPresent(key -> toAutoCraft.computeIfAbsent(key, k -> new IntArrayList()).add(slot));
        }
        menu.slotsChanged(craftMatrix.toContainer());
        if (!toAutoCraft.isEmpty()) {
            if (touchedGridStorage) {
                storageService.invalidateCache();
            }
            List<ICraftingGridMenu.AutoCraftEntry> stacks = toAutoCraft.entrySet().stream().map(e -> new ICraftingGridMenu.AutoCraftEntry((AEItemKey)e.getKey(), (List)e.getValue())).toList();
            cct.startAutoCrafting(stacks);
        }
        cct.setMode(ETTerminalMode.STONECUTTING);
    }

    @Override
    protected NonNullList<Ingredient> getDesiredIngredients(Player player) {
        Recipe recipe;
        Optional optionalRecipe;
        if (this.recipeId != null && (optionalRecipe = player.level().getRecipeManager().byKey(this.recipeId)).isPresent() && (recipe = ((RecipeHolder)optionalRecipe.get()).value()) instanceof SingleItemRecipe) {
            SingleItemRecipe recipe2 = (SingleItemRecipe)recipe;
            return recipe2.getIngredients();
        }
        return NonNullList.create();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

