/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.part.extendedterminal;

import appeng.api.inventories.InternalInventory;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.List;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.api.host.IETTerminalHost;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMenu;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMode;
import me.myogoo.extendedterminal.part.ETTerminalBasePart;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ETTerminalPart
extends ETTerminalBasePart
implements IETTerminalHost {
    @PartModels
    public static final ResourceLocation MODEL_OFF = ExtendedTerminal.makeId("part/extendedterminal/extended_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = ExtendedTerminal.makeId("part/extendedterminal/extended_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    public static final ResourceLocation SmithingInventory = ExtendedTerminal.makeId("smithing_crafting_inventory");
    public static final ResourceLocation StoneCutterInventory = ExtendedTerminal.makeId("stonecutter_crafting_inventory");
    public static final ResourceLocation AnvilInventory = ExtendedTerminal.makeId("anvil_inventory");
    public static final ResourceLocation UpgradeInventory = ExtendedTerminal.makeId("upgrade_inventory");
    private final AppEngInternalInventory smithingGrid = new AppEngInternalInventory((InternalInventoryHost)this, 3);
    private final AppEngInternalInventory stoneCutterGrid = new AppEngInternalInventory((InternalInventoryHost)this, 1);
    private final AppEngInternalInventory anvilInv = new AppEngInternalInventory((InternalInventoryHost)this, 2);
    private ETTerminalMode mode = ETTerminalMode.loadableValues().getFirst();
    @Nullable
    private ResourceLocation stonecuttingRecipeId;
    private boolean isLoading = false;

    public ETTerminalPart(IPartItem<?> partItem) {
        super(partItem, ETMenuType.ET_TERMINAL);
    }

    @Override
    public void clearContent() {
        super.clearContent();
        this.smithingGrid.clear();
        this.stoneCutterGrid.clear();
        this.anvilInv.clear();
    }

    public MenuType<?> getMenuType(Player p) {
        return ETTerminalMenu.TYPE;
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_ON, MODELS_OFF, MODELS_HAS_CHANNEL);
    }

    @Override
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)SmithingInventory)) {
            return this.smithingGrid;
        }
        if (id.equals((Object)StoneCutterInventory)) {
            return this.stoneCutterGrid;
        }
        if (id.equals((Object)AnvilInventory)) {
            return this.anvilInv;
        }
        if (id.equals((Object)UpgradeInventory)) {
            // empty if block
        }
        return super.getSubInventory(id);
    }

    @Override
    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.putString("mode", this.mode.name());
        if (this.stonecuttingRecipeId != null) {
            data.putString("stonecuttingRecipeId", this.stonecuttingRecipeId.toString());
        }
        this.smithingGrid.writeToNBT(data, "smithingGrid", registries);
        this.stoneCutterGrid.writeToNBT(data, "stoneCutterGrid", registries);
        this.anvilInv.writeToNBT(data, "anvilInv", registries);
    }

    public void saveChanges() {
        if (!this.isLoading) {
            super.saveChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        this.isLoading = false;
        try {
            super.readFromNBT(data, registries);
            try {
                this.mode = ETTerminalMode.valueOf(data.getString("mode"));
            }
            catch (IllegalArgumentException ignored) {
                this.mode = ETTerminalMode.CRAFTING;
            }
            this.stonecuttingRecipeId = data.contains("stonecuttingRecipeId", 8) ? ResourceLocation.parse((String)data.getString("stonecuttingRecipeId")) : null;
            this.smithingGrid.readFromNBT(data, "smithingGrid", registries);
            this.stoneCutterGrid.readFromNBT(data, "stoneCutterGrid", registries);
            this.anvilInv.readFromNBT(data, "anvilInv", registries);
        }
        finally {
            this.isLoading = false;
        }
    }

    @Override
    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        for (ItemStack is : this.smithingGrid) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
        for (ItemStack is : this.stoneCutterGrid) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
        for (ItemStack is : this.anvilInv) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
    }

    @Override
    public ETTerminalMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(ETTerminalMode mode) {
        this.mode = mode;
        this.saveChanges();
    }

    @Override
    @Nullable
    public ResourceLocation getStoneCutterRecipeId() {
        return this.stonecuttingRecipeId;
    }

    @Override
    public void setStoneCutterRecipeId(@Nullable ResourceLocation stonecuttingRecipeId) {
        this.stonecuttingRecipeId = stonecuttingRecipeId;
        this.saveChanges();
    }

    protected IPartModel selectModel(IPartModel offModels, IPartModel onModels, IPartModel hasChannelModels) {
        return super.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }
}

