/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.api.adapter.recipe;

import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ITierCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import java.util.Optional;
import me.myogoo.extendedterminal.adapter.recipe.ShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.adapter.recipe.ShapelessTableRecipeAdapter;
import me.myogoo.extendedterminal.api.ModAccessor;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.byAqua3.avaritia.recipe.RecipeExtremeShapeless;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public interface ITableRecipeAdapter {
    public <R extends Recipe<?>> Optional<R> unwrap(Class<R> var1);

    public <R extends Recipe<?>> R recipe();

    public ResourceLocation recipeId();

    public int tier();

    @ModAccessor.ExtendedCrafting
    public static ITableRecipeAdapter of(ITableRecipe recipe) {
        if (recipe instanceof ShapedTableRecipe) {
            ShapedTableRecipe shaped = (ShapedTableRecipe)recipe;
            return new ShapedTableRecipeAdapter(shaped);
        }
        if (recipe instanceof ShapelessTableRecipe) {
            ShapelessTableRecipe shapeless = (ShapelessTableRecipe)recipe;
            return new ShapelessTableRecipeAdapter(shapeless);
        }
        throw new IllegalArgumentException("Unknown ITableRecipe implementation: " + recipe.getClass().getName());
    }

    @ModAccessor.ReAvaritia
    public static ITableRecipeAdapter of(ITierCraftingRecipe recipe) {
        if (recipe instanceof ShapedTableCraftingRecipe) {
            ShapedTableCraftingRecipe shaped = (ShapedTableCraftingRecipe)recipe;
            return new ShapedTableRecipeAdapter(shaped);
        }
        if (recipe instanceof ShapelessTableCraftingRecipe) {
            ShapelessTableCraftingRecipe shapeless = (ShapelessTableCraftingRecipe)recipe;
            return new ShapelessTableRecipeAdapter(shapeless);
        }
        if (recipe instanceof EternalSingularityCraftRecipe) {
            EternalSingularityCraftRecipe singularityRecipe = (EternalSingularityCraftRecipe)recipe;
            return new ShapelessTableRecipeAdapter(singularityRecipe);
        }
        if (recipe instanceof InfinityCatalystCraftRecipe) {
            InfinityCatalystCraftRecipe infinityRecipe = (InfinityCatalystCraftRecipe)recipe;
            return new ShapelessTableRecipeAdapter(infinityRecipe);
        }
        throw new IllegalArgumentException("Unknown BaseTableCraftingRecipe implementation: " + recipe.getClass().getName());
    }

    @ModAccessor.AvaritiaNeo
    public static ITableRecipeAdapter of(RecipeExtremeCrafting recipe) {
        if (recipe instanceof RecipeExtremeShaped) {
            RecipeExtremeShaped shaped = (RecipeExtremeShaped)recipe;
            return new ShapedTableRecipeAdapter(shaped);
        }
        if (recipe instanceof RecipeExtremeShapeless) {
            RecipeExtremeShapeless shapeless = (RecipeExtremeShapeless)recipe;
            return new ShapelessTableRecipeAdapter(shapeless);
        }
        throw new IllegalArgumentException("Unknown RecipeExtremeCrafting implementation: " + recipe.getClass().getName());
    }
}

