/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.init;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartModels;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import me.myogoo.extendedterminal.init.ETItems;
import me.myogoo.extendedterminal.item.partitem.EmptyPartItem;
import me.myogoo.extendedterminal.item.partitem.ExtendedCraftingPartItem;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.part.EmptyPart;
import me.myogoo.extendedterminal.part.avaritiaNeo.NeoExtremeTerminalPart;
import me.myogoo.extendedterminal.part.avaritiaRe.EndTerminalPart;
import me.myogoo.extendedterminal.part.avaritiaRe.ExtremeTerminalPart;
import me.myogoo.extendedterminal.part.avaritiaRe.NetherTerminalPart;
import me.myogoo.extendedterminal.part.avaritiaRe.SculkTerminalPart;
import me.myogoo.extendedterminal.part.extendedcrafting.AdvancedTerminalPart;
import me.myogoo.extendedterminal.part.extendedcrafting.BasicExtendedTerminalPart;
import me.myogoo.extendedterminal.part.extendedcrafting.EliteTerminalPart;
import me.myogoo.extendedterminal.part.extendedcrafting.EpicTerminalPart;
import me.myogoo.extendedterminal.part.extendedcrafting.UltimateTerminalPart;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;

public class ETParts {
    public static final DeferredRegister<Item> REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"extendedterminal");
    public static final List<ItemDefinition<? extends PartItem<?>>> PARTS = new ArrayList();
    public static final List<ItemDefinition<? extends PartItem<?>>> TERMINAL_PARTS = new ArrayList();
    public static final ItemDefinition<PartItem<BasicExtendedTerminalPart>> BASIC_TERMINAL_PART = ETParts.createExtendedCraftingPart(ETMenuType.BASIC_TERMINAL, BasicExtendedTerminalPart.class, BasicExtendedTerminalPart::new);
    public static final ItemDefinition<PartItem<AdvancedTerminalPart>> ADVANCED_TERMINAL_PART = ETParts.createExtendedCraftingPart(ETMenuType.ADVANCED_TERMINAL, AdvancedTerminalPart.class, AdvancedTerminalPart::new);
    public static final ItemDefinition<PartItem<EliteTerminalPart>> ELITE_TERMINAL_PART = ETParts.createExtendedCraftingPart(ETMenuType.ELITE_TERMINAL, EliteTerminalPart.class, EliteTerminalPart::new);
    public static final ItemDefinition<PartItem<UltimateTerminalPart>> ULTIMATE_TERMINAL_PART = ETParts.createExtendedCraftingPart(ETMenuType.ULTIMATE_TERMINAL, UltimateTerminalPart.class, UltimateTerminalPart::new);
    public static final ItemDefinition<PartItem<EpicTerminalPart>> EPIC_TERMINAL_PART = ETParts.createExtendedCraftingPart(ETMenuType.EPIC_TERMINAL, EpicTerminalPart.class, EpicTerminalPart::new);
    public static final ItemDefinition<PartItem<SculkTerminalPart>> SCULK_TERMINAL_PART = ETParts.createTerminalPart(ETMenuType.SCULK_TERMINAL, SculkTerminalPart.class, SculkTerminalPart::new);
    public static final ItemDefinition<PartItem<NetherTerminalPart>> NETHER_TERMINAL_PART = ETParts.createTerminalPart(ETMenuType.NETHER_TERMINAL, NetherTerminalPart.class, NetherTerminalPart::new);
    public static final ItemDefinition<PartItem<EndTerminalPart>> END_TERMINAL_PART = ETParts.createTerminalPart(ETMenuType.END_TERMINAL, EndTerminalPart.class, EndTerminalPart::new);
    public static final ItemDefinition<PartItem<ExtremeTerminalPart>> EXTREME_TERMINAL_PART = ETParts.createTerminalPart(ETMenuType.EXTREME_TERMINAL, ExtremeTerminalPart.class, ExtremeTerminalPart::new);
    public static final ItemDefinition<PartItem<NeoExtremeTerminalPart>> NEO_EXTREME_TERMINAL_PART = ETParts.createTerminalPart(ETMenuType.NEO_EXTREME_TERMINAL, NeoExtremeTerminalPart.class, NeoExtremeTerminalPart::new);

    private static <T extends IPart, I extends PartItem<T>> ItemDefinition<I> createPart(ETMenuType menuType, Class<T> partClass, Function<Item.Properties, I> propertiesFactory, boolean terminalPart) {
        if (!menuType.canLoad()) {
            ItemDefinition definition = new ItemDefinition(menuType.getEnglishName(), menuType.getId(), new EmptyPartItem<EmptyPart>(new Item.Properties(), EmptyPart.class, EmptyPart::new));
            REGISTER.register(definition.id().m_135815_(), () -> ((ItemDefinition)definition).m_5456_());
            return definition;
        }
        PartModels.registerModels((Collection)PartModelsHelper.createModels(partClass));
        ItemDefinition<I> definition = ETItems.createItem(menuType.getEnglishName(), menuType.getId(), propertiesFactory);
        PARTS.add(definition);
        if (terminalPart) {
            TERMINAL_PARTS.add(definition);
        }
        return definition;
    }

    private static <T extends IPart> ItemDefinition<PartItem<T>> createTerminalPart(ETMenuType menuType, Class<T> partClass, Function<IPartItem<T>, T> partFactory) {
        return ETParts.createPart(menuType, partClass, p -> new PartItem(p, partClass, partFactory), true);
    }

    private static <T extends IPart> ItemDefinition<PartItem<T>> createExtendedCraftingPart(ETMenuType menuType, Class<T> partClass, Function<IPartItem<T>, T> partFactory) {
        return ETParts.createPart(menuType, partClass, p -> new ExtendedCraftingPartItem((Item.Properties)p, menuType, partClass, partFactory), true);
    }
}

