/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.emi.avaritiaNeo.handler;

import appeng.core.localization.ItemModText;
import appeng.menu.me.items.CraftingTermMenu;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import java.util.HashMap;
import java.util.Map;
import me.myogoo.extendedterminal.api.adapter.recipe.IShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.ITableRecipeAdapter;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.integration.emi.handler.AbstractTableRecipeHandler;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.avaritiaNeo.NeoExtremeTerminalMenu;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class AVNeoEmiRecipeHandler
extends AbstractTableRecipeHandler<NeoExtremeTerminalMenu> {
    private final ETMenuType menuType;
    private final EmiRecipeCategory category;

    public AVNeoEmiRecipeHandler(EmiRecipeCategory category, Class<NeoExtremeTerminalMenu> containerClass, ETMenuType menuType) {
        super(containerClass);
        this.menuType = menuType;
        this.category = category;
    }

    @Override
    protected AbstractTableRecipeHandler.Result transferRecipe(NeoExtremeTerminalMenu menu, EmiRecipe emiRecipe, boolean doTransfer) {
        Recipe recipe = emiRecipe.getBackingRecipe();
        boolean craftingRecipe = this.isCraftingRecipe(recipe, emiRecipe);
        if (!craftingRecipe) {
            return AbstractTableRecipeHandler.Result.createNotApplicable();
        }
        if (!this.fitsInNxNGrid(recipe, emiRecipe, this.menuType.getGridSize())) {
            return AbstractTableRecipeHandler.Result.createFailed((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (!(recipe instanceof RecipeExtremeCrafting)) {
            return AbstractTableRecipeHandler.Result.createFailed((Component)ItemModText.INCOMPATIBLE_RECIPE.text());
        }
        RecipeExtremeCrafting tableRecipe = (RecipeExtremeCrafting)recipe;
        ITableRecipeAdapter adapterRecipe = ITableRecipeAdapter.of(tableRecipe);
        Map<Integer, Ingredient> slotToIngredientMap = this.getGuiSlotToIngredientMap(menu, adapterRecipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = menu.findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            return AbstractTableRecipeHandler.Result.createFailed((Component)ItemModText.NO_ITEMS.text(), missingSlots.missingSlots());
        }
        if (!doTransfer) {
            if (missingSlots.anyMissingOrCraftable()) {
                return new AbstractTableRecipeHandler.Result.PartiallyCraftable(missingSlots);
            }
        } else {
            boolean craftMissing = AbstractContainerScreen.m_96637_();
            this.performTransfer(menu, emiRecipe.getId(), adapterRecipe, craftMissing);
        }
        return AbstractTableRecipeHandler.Result.createSuccessful();
    }

    @Override
    protected boolean isCraftingRecipe(Recipe<?> recipe, EmiRecipe emiRecipe) {
        return emiRecipe.getCategory().equals(this.category);
    }

    @Override
    protected Map<Integer, Ingredient> getGuiSlotToIngredientMap(NeoExtremeTerminalMenu menu, ITableRecipeAdapter recipe) {
        NonNullList<Ingredient> ingredients;
        int gridSideLength = menu.getCraftingGridWidth();
        NonNullList<Ingredient> raw = recipe.recipe().m_7527_();
        int width = gridSideLength;
        int height = gridSideLength;
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedRecipe = (IShapedTableRecipeAdapter)recipe;
            ingredients = ItemListTermCraftingHelper.ensureFittedCraftingGrid(shapedRecipe);
            width = shapedRecipe.width();
            height = shapedRecipe.height();
        } else {
            ingredients = raw;
        }
        int max = gridSideLength * gridSideLength;
        int count = Math.min(ingredients.size(), max);
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(count);
        for (int i = 0; i < count; ++i) {
            int x = i % width;
            int y = i / width;
            int guiSlot = y * width + x;
            Ingredient ing = (Ingredient)ingredients.get(i);
            if (ing.m_43947_()) continue;
            result.put(guiSlot, ing);
        }
        return result;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory().equals(this.category);
    }
}

