/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.jei.extendedcrafting.handler;

import appeng.core.localization.ItemModText;
import appeng.menu.me.items.CraftingTermMenu;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.myogoo.extendedterminal.api.adapter.recipe.IShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.ITableRecipeAdapter;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.integration.jei.handler.AbstractTableRecipeHandler;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.extendedcrafting.ExtendedTerminalBaseMenu;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class ECJeiRecipeTransferHandler<T extends ExtendedTerminalBaseMenu>
extends AbstractTableRecipeHandler<T, ITableRecipe> {
    private final IRecipeTransferHandlerHelper helper;

    public ECJeiRecipeTransferHandler(Class<T> containerClass, MenuType<T> container, RecipeType<ITableRecipe> recipeType, IRecipeTransferHandlerHelper helper) {
        super(containerClass, container, recipeType);
        this.helper = helper;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T menu, ITableRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.m_7527_().isEmpty()) {
            return AbstractTableRecipeHandler.Result.createInCompatibleError(this.helper);
        }
        if (!recipe.m_8004_(((ExtendedTerminalBaseMenu)((Object)menu)).getCraftingGridWidth(), ((ExtendedTerminalBaseMenu)((Object)menu)).getCraftingGridHeight())) {
            return AbstractTableRecipeHandler.Result.createRecipeToLargeError(this.helper);
        }
        boolean craftMissing = AbstractContainerScreen.m_96637_();
        List inputSlots = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        ITableRecipeAdapter adapterRecipe = ITableRecipeAdapter.of(recipe);
        Map<Integer, Ingredient> slotToIngredientMap = this.getGuiSlotToIngredientMap(menu, adapterRecipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((ETTerminalBaseMenu)((Object)menu)).findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            List<IRecipeSlotView> missingSlotViews = missingSlots.missingSlots().stream().map(idx -> idx < inputSlots.size() ? (IRecipeSlotView)inputSlots.get((int)idx) : null).filter(Objects::nonNull).toList();
            return this.helper.createUserErrorForMissingSlots((Component)ItemModText.NO_ITEMS.text(), missingSlotViews);
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                int color = missingSlots.anyMissing() ? -2130729728 : -2142943745;
                return new AbstractTableRecipeHandler.Result.PartiallyCraftable(missingSlots, color, craftMissing);
            }
        } else {
            ECJeiRecipeTransferHandler.performTransfer(menu, adapterRecipe, craftMissing);
        }
        return AbstractTableRecipeHandler.Result.createSuccessful();
    }

    @Override
    public Map<Integer, Ingredient> getGuiSlotToIngredientMap(T menu, ITableRecipeAdapter recipe) {
        NonNullList<Ingredient> ingredients;
        int gridSideLength = ((ExtendedTerminalBaseMenu)((Object)menu)).getCraftingGridWidth();
        NonNullList<Ingredient> raw = recipe.recipe().m_7527_();
        int offsetX = 0;
        int offsetY = 0;
        int width = gridSideLength;
        int height = gridSideLength;
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedRecipe = (IShapedTableRecipeAdapter)recipe;
            ingredients = ItemListTermCraftingHelper.ensureFittedCraftingGrid(shapedRecipe);
            width = shapedRecipe.width();
            height = shapedRecipe.height();
            offsetX = Math.floorDiv(gridSideLength - shapedRecipe.width(), 2);
            offsetY = Math.floorDiv(gridSideLength - shapedRecipe.height(), 2);
        } else {
            ingredients = raw;
        }
        int max = gridSideLength * gridSideLength;
        int count = Math.min(ingredients.size(), max);
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(count);
        for (int i = 0; i < count; ++i) {
            int x = i % width;
            int y = i / width;
            int guiSlot = (y + offsetY) * gridSideLength + (x + offsetX);
            Ingredient ing = (Ingredient)ingredients.get(i);
            if (ing.m_43947_()) continue;
            result.put(guiSlot, ing);
        }
        return result;
    }
}

