/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.avaritiaRe;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ITerminalHost;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantic;
import appeng.menu.slot.CraftingMatrixSlot;
import com.google.common.base.Preconditions;
import committee.nova.mods.avaritia.common.crafting.recipe.ITierCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import me.myogoo.extendedterminal.api.config.IETTerminalConfig;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.avaritiaRe.slot.AvaritiaCraftingTerminalSlot;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class AvaritiaTerminalBaseMenu
extends ETTerminalBaseMenu<ITierCraftingRecipe> {
    private final AvaritiaCraftingTerminalSlot outputSlot;
    private final ISegmentedInventory craftingInventoryHost;
    private final CraftingMatrixSlot[] craftingSlots;
    private final CraftingContainer recipeTestContainer;

    public AvaritiaTerminalBaseMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host, ETMenuType etMenuType, IETTerminalConfig config) {
        super(menuType, id, ip, host, etMenuType, config);
        this.craftingInventoryHost = (ISegmentedInventory)host;
        this.craftingSlots = new CraftingMatrixSlot[this.menuType.getGridSize()];
        this.recipeTestContainer = new TransientCraftingContainer((AbstractContainerMenu)this, this.menuType.getGridSideLength(), this.menuType.getGridSideLength());
        InternalInventory craftingGridInv = this.craftingInventoryHost.getSubInventory(this.menuType.getCraftingInventory());
        for (int i = 0; i < this.menuType.getGridSize(); ++i) {
            this.craftingSlots[i] = new CraftingMatrixSlot((AEBaseMenu)this, craftingGridInv, i);
            this.addSlot((Slot)this.craftingSlots[i], this.menuType.getSlotSemanticGrid());
        }
        this.outputSlot = new AvaritiaCraftingTerminalSlot(this.getPlayerInventory().f_35978_, this.getActionSource(), this.powerSource, host.getInventory(), craftingGridInv, craftingGridInv, this, this.menuType);
        this.addSlot((Slot)this.outputSlot, this.menuType.getSlotSemanticResult());
        this.updateCurrentRecipeAndOutput(true);
    }

    @Override
    public void clearCraftingGrid() {
        Preconditions.checkState((boolean)this.isClientSide());
        CraftingMatrixSlot slot = this.craftingSlots[0];
        InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slot.f_40219_, 0L);
        NetworkHandler.instance().sendToServer((BasePacket)p);
    }

    @Override
    protected void updateCurrentRecipeAndOutput(boolean forceUpdate) {
        if (this.checkCraftingOnlyActive()) {
            return;
        }
        boolean hasChanged = forceUpdate;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            ItemStack stack = this.craftingSlots[x].m_7993_();
            if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.recipeTestContainer.m_8020_(x))) continue;
            hasChanged = true;
            this.recipeTestContainer.m_6836_(x, stack.m_41777_());
        }
        if (!hasChanged) {
            return;
        }
        Level level = this.getPlayerInventory().f_35978_.m_9236_();
        this.currentRecipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get(), (Container)this.recipeTestContainer, level).orElse(null);
        if (this.currentRecipe == null) {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        } else {
            this.outputSlot.m_5852_(((ITierCraftingRecipe)this.currentRecipe).m_5874_((Container)this.recipeTestContainer, level.m_9598_()));
        }
    }

    @Override
    public SlotSemantic getCraftingGridSlotSemantic() {
        return this.menuType.getSlotSemanticGrid();
    }

    @Override
    public SlotSemantic getOutputSlotSemantic() {
        return this.menuType.getSlotSemanticResult();
    }

    @Override
    public int getCraftingGridSize() {
        return this.menuType.getGridSize();
    }

    @Override
    public int getCraftingGridWidth() {
        return this.menuType.getGridSideLength();
    }

    @Override
    public int getCraftingGridHeight() {
        return this.menuType.getGridSideLength();
    }

    public InternalInventory getCraftingMatrix() {
        return this.craftingInventoryHost.getSubInventory(this.menuType.getCraftingInventory());
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        Slot s = this.m_38853_(slot);
        if (s instanceof AvaritiaCraftingTerminalSlot) {
            AvaritiaCraftingTerminalSlot craftingSlot = (AvaritiaCraftingTerminalSlot)s;
            switch (action) {
                case CRAFT_SHIFT: 
                case CRAFT_ALL: 
                case CRAFT_ITEM: 
                case CRAFT_STACK: {
                    craftingSlot.doClick(action, (Player)player);
                }
            }
            return;
        }
        super.doAction(player, action, slot, id);
    }
}

