/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.network.serverbound;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.helpers.IMenuCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.network.NetworkPacketType;
import me.myogoo.extendedterminal.network.serverbound.FillRecipeBasePacket;
import me.myogoo.extendedterminal.util.extendedcrafting.TableCraftingHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public class ETFillCraftingGridFromRecipePacket
extends FillRecipeBasePacket {
    public static final int NOT_SET_RECIPE_SIZE = -1;
    @Nullable
    private ResourceLocation recipeId = null;
    private List<ItemStack> ingredientTemplates;
    private boolean craftMissing;
    private int recipeWidth;
    private int recipeHeight;

    public ETFillCraftingGridFromRecipePacket(FriendlyByteBuf stream) {
        if (stream.readBoolean()) {
            this.recipeId = stream.m_130281_();
        }
        this.ingredientTemplates = NonNullList.m_122780_((int)stream.readInt(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.ingredientTemplates.size(); ++i) {
            this.ingredientTemplates.set(i, stream.m_130267_());
        }
        this.craftMissing = stream.readBoolean();
        this.recipeWidth = stream.readInt();
        this.recipeHeight = stream.readInt();
    }

    public ETFillCraftingGridFromRecipePacket(@Nullable ResourceLocation recipeId, List<ItemStack> ingredientTemplates, boolean craftMissing, int recipeWidth, int recipeHeight) {
        FriendlyByteBuf stream = new FriendlyByteBuf(Unpooled.buffer());
        stream.writeInt(NetworkPacketType.PacketIDs.TABLE_FILL_CRAFTING_GRID.getValue());
        if (recipeId != null) {
            stream.writeBoolean(true);
            stream.m_130085_(recipeId);
        } else {
            stream.writeBoolean(false);
        }
        stream.writeInt(ingredientTemplates.size());
        for (ItemStack ingredientTemplate : ingredientTemplates) {
            stream.m_130055_(ingredientTemplate);
        }
        stream.writeBoolean(craftMissing);
        stream.writeInt(recipeWidth);
        stream.writeInt(recipeHeight);
        this.configureWrite(stream);
    }

    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu menu = player.f_36096_;
        if (!(menu instanceof IMenuCraftingPacket)) {
            return;
        }
        IMenuCraftingPacket cct = (IMenuCraftingPacket)menu;
        IGridNode node = cct.getNetworkNode();
        if (node == null) {
            return;
        }
        @Nullable ICraftingService craftingService = node.getGrid().getCraftingService();
        @Nullable IStorageService storageService = node.getGrid().getStorageService();
        MEStorage networkStorage = storageService.getInventory();
        KeyCounter cachedStorage = storageService.getCachedInventory();
        IEnergyService energy = node.getGrid().getEnergyService();
        InternalInventory craftMatrix = cct.getCraftingMatrix();
        IPartitionList filter = ViewCellItem.createItemFilter((Collection)cct.getViewCells());
        NonNullList<Ingredient> ingredients = this.getDesiredIngredients((Player)player);
        LinkedHashMap toAutoCraft = new LinkedHashMap();
        boolean touchedGridStorage = false;
        for (int x = 0; x < craftMatrix.size(); ++x) {
            ItemStack currentItem = craftMatrix.getStackInSlot(x);
            Ingredient ingredient = (Ingredient)ingredients.get(x);
            if (!currentItem.m_41619_()) {
                if (ingredient.test(currentItem)) continue;
                AEItemKey in = AEItemKey.of((ItemStack)currentItem);
                long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkStorage, (AEKey)in, (long)currentItem.m_41613_(), (IActionSource)cct.getActionSource());
                if (inserted > 0L) {
                    touchedGridStorage = true;
                }
                if (inserted < (long)currentItem.m_41613_()) {
                    currentItem = currentItem.m_41777_();
                    currentItem.m_41774_((int)inserted);
                } else {
                    currentItem = ItemStack.f_41583_;
                }
                player.m_150109_().m_36054_(currentItem);
                craftMatrix.setItemDirect(x, currentItem.m_41619_() ? ItemStack.f_41583_ : currentItem);
            }
            if (ingredient.m_43947_()) continue;
            if (currentItem.m_41619_()) {
                List<AEItemKey> request = this.findBestMatchingItemStack(ingredient, filter, cachedStorage);
                for (AEItemKey what : request) {
                    long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)networkStorage, (AEKey)what, (long)1L, (IActionSource)cct.getActionSource());
                    if (extracted <= 0L) continue;
                    touchedGridStorage = true;
                    currentItem = what.toStack(Ints.saturatedCast((long)extracted));
                    break;
                }
            }
            if (currentItem.m_41619_()) {
                currentItem = this.takeIngredientFromPlayer(cct, player, ingredient);
            }
            craftMatrix.setItemDirect(x, currentItem);
            if (!currentItem.m_41619_() || !this.craftMissing || craftingService == null) continue;
            int slot = x;
            this.findCraftableKey(ingredient, craftingService).ifPresent(key -> toAutoCraft.computeIfAbsent(key, k -> new IntArrayList()).add(slot));
        }
        menu.m_6199_(craftMatrix.toContainer());
        if (!toAutoCraft.isEmpty()) {
            if (touchedGridStorage) {
                storageService.invalidateCache();
            }
            List<IMenuCraftingPacket.AutoCraftEntry> stacks = toAutoCraft.entrySet().stream().map(e -> new IMenuCraftingPacket.AutoCraftEntry((AEItemKey)e.getKey(), (List)e.getValue())).toList();
            cct.startAutoCrafting(stacks);
        }
    }

    @Override
    protected NonNullList<Ingredient> getDesiredIngredients(Player player) {
        Optional recipe;
        if (this.recipeId != null && (recipe = player.m_9236_().m_7465_().m_44043_(this.recipeId)).isPresent()) {
            return ItemListTermCraftingHelper.ensureNxNTableCraftingGrid((Recipe)recipe.get(), this.ingredientTemplates.size(), this.recipeWidth, this.recipeHeight);
        }
        NonNullList ingredients = NonNullList.m_122780_((int)this.ingredientTemplates.size(), (Object)Ingredient.f_43901_);
        Preconditions.checkArgument((ingredients.size() == this.ingredientTemplates.size() ? 1 : 0) != 0, (String)"Got %d ingredient templates from client, expected %d", (int)this.ingredientTemplates.size(), (int)ingredients.size());
        if (this.recipeWidth == -1 || this.recipeHeight == -1) {
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack template = this.ingredientTemplates.get(i);
                if (template.m_41619_()) continue;
                ingredients.set(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{template}));
            }
        } else {
            int cursor = 0;
            TableCraftingHelper.GridCoordinate coordinator = TableCraftingHelper.indexToCoordinate(this.ingredientTemplates.size(), this.recipeWidth, this.recipeHeight);
            for (int i = 0; i < ingredients.size(); ++i) {
                if (!coordinator.test(i)) continue;
                ingredients.set(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.ingredientTemplates.get(cursor++)}));
            }
        }
        return ingredients;
    }
}

