/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.util.extendedcrafting;

import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapedTableRecipeBuilder
extends ShapedRecipeBuilder {
    private int tier = 0;

    private ShapedTableRecipeBuilder(ItemLike result, int count) {
        super(RecipeCategory.MISC, result, count);
    }

    public static ShapedTableRecipeBuilder shaped(ItemLike result, int count) {
        return new ShapedTableRecipeBuilder(result, count);
    }

    public ShapedTableRecipeBuilder define(Character c, ItemLike item) {
        super.m_126127_(c, item);
        return this;
    }

    public ShapedTableRecipeBuilder define(Character c, Ingredient ingredient) {
        super.m_126124_(c, ingredient);
        return this;
    }

    public ShapedTableRecipeBuilder pattern(String row) {
        super.m_126130_(row);
        return this;
    }

    public ShapedTableRecipeBuilder setTier(int tier) {
        if (tier < 0 || tier > 4) {
            throw new IllegalArgumentException("Tier must be between 0 and 4");
        }
        this.tier = tier;
        return this;
    }

    private void m_126143_(ResourceLocation recipeId) {
        if (this.f_126108_.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + recipeId + "!");
        }
        HashSet set = Sets.newHashSet(this.f_126109_.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.f_126108_) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.f_126109_.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + recipeId + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + recipeId);
        }
        if (this.f_126108_.size() == 1 && ((String)this.f_126108_.get(0)).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + recipeId + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeOutput, ResourceLocation id) {
        this.m_126143_(id);
        recipeOutput.accept(new Result(id));
    }

    class Result
    implements FinishedRecipe {
        private final ResourceLocation id;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
        }

        @NotNull
        public JsonObject m_125966_() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "extendedcrafting:shaped_table");
            if (ShapedTableRecipeBuilder.this.tier != 0) {
                json.addProperty("tier", (Number)ShapedTableRecipeBuilder.this.tier);
            }
            JsonArray jsonArray = new JsonArray();
            for (Object s : ShapedTableRecipeBuilder.this.f_126108_) {
                jsonArray.add((String)s);
            }
            json.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : ShapedTableRecipeBuilder.this.f_126109_.entrySet()) {
                jsonObject.add(String.valueOf(entry.getKey()), ((Ingredient)entry.getValue()).m_43942_());
            }
            json.add("key", (JsonElement)jsonObject);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)ShapedTableRecipeBuilder.this.f_126106_).toString());
            if (ShapedTableRecipeBuilder.this.f_126107_ > 1) {
                resultObject.addProperty("count", (Number)ShapedTableRecipeBuilder.this.f_126107_);
            }
            json.add("result", (JsonElement)resultObject);
            return json;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return new ShapedTableRecipe.Serializer();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

