/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.util.mod;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.util.mod.SupportedMod;
import org.slf4j.Logger;

public final class ModIntegrationManager {
    private static final Logger LOGGER = ExtendedTerminal.LOGGER;
    private static final Map<SupportedMod, Class<? extends Annotation>> activeIntegrations = new HashMap<SupportedMod, Class<? extends Annotation>>();

    public static void initialize() {
        LOGGER.info("Checking for mod integrations...");
        activeIntegrations.clear();
        for (SupportedMod mod : SupportedMod.values()) {
            if (!mod.isLoaded()) continue;
            activeIntegrations.put(mod, mod.getAnnotationClass());
            LOGGER.info("Integration enabled for: {}", (Object)mod.name());
        }
    }

    public static Class<? extends Annotation> getClass(SupportedMod mod) {
        return activeIntegrations.get((Object)mod);
    }

    public static Class<? extends Annotation> getClass(String modId) {
        for (Class<? extends Annotation> value : activeIntegrations.values()) {
            if (!value.getSimpleName().equals(modId)) continue;
            return value;
        }
        return null;
    }

    public static boolean isLoaded(Class<? extends Annotation> annotationClass) {
        return activeIntegrations.containsValue(annotationClass);
    }

    public static boolean isLoaded(SupportedMod mod) {
        return activeIntegrations.containsKey((Object)mod);
    }

    private ModIntegrationManager() {
    }
}

