/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.client.screen.extendedterminal.gui.panels;

import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.AETextField;
import me.myogoo.extendedterminal.client.screen.extendedterminal.ETTerminalScreen;
import me.myogoo.extendedterminal.client.screen.extendedterminal.gui.ETTerminalModePanel;
import me.myogoo.extendedterminal.client.screen.extendedterminal.gui.XPLabelWidget;
import me.myogoo.extendedterminal.menu.ETSlotSemantics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;

public class AnvilPanel
extends ETTerminalModePanel {
    private static final Blitter BG = Blitter.texture((String)"guis/et_terminal_panel.png", (int)512, (int)512).src(0, 201, 159, 65);
    private final AETextField textField;
    private final XPLabelWidget enchantCostLabel;
    private Component anvilInfoText;

    public AnvilPanel(ETTerminalScreen<?> screen, WidgetContainer widgets) {
        super(screen, widgets);
        this.textField = widgets.addTextField("ET_ANVIL_NAME_FIELD");
        this.textField.setMaxLength(50);
        this.textField.setResponder(this::onNameChanged);
        this.enchantCostLabel = new XPLabelWidget();
        widgets.add("ET_ANVIL_COST_LABEL", (ICompositeWidget)this.enchantCostLabel);
        this.setVisible(false);
    }

    @Override
    public ItemStack getIcon() {
        return Blocks.ANVIL.asItem().getDefaultInstance();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.screen.setSlotsHidden(ETSlotSemantics.ANVIL_RIGHT_INPUT, !visible);
        this.screen.setSlotsHidden(ETSlotSemantics.ANVIL_LEFT_INPUT, !visible);
        this.screen.setSlotsHidden(ETSlotSemantics.ANVIL_RESULT, !visible);
        this.enchantCostLabel.setVisible(visible);
        this.textField.setVisible(visible);
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        BG.dest(bounds.getX() + 8, bounds.getY() + bounds.getHeight() - 165).blit(guiGraphics);
    }

    private void onNameChanged(String input) {
        Slot slot = (Slot)this.menu.getSlots(ETSlotSemantics.ANVIL_LEFT_INPUT).getFirst();
        if (slot.hasItem()) {
            String name = input;
            if (!slot.getItem().has(DataComponents.CUSTOM_NAME) && input.equals(slot.getItem().getHoverName().getString())) {
                name = "";
            }
            this.menu.setAnvilItemName(name);
        }
    }

    public void updateBeforeRender() {
        this.enchantCostLabel.setCost(this.menu.getanvilCost());
    }
}

