/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.guideme;

import guideme.compiler.PageCompiler;
import guideme.compiler.TagCompiler;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.document.block.LytHeading;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowText;
import guideme.libs.mdast.mdx.model.MdxJsxFlowElement;
import guideme.libs.mdast.model.MdAstParent;
import guideme.libs.unist.UnistNode;
import guideme.style.TextStyle;
import java.util.Set;
import me.myogoo.extendedterminal.util.mod.SupportedMod;

public class ConditionTag
implements TagCompiler {
    public void compileBlockContext(PageCompiler compiler, LytBlockContainer parent, MdxJsxFlowElement el) {
        String silently = el.getAttributeString("silent", "false");
        String condition = el.getAttributeString("load", "");
        if (condition.isEmpty()) {
            compiler.compileBlockContext((MdAstParent)el, parent);
        } else {
            try {
                SupportedMod mod = SupportedMod.valueOf(condition);
                if (mod.isLoaded()) {
                    compiler.compileBlockContext((MdAstParent)el, parent);
                } else {
                    if (silently.equals("true")) {
                        return;
                    }
                    LytHeading heading = new LytHeading();
                    LytFlowText frontText = new LytFlowText();
                    frontText.setText("This content is hidden because the mod ");
                    LytFlowText boldText = new LytFlowText();
                    boldText.setStyle(TextStyle.builder().bold(Boolean.valueOf(true)).build());
                    boldText.setText(mod.name());
                    LytFlowText endText = new LytFlowText();
                    endText.setText(" is not loaded.");
                    heading.setDepth(2);
                    heading.append((LytFlowContent)frontText);
                    heading.append((LytFlowContent)boldText);
                    heading.append((LytFlowContent)endText);
                    parent.append((LytBlock)heading);
                }
            }
            catch (IllegalArgumentException e) {
                parent.appendError(compiler, condition + "is not loaded", (UnistNode)el);
            }
        }
    }

    public Set<String> getTagNames() {
        return Set.of("et:condition");
    }
}

