/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.jei.extendedterminal.handler.pnael;

import appeng.api.stacks.AEItemKey;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.itemlists.EncodingHelper;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.CraftingTermMenu;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.integration.jei.extendedterminal.handler.ETTerminalBaseRecipeTransfer;
import me.myogoo.extendedterminal.integration.jei.handler.IAbstractRecipeHandler;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMenu;
import me.myogoo.extendedterminal.network.serverbound.FillStonecutterGridFromRecipePacket;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ETStonecutterRecipeTransfer<T extends ETTerminalMenu>
extends ETTerminalBaseRecipeTransfer<T, RecipeHolder<StonecutterRecipe>> {
    public ETStonecutterRecipeTransfer(MenuType<T> menuType, Class<T> classContainer, IRecipeTransferHandlerHelper helper) {
        super(menuType, classContainer, helper);
    }

    @Override
    protected Map<Integer, Ingredient> getGuiSlotToIngredientMap(ETTerminalMenu menu, RecipeHolder<StonecutterRecipe> recipeHolder) {
        StonecutterRecipe recipe = (StonecutterRecipe)recipeHolder.value();
        NonNullList ingredients = recipe.getIngredients();
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(ingredients.size());
        result.put(0, (Ingredient)ingredients.getFirst());
        return result;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T menu, RecipeHolder<StonecutterRecipe> recipeHolder, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        StonecutterRecipe recipe = (StonecutterRecipe)recipeHolder.value();
        boolean craftingMissing = AbstractContainerScreen.hasControlDown();
        List inputSlots = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        Map<Integer, Ingredient> slotToIngredientMap = this.getGuiSlotToIngredientMap((ETTerminalMenu)((Object)menu), recipeHolder);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((ETTerminalBaseMenu)((Object)menu)).findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            List<IRecipeSlotView> missingSlotViews = missingSlots.missingSlots().stream().map(idx -> idx < inputSlots.size() ? (IRecipeSlotView)inputSlots.get((int)idx) : null).filter(Objects::nonNull).toList();
            return this.helper.createUserErrorForMissingSlots((Component)ItemModText.NO_ITEMS.text(), missingSlotViews);
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                int color = missingSlots.anyMissing() ? -2130729728 : -2142943745;
                return new IAbstractRecipeHandler.Result.PartiallyCraftable(missingSlots, color, craftingMissing);
            }
        } else {
            this.performTransfer((ETTerminalMenu)((Object)menu), recipeHolder, craftingMissing);
        }
        return IAbstractRecipeHandler.Result.createSuccessful();
    }

    @Override
    protected void performTransfer(ETTerminalMenu menu, RecipeHolder<StonecutterRecipe> recipeHolder, boolean craftingMissing) {
        ResourceLocation recipeId = recipeHolder.id();
        ItemStack templateItem = this.findGoodTemplateItem(menu, (SingleItemRecipe)recipeHolder.value());
        if (menu.getPlayer().level().getRecipeManager().byKey(recipeId).isEmpty()) {
            return;
        }
        FillStonecutterGridFromRecipePacket message = new FillStonecutterGridFromRecipePacket(recipeId, templateItem, craftingMissing);
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public RecipeType<RecipeHolder<StonecutterRecipe>> getRecipeType() {
        return RecipeTypes.STONECUTTING;
    }

    private ItemStack findGoodTemplateItem(ETTerminalMenu menu, SingleItemRecipe recipe) {
        Map ingredientPriorities = EncodingHelper.getIngredientPriorities((MEStorageMenu)menu, ItemListTermCraftingHelper.ENTRY_COMPARATOR);
        NonNullList templateItems = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        NonNullList ingredients = recipe.getIngredients();
        Ingredient ingredient = (Ingredient)ingredients.getFirst();
        if (!ingredient.isEmpty()) {
            ItemStack stack = ingredientPriorities.entrySet().stream().filter(e -> {
                AEItemKey itemKey;
                Object patt0$temp = e.getKey();
                return patt0$temp instanceof AEItemKey && (itemKey = (AEItemKey)patt0$temp).matches(ingredient);
            }).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> ((AEItemKey)e.getKey()).toStack()).orElse(ingredient.getItems()[0]);
            templateItems.set(0, (Object)stack);
        }
        return (ItemStack)templateItems.getFirst();
    }
}

