/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.extendedterminal;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.MEStorage;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.ICraftingGridMenu;
import appeng.helpers.InventoryAction;
import appeng.me.storage.LinkStatusRespectingInventory;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.CraftingMatrixSlot;
import appeng.menu.slot.CraftingTermSlot;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.myogoo.extendedterminal.api.host.IETTerminalHost;
import me.myogoo.extendedterminal.config.ExtendedTerminalConfig;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.ETSlotSemantics;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMode;
import me.myogoo.extendedterminal.menu.extendedterminal.FakeAnvilMenu;
import me.myogoo.extendedterminal.menu.extendedterminal.slot.ETAnvilSlot;
import me.myogoo.extendedterminal.menu.extendedterminal.slot.ETSmithingSlot;
import me.myogoo.extendedterminal.menu.extendedterminal.slot.ETStoneCutterSlot;
import me.myogoo.extendedterminal.menu.slot.ETCraftingBaseSlot;
import me.myogoo.extendedterminal.part.extendedterminal.ETTerminalPart;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ETTerminalMenu
extends ETTerminalBaseMenu<CraftingRecipe> {
    public static final MenuType<ETTerminalMenu> TYPE = MenuTypeBuilder.create(ETTerminalMenu::new, IETTerminalHost.class).buildUnregistered(ETMenuType.ET_TERMINAL.getId());
    private static final String ACTION_SET_STONECUTTING_RECIPE_ID = "setStonecuttingRecipeId";
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_UPDATE_STONECUTTER_RECIPES = "updateStoneCutterRecipes";
    private static final String ACTION_SET_ANVIL_ITEM_NAME = "setAnvilItemName";
    private final ISegmentedInventory craftingInventoryHost;
    @GuiSync(value=0)
    public ETTerminalMode currentMode = ETTerminalMode.CRAFTING;
    private final CraftingMatrixSlot[] craftingSlots;
    private final CraftingTermSlot outputSlot;
    private CraftingInput lastTestedCraftingInput;
    private RecipeHolder<CraftingRecipe> craftingRecipe;
    private final CraftingMatrixSlot smithingTemplateSlot;
    private final CraftingMatrixSlot smithingBaseSlot;
    private final CraftingMatrixSlot smithingAdditionSlot;
    private final ETSmithingSlot smithingOutputSlot;
    private SmithingRecipeInput lastTestedSmithingInput;
    private RecipeHolder<SmithingRecipe> smithingRecipe;
    private final CraftingMatrixSlot stonecuttingSlot;
    private final ETStoneCutterSlot stoneCutterOutputSlot;
    private List<RecipeHolder<StonecutterRecipe>> stoneCutterRecipes = new ArrayList<RecipeHolder<StonecutterRecipe>>();
    @GuiSync(value=1)
    private ResourceLocation stoneCutterRecipeId = null;
    private final CraftingMatrixSlot anvilLeftSlot;
    private final CraftingMatrixSlot anvilRightSlot;
    private final ETAnvilSlot anvilOutputSlot;
    private final FakeAnvilMenu anvilDelegate;
    @GuiSync(value=2)
    private int anvilCost = 0;
    private final IETTerminalHost host;

    public ETTerminalMenu(MenuType<?> menuType, int id, Inventory ip, IETTerminalHost host) {
        super(menuType, id, ip, host, ETMenuType.ET_TERMINAL, ExtendedTerminalConfig.INSTANCE.getExtendedTerminalConfig());
        this.host = host;
        this.currentMode = host.getMode();
        this.craftingInventoryHost = (ISegmentedInventory)host;
        this.craftingSlots = new CraftingMatrixSlot[this.menuType.getGridSize()];
        Player player = this.getPlayerInventory().player;
        InternalInventory craftingGridInv = this.craftingInventoryHost.getSubInventory(this.menuType.getCraftingInventory());
        for (int i = 0; i < this.menuType.getGridSize(); ++i) {
            this.craftingSlots[i] = new CraftingMatrixSlot((AEBaseMenu)this, craftingGridInv, i);
            this.addSlot((Slot)this.craftingSlots[i], this.menuType.getSlotSemanticGrid());
        }
        LinkStatusRespectingInventory linkStatusInventory = new LinkStatusRespectingInventory(host.getInventory(), () -> ((ETTerminalMenu)this).getLinkStatus());
        this.outputSlot = new CraftingTermSlot(player, this.getActionSource(), this.energySource, (MEStorage)linkStatusInventory, craftingGridInv, craftingGridInv, (ICraftingGridMenu)this);
        this.addSlot((Slot)this.outputSlot, this.menuType.getSlotSemanticResult());
        InternalInventory smithingInv = this.craftingInventoryHost.getSubInventory(ETTerminalPart.SmithingInventory);
        this.smithingTemplateSlot = new CraftingMatrixSlot((AEBaseMenu)this, smithingInv, 0);
        this.addSlot((Slot)this.smithingTemplateSlot, ETSlotSemantics.SMITHING_TABLE_TEMPLATE);
        this.smithingBaseSlot = new CraftingMatrixSlot((AEBaseMenu)this, smithingInv, 1);
        this.addSlot((Slot)this.smithingBaseSlot, ETSlotSemantics.SMITHING_TABLE_BASE);
        this.smithingAdditionSlot = new CraftingMatrixSlot((AEBaseMenu)this, smithingInv, 2);
        this.addSlot((Slot)this.smithingAdditionSlot, ETSlotSemantics.SMITHING_TABLE_ADDITION);
        this.smithingOutputSlot = new ETSmithingSlot(player, this.getActionSource(), this.energySource, (MEStorage)linkStatusInventory, smithingInv, smithingInv, this);
        this.addSlot((Slot)this.smithingOutputSlot, SlotSemantics.SMITHING_TABLE_RESULT);
        InternalInventory stonecuttingInv = this.craftingInventoryHost.getSubInventory(ETTerminalPart.StoneCutterInventory);
        this.stonecuttingSlot = new CraftingMatrixSlot((AEBaseMenu)this, stonecuttingInv, 0);
        this.addSlot((Slot)this.stonecuttingSlot, ETSlotSemantics.STONECUTTING_INPUT);
        this.stoneCutterOutputSlot = new ETStoneCutterSlot(player, this.getActionSource(), this.energySource, (MEStorage)linkStatusInventory, stonecuttingInv, stonecuttingInv, this);
        this.addSlot((Slot)this.stoneCutterOutputSlot, ETSlotSemantics.STONECUTTING_RESULT);
        InternalInventory anvilInv = this.craftingInventoryHost.getSubInventory(ETTerminalPart.AnvilInventory);
        this.anvilDelegate = new FakeAnvilMenu(0, player.getInventory());
        this.anvilLeftSlot = new CraftingMatrixSlot((AEBaseMenu)this, anvilInv, 0);
        this.addSlot((Slot)this.anvilLeftSlot, ETSlotSemantics.ANVIL_LEFT_INPUT);
        this.anvilRightSlot = new CraftingMatrixSlot((AEBaseMenu)this, anvilInv, 1);
        this.addSlot((Slot)this.anvilRightSlot, ETSlotSemantics.ANVIL_RIGHT_INPUT);
        this.anvilOutputSlot = new ETAnvilSlot(player, this.getActionSource(), this.energySource, (MEStorage)linkStatusInventory, anvilInv, this.anvilDelegate, this);
        this.addSlot((Slot)this.anvilOutputSlot, ETSlotSemantics.ANVIL_RESULT);
        this.registerClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, ResourceLocation.class, this::setStoneCutterRecipeId);
        this.registerClientAction(ACTION_SET_MODE, ETTerminalMode.class, this::setMode);
        this.registerClientAction(ACTION_SET_ANVIL_ITEM_NAME, String.class, this::setAnvilItemName);
        this.updateCurrentRecipeAndOutput(true);
    }

    public void initializeContents(int stateId, List<ItemStack> items, ItemStack carried) {
        super.initializeContents(stateId, items, carried);
        this.setMode(this.currentMode);
    }

    public void setMode(ETTerminalMode mode) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_MODE, (Object)mode);
        } else {
            this.host.setMode(mode);
            this.currentMode = this.host.getMode();
            this.updateCurrentRecipeAndOutput(true);
        }
    }

    public ETTerminalMode getMode() {
        return this.currentMode;
    }

    @Override
    protected void updateCurrentRecipeAndOutput(boolean forceUpdate) {
        ETTerminalMode eTTerminalMode = this.currentMode;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CRAFTING", "SMITHING", "STONECUTTING", "ANVIL"}, (ETTerminalMode)eTTerminalMode, n)) {
            case 0: {
                this.updateCraftingOutput(forceUpdate);
                break;
            }
            case 1: {
                this.updateSmithingOutput(forceUpdate);
                break;
            }
            case 2: {
                this.updateStonecuttingOutput(forceUpdate);
                break;
            }
            case 3: {
                this.updateAnvilOutput(forceUpdate);
                break;
            }
        }
    }

    @Override
    public void clearCraftingGrid() {
        this.clearInventory((AppEngSlot)this.craftingSlots[0]);
    }

    public void clearSmithingGrid() {
        this.clearInventory((AppEngSlot)this.smithingTemplateSlot);
        this.clearInventory((AppEngSlot)this.smithingAdditionSlot);
        this.clearInventory((AppEngSlot)this.smithingBaseSlot);
    }

    public void clearInventory(AppEngSlot slot) {
        Preconditions.checkState((boolean)this.isClientSide());
        InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slot.index, 0L);
        PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public InternalInventory getCraftingMatrix() {
        return this.getInventory(this.menuType.getCraftingInventory());
    }

    public InternalInventory getSmithingInventory() {
        return this.getInventory(ETTerminalPart.SmithingInventory);
    }

    public InternalInventory getStoneCutterInventory() {
        return this.getInventory(ETTerminalPart.StoneCutterInventory);
    }

    public InternalInventory getInventory(ResourceLocation id) {
        return this.craftingInventoryHost.getSubInventory(id);
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        Slot slot2 = this.getSlot(slot);
        if (slot2 instanceof ETCraftingBaseSlot) {
            ETCraftingBaseSlot craftingSlot = (ETCraftingBaseSlot)slot2;
            switch (action) {
                case CRAFT_SHIFT: 
                case CRAFT_ALL: 
                case CRAFT_ITEM: 
                case CRAFT_STACK: {
                    craftingSlot.doClick(action, (Player)player);
                }
            }
            return;
        }
        super.doAction(player, action, slot, id);
    }

    private void updateCraftingOutput(boolean forceUpdate) {
        ArrayList<ItemStack> testItems = new ArrayList<ItemStack>(this.craftingSlots.length);
        for (CraftingMatrixSlot craftingSlot : this.craftingSlots) {
            testItems.add(craftingSlot.getItem().copy());
        }
        CraftingInput testInput = CraftingInput.of((int)3, (int)3, testItems);
        if (!forceUpdate && Objects.equals(this.lastTestedCraftingInput, testInput)) {
            return;
        }
        Level level = this.getPlayer().level();
        this.currentRecipe = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)testInput, level).orElse(null);
        this.lastTestedCraftingInput = testInput;
        if (this.currentRecipe == null) {
            this.outputSlot.set(ItemStack.EMPTY);
        } else {
            this.outputSlot.set(((CraftingRecipe)this.currentRecipe.value()).assemble((RecipeInput)testInput, (HolderLookup.Provider)level.registryAccess()));
        }
    }

    @Nullable
    public RecipeHolder<CraftingRecipe> getCraftingRecipe() {
        return this.currentRecipe;
    }

    private void updateSmithingOutput(boolean forceUpdate) {
        SmithingRecipeInput smithingTestInput = new SmithingRecipeInput(this.smithingTemplateSlot.getItem().copy(), this.smithingBaseSlot.getItem().copy(), this.smithingAdditionSlot.getItem().copy());
        if (!forceUpdate && Objects.equals(this.lastTestedSmithingInput, smithingTestInput)) {
            return;
        }
        Level level = this.getPlayer().level();
        List smithingRecipes = level.getRecipeManager().getRecipesFor(RecipeType.SMITHING, (RecipeInput)smithingTestInput, level);
        if (smithingRecipes.isEmpty()) {
            this.smithingOutputSlot.set(ItemStack.EMPTY);
        } else {
            RecipeHolder recipeHolder = (RecipeHolder)smithingRecipes.getFirst();
            ItemStack result = ((SmithingRecipe)recipeHolder.value()).assemble((RecipeInput)smithingTestInput, (HolderLookup.Provider)level.registryAccess());
            if (result.isItemEnabled(level.enabledFeatures())) {
                this.smithingRecipe = recipeHolder;
                this.smithingOutputSlot.set(result);
            }
        }
    }

    @Nullable
    public RecipeHolder<SmithingRecipe> getSmithingRecipe() {
        return this.smithingRecipe;
    }

    private void updateStonecuttingOutput(boolean forceUpdate) {
        ItemStack input = this.stonecuttingSlot.getItem();
        this.stoneCutterRecipes.clear();
        if (input.isEmpty()) {
            this.stoneCutterRecipeId = null;
            this.stoneCutterOutputSlot.set(ItemStack.EMPTY);
            return;
        }
        this.updateStonecutterRecipes();
    }

    public void updateStonecutterRecipes() {
        ItemStack input = this.stonecuttingSlot.getItem();
        this.stoneCutterRecipes.clear();
        Level level = this.getPlayer().level();
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput recipeInput = new SingleRecipeInput(input);
        this.stoneCutterRecipes.addAll(recipeManager.getRecipesFor(RecipeType.STONECUTTING, (RecipeInput)recipeInput, level));
        if (this.stoneCutterRecipeId != null && this.stoneCutterRecipes.stream().noneMatch(r -> r.id().equals((Object)this.stoneCutterRecipeId))) {
            this.stoneCutterRecipeId = null;
        }
    }

    public void setStoneCutterRecipeId(ResourceLocation stoneCutterRecipeId) {
        if (this.isClientSide()) {
            this.host.setStoneCutterRecipeId(stoneCutterRecipeId);
            this.sendClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, this.host.getStoneCutterRecipeId());
        } else {
            this.stoneCutterRecipeId = stoneCutterRecipeId;
            Optional optionalRecipeHolder = this.getPlayer().level().getRecipeManager().byKey(stoneCutterRecipeId);
            if (optionalRecipeHolder.isPresent()) {
                Recipe recipe = ((RecipeHolder)optionalRecipeHolder.get()).value();
                this.stoneCutterOutputSlot.set(recipe.getResultItem((HolderLookup.Provider)this.getPlayer().level().registryAccess()));
            } else {
                this.stoneCutterOutputSlot.set(ItemStack.EMPTY);
            }
        }
    }

    public ResourceLocation getStoneCutterRecipeId() {
        return this.stoneCutterRecipeId;
    }

    public List<RecipeHolder<StonecutterRecipe>> getStoneCutterRecipes() {
        return this.stoneCutterRecipes;
    }

    public FakeAnvilMenu getAnvilDelegate() {
        return this.anvilDelegate;
    }

    public int getanvilCost() {
        return this.anvilCost;
    }

    public void updateAnvilOutput(boolean forceUpdate) {
        ((Slot)this.anvilDelegate.slots.get(0)).set(this.anvilLeftSlot.getItem());
        ((Slot)this.anvilDelegate.slots.get(1)).set(this.anvilRightSlot.getItem());
        this.anvilOutputSlot.set(this.anvilDelegate.getResultItem());
        this.anvilCost = this.anvilDelegate.getCost();
    }

    public void setAnvilItemName(String name) {
        if (this.isServerSide()) {
            if (this.anvilDelegate.setItemName(name)) {
                this.updateCurrentRecipeAndOutput(true);
            }
        } else {
            this.sendClientAction(ACTION_SET_ANVIL_ITEM_NAME, name);
        }
    }

    @Override
    public boolean hasIngredient(Ingredient ingredient, Object2IntOpenHashMap<Object> reservedAmounts) {
        List slots = ETTerminalMode.loadableValues().stream().map(ETTerminalMode::getSlotSemantics).flatMap(Collection::stream).map(arg_0 -> ((ETTerminalMenu)this).getSlots(arg_0)).flatMap(Collection::stream).toList();
        for (Slot slot : slots) {
            ItemStack stackInSlot = slot.getItem();
            if (stackInSlot.isEmpty() || !ingredient.test(stackInSlot)) continue;
            int reservedAmount = reservedAmounts.getOrDefault((Object)slot, 0);
            if (stackInSlot.getCount() <= reservedAmount) continue;
            reservedAmounts.merge((Object)slot, 1, Integer::sum);
            return true;
        }
        return super.hasIngredient(ingredient, reservedAmounts);
    }
}

