/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.util.mod;

import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import me.myogoo.extendedterminal.api.ModAccessor;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;

public enum SupportedMod {
    AE2WTLib("ae2wtlib", ModAccessor.AE2WTLib.class),
    ExtendedCrafting("extendedcrafting", ModAccessor.ExtendedCrafting.class),
    ReAvaritia("avaritia", ModAccessor.ReAvaritia.class, "Re-Avaritia"),
    AvaritiaNeo("avaritia", ModAccessor.AvaritiaNeo.class, "Avaritia"),
    ApothicEnchant("Apothic Enchanting", ModAccessor.ApothicEnchant.class);

    private final String modId;
    private final Class<? extends Annotation> annotationClass;
    private final Predicate<IModInfo> customLoadCondition;

    private SupportedMod(String modId, Class<? extends Annotation> annotationClass) {
        this(modId, annotationClass, (IModInfo modInfo) -> true);
    }

    private SupportedMod(String modId, Class<? extends Annotation> annotationClass, String displayModName) {
        this(modId, annotationClass, (IModInfo modInfo) -> displayModName.equals(modInfo.getDisplayName()));
    }

    private SupportedMod(String modId, Class<? extends Annotation> annotationClass, Predicate<IModInfo> customLoadCondition) {
        this.modId = modId;
        this.annotationClass = annotationClass;
        this.customLoadCondition = customLoadCondition;
    }

    public String getModId() {
        return this.modId;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public boolean isLoaded() {
        return ModList.get().getModContainerById(this.modId).map(container -> this.customLoadCondition.test(container.getModInfo())).orElse(false);
    }
}

