package net.bichal.bplb.client.render;

import net.bichal.bplb.util.Constants;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import java.awt.*;
import java.io.InputStream;
import java.util.*;

public class AssetScanner {
    private static final Map<class_2960, Dimension> dimensionCache = new HashMap<>();

    public static List<String> getPlayerDots(class_3300 resourceManager) {
        List<String> dots = new ArrayList<>();
        String[] dotTypes = {"default", "minimal", "mojang", "bowtie"};
        for (String dotType : dotTypes) {
            class_2960 testId = class_2960.method_60655(Constants.MOD_ID, String.format("textures/sprites/hud/player_dots/%s_0.png", dotType));
            if (resourceManager.method_14486(testId).isPresent()) {
                dots.add(dotType);
            }
        }
        return dots;
    }

    public static List<String> getIconBorderStyles(class_3300 resourceManager) {
        return checkExistence(resourceManager, new String[]{"rounded", "squared"}, style -> String.format("textures/sprites/hud/player_dots_outlines/%s/default_0.png", style));
    }

    public static List<String> getNameplateBorderStyles(class_3300 resourceManager) {
        return checkExistence(resourceManager, new String[]{"rounded", "squared"}, style -> String.format("textures/sprites/hud/tags/%s/default.png", style));
    }

    public static List<String> getArrowTypes(class_3300 resourceManager) {
        return checkExistence(resourceManager, new String[]{"default", "mojang"}, arrow -> String.format("textures/sprites/hud/arrows/%s.png", arrow));
    }

    public static List<String> getDeathMarkerTypes(class_3300 resourceManager) {
        return checkExistence(resourceManager, new String[]{"default", "minimal"}, marker -> String.format("textures/sprites/hud/death_markers_dots/%s.png", marker));
    }

    private static List<String> checkExistence(class_3300 resourceManager, String[] types, java.util.function.Function<String, String> pathBuilder) {
        List<String> result = new ArrayList<>();
        for (String type : types) {
            class_2960 testId = class_2960.method_60655(Constants.MOD_ID, pathBuilder.apply(type));
            if (resourceManager.method_14486(testId).isPresent()) {
                result.add(type);
            }
        }
        return result;
    }

    public static Dimension getTextureDimensions(class_2960 id) {
        return dimensionCache.computeIfAbsent(id, key -> {
            try {
                class_3300 resourceManager = class_310.method_1551().method_1478();
                Optional<class_3298> resourceOpt = resourceManager.method_14486(key);
                if (resourceOpt.isPresent()) {
                    try (InputStream stream = resourceOpt.get().method_14482(); class_1011 image = class_1011.method_4309(stream)) {
                        return new Dimension(image.method_4307(), image.method_4323());
                    }
                }
            } catch (Exception e) {
                Constants.LOGGER.warn("Could not read dimensions for texture: {}", key, e);
            }
            return new Dimension(Constants.ICON_BASE_SIZE, Constants.ICON_BASE_SIZE);
        });
    }
}
