package net.bichal.bplb.client.render;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import net.bichal.bplb.config.Config;
import net.bichal.bplb.util.ColorUtils;
import net.bichal.bplb.util.Constants;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import static net.bichal.bplb.util.ColorUtils.generateColorFromUUID;

public class RenderAddons {
    private static final Map<String, TextureAnimator> textureAnimators = new HashMap<>();

    private static void renderIcon(class_332 context, float x, float y, int size, float alpha, String dotId, String borderStyle, String borderType, int color, int textureIndex, Config config) {
        class_2960 dotTexture = TextureManager.getPlayerDotTexture(dotId, textureIndex);
        class_2960 outlineTexture = TextureManager.getPlayerDotOutlineTexture(dotId, borderStyle, borderType, textureIndex);
        int borderColor = config.isInheritBorderColor() ? ColorUtils.darkerColoring(color) : 0xFF000000;
        RenderUtils.renderTintedTexture(context, outlineTexture, x, y, size, size, borderColor, alpha);
        RenderUtils.renderTintedTexture(context, dotTexture, x, y, size, size, color, alpha);
    }

    public static void renderPlayerIcon(class_332 context, String playerName, UUID playerUuid, double distance, float x, float y, int size, boolean showHead, Config config, float alpha) {
        Config.PlayerAppearance appearance = config.getPlayerConfig(playerName);
        int textureIndex = getAdjustedTextureIndex(distance, config);
        String dotId = appearance != null && appearance.dotType != null ? appearance.dotType : config.getDotType();
        String borderStyle = appearance != null && appearance.iconBorderStyle != null ? appearance.iconBorderStyle : config.getIconBorderStyle();
        int color = appearance != null && appearance.color != null ? appearance.color : generateColorFromUUID(playerUuid);
        renderIcon(context, x, y, size, alpha, dotId, borderStyle, config.getIconBorderType(), color, showHead ? 0 : textureIndex, config);
        String textureOverride = appearance != null ? appearance.textureHeadOverride : null;
        renderPlayerHeadOverlay(context, playerUuid, x, y, size, textureOverride, showHead ? 1 * alpha : 0);
    }

    private static void renderPlayerHeadOverlay(class_332 context, UUID playerUuid, float x, float y, int size, String textureOverride, float alpha) {
        class_310 client = class_310.method_1551();
        if (alpha <= 0.01f) return;
        if (client.field_1687 == null || playerUuid == null) return;
        class_2960 skin = Constants.STEVE_SKIN_TEXTURE;
        try {
            if (textureOverride != null && !textureOverride.isEmpty()) {
                UUID overrideUuid = getUuidFromCache(textureOverride);
                if (overrideUuid != null) {
                    class_742 overridePlayer = (class_742) client.field_1687.method_18470(overrideUuid);
                    if (overridePlayer != null && overridePlayer.method_52814() != null) skin = overridePlayer.method_52814().comp_1626();
                }
            } else {
                class_742 player = (class_742) client.field_1687.method_18470(playerUuid);
                if (player != null && player.method_52814() != null) skin = player.method_52814().comp_1626();
            }
        } catch (Exception e) {
            Constants.LOGGER.debug("Error loading skin texture", e);
        }

        try {
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, alpha);
            int padding = 2;
            int texSize = Math.max(1, size - padding * 2);
            context.method_25293(skin, (int) x + padding, (int) y + padding, texSize, texSize, 8, 8, 8, 8, 64, 64);
        } finally {
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void renderDeathMarker(class_332 context, float x, float y, int size, float alpha, Config config) {
        String markerType = config.getDeathMarkerType();
        int color = config.getDeathMarkerColor();
        class_2960 markerTexture = TextureManager.getDeathMarkerTexture(markerType);
        class_2960 outlineTexture = TextureManager.getDeathMarkerOutlineTexture(markerType, config.getDeathMarkerBorderStyle(), config.getDeathMarkerBorderType());
        int borderColor = config.isDeathMarkerInheritBorderColor() ? ColorUtils.darkerColoring(color) : 0xFF000000;
        RenderUtils.renderTintedTexture(context, outlineTexture, x, y, size, size, borderColor, alpha);
        RenderUtils.renderTintedTexture(context, markerTexture, x, y, size, size, color, alpha);
    }

    public static void renderArrow(class_332 context, String arrowType, boolean isUp, float x, float y, int size, float alpha) {
        if (alpha <= 0.01f) return;

        TextureAnimator animator = textureAnimators.computeIfAbsent(arrowType + "_" + isUp, k -> new TextureAnimator(10, 4));
        class_2960 arrowTexture = TextureManager.getArrowTexture(arrowType);

        context.method_51448().method_22903();
        try {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, alpha);

            int frame = animator.getCurrentFrame();
            float u = isUp ? 0 : Constants.ICON_BASE_SIZE;
            float v = frame * Constants.ICON_BASE_SIZE;

            context.method_25293(arrowTexture, (int) x, (int) y, size, size, u, v, Constants.ICON_BASE_SIZE, Constants.ICON_BASE_SIZE, Constants.ICON_BASE_SIZE * 2, Constants.ICON_BASE_SIZE * 2);
        } finally {
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
            context.method_51448().method_22909();
        }
    }

    public static void renderNameplate(class_332 context, String text, String borderStyle, int color, float x, float y, float alpha, float scale) {
        if (alpha <= 0.01f) return;
        class_310 client = class_310.method_1551();
        int textWidth = client.field_1772.method_1727(text);
        int boxWidth = (int) (textWidth * scale) + 4;
        int boxHeight = (int) (12 * scale);
        class_2960 nameplateTexture = TextureManager.getNameplateTexture(borderStyle);
        int tintColor = ColorUtils.darkerColoring(color);
        context.method_51448().method_22903();
        context.method_51448().method_46416(x, y, 0);
        RenderUtils.setShaderColorRGBA(tintColor, alpha);
        RenderUtils.drawNineSlicedTexture(context, nameplateTexture, 0, 0, boxWidth, boxHeight);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        context.method_51448().method_46416(boxWidth / 2f, boxHeight / 2f, 1);
        context.method_51448().method_22905(scale, scale, 1.0f);
        int textColor = Constants.WHITE_COLOR | ((int) (alpha * 255) << 24);
        context.method_51433(client.field_1772, text, -textWidth / 2, -client.field_1772.field_2000 / 2, textColor, true);
        context.method_51448().method_22909();
    }

    private static int getAdjustedTextureIndex(double distance, Config config) {
        int baseIndex = TextureManager.getTextureIndexFromDistance(distance);
        int configSize = config.getIconSize();
        int offset = 4 - configSize;
        return Math.min(3, Math.max(0, baseIndex + offset));
    }

    @Nullable
    public static UUID getUuidFromCache(String nameOrUuid) {
        if (nameOrUuid == null || nameOrUuid.isEmpty()) return null;

        try {
            return UUID.fromString(nameOrUuid);
        } catch (IllegalArgumentException ignored) {
        }

        UUID directUuid = getUuid(nameOrUuid);
        if (directUuid != null) return directUuid;

        try {
            File cacheFile = FabricLoader.getInstance().getGameDir().resolve("usercache.json").toFile();
            if (!cacheFile.exists()) return null;
            byte[] data = Files.readAllBytes(cacheFile.toPath());
            if (data.length == 0) return null;
            String json = new String(data);
            if (json.trim().isEmpty()) return null;
            JsonElement element = com.google.gson.JsonParser.parseString(json);
            if (!element.isJsonArray()) return null;
            JsonArray array = element.getAsJsonArray();
            for (JsonElement entry : array) {
                if (!entry.isJsonObject()) continue;
                com.google.gson.JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("name") || !obj.has("uuid")) continue;
                JsonElement nameEl = obj.get("name");
                JsonElement uuidEl = obj.get("uuid");
                if (nameEl == null || uuidEl == null || !nameEl.isJsonPrimitive() || !uuidEl.isJsonPrimitive())
                    continue;
                String objName = nameEl.getAsString();
                if (objName != null && objName.equalsIgnoreCase(nameOrUuid)) {
                    try {
                        return UUID.fromString(uuidEl.getAsString());
                    } catch (Exception e) {
                        Constants.LOGGER.debug("Invalid UUID entry in usercache.json");
                    }
                }
            }
        } catch (Exception e) {
            Constants.LOGGER.debug("Failed to read usercache.json", e);
        }
        return null;
    }

    @Nullable
    public static UUID getUuid(String name) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            for (var player : client.field_1687.method_18456()) {
                if (player.method_5477().getString().equals(name)) {
                    return player.method_5667();
                }
            }
        }
        return null;
    }
}
