package net.bichal.bplb.client.render;

import net.bichal.bplb.util.Constants;
import net.minecraft.class_2960;
import java.util.HashMap;
import java.util.Map;

public class TextureManager {
    private static final Map<String, class_2960> TEXTURE_CACHE = new HashMap<>();
    private static class_2960 getTexture(String... parts) {
        String path = String.format("textures/sprites/hud/%s/%s.png", "player_dots", String.join("/", parts));
        return TEXTURE_CACHE.computeIfAbsent(String.join("_", parts), k -> class_2960.method_60655(Constants.MOD_ID, path));
    }

    public static class_2960 getPlayerDotTexture(String dotId, int textureIndex) {
        String dotPath = "bowtie".equals(dotId) ? "bowtie_" + textureIndex : dotId + "_" + textureIndex;
        return getTexture(dotPath);
    }

    public static class_2960 getPlayerDotOutlineTexture(String dotId, String borderStyle, String borderType, int textureIndex) {
        String key = "outline_" + dotId + "_" + borderStyle + "_" + borderType + "_" + textureIndex;
        return TEXTURE_CACHE.computeIfAbsent(key, k -> {
            String path = "bowtie".equals(dotId) ? "textures/sprites/hud/player_dots_outlines/bowtie_" + textureIndex + ".png" : "textures/sprites/hud/player_dots_outlines/" + borderStyle + "/" + borderType + "_" + textureIndex + ".png";
            return class_2960.method_60655(Constants.MOD_ID, path);
        });
    }

    public static class_2960 getArrowTexture(String arrowType) {
        return TEXTURE_CACHE.computeIfAbsent("arrow_" + arrowType, k -> class_2960.method_60655(Constants.MOD_ID, String.format("textures/sprites/hud/arrows/%s.png", arrowType)));
    }

    public static class_2960 getDeathMarkerTexture(String markerType) {
        return TEXTURE_CACHE.computeIfAbsent("marker_" + markerType, k -> class_2960.method_60655(Constants.MOD_ID, String.format("textures/sprites/hud/death_markers_dots/%s.png", markerType)));
    }

    public static class_2960 getDeathMarkerOutlineTexture(String markerType, String borderStyle, String borderType) {
        return TEXTURE_CACHE.computeIfAbsent("marker_outline_" + markerType + "_" + borderStyle + "_" + borderType, k ->
                class_2960.method_60655(Constants.MOD_ID, String.format("textures/sprites/hud/death_markers_dots_outlines/%s.png", borderType))
        );
    }

    public static class_2960 getNameplateTexture(String borderStyle) {
        return TEXTURE_CACHE.computeIfAbsent("nameplate_" + borderStyle, k -> class_2960.method_60655(Constants.MOD_ID, String.format("textures/sprites/hud/tags/%s/default.png", borderStyle)));
    }

    public static int getTextureIndexFromDistance(double distance) {
        if (distance <= 64) return 0;
        if (distance <= 128) return 1;
        if (distance <= 256) return 2;
        return 3;
    }
}
