package net.bichal.bplb.config;

import net.bichal.bplb.client.Client;
import net.bichal.bplb.client.render.RenderAddons;
import net.bichal.bplb.client.render.RenderUtils;
import net.bichal.bplb.client.render.TextureAnimator;
import net.bichal.bplb.client.render.TextureManager;
import net.bichal.bplb.config.entries.*;
import net.bichal.bplb.config.widget.ButtonWidget;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.bichal.bplb.config.widget.TextInputWidget;
import net.bichal.bplb.util.Constants;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;

import static net.bichal.bplb.client.render.RenderAddons.getUuidFromCache;
import static net.bichal.bplb.util.ColorUtils.generateColorFromUUID;

public class ConfigScreen extends class_437 {
    private static final int PREVIEW_BASE_SIZE = 45;
    private static final int preview_close_size = 0;
    private static final int MAX_UI_WIDTH = 460;
    private final class_437 parent;
    private TextureAnimator previewArrowAnimator = null;
    private final Config workingConfig;
    private ScrollableListWidget scrollableList;
    private boolean hasChanges = false;
    private final Map<String, SearchMatch> searchMatches = new HashMap<>();
    private ButtonWidget applyButton, doneButton;
    private String searchQuery = "";

    public ConfigScreen(class_437 parent) {
        super(class_2561.method_43471(Constants.CONFIG_KEY_PREFIX + "title"));
        this.parent = parent;
        this.workingConfig = new Config();
        Config.copy(Config.getInstance(), this.workingConfig);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int uiWidth = Math.min(this.field_22789 - (10 * 5) * 2 - 25 * 2, MAX_UI_WIDTH);
        int scrollListLeftOffset = 0;
        if (this.field_22789 < MAX_UI_WIDTH) {
            uiWidth = this.field_22789 - 25 * 2 - PREVIEW_BASE_SIZE - PREVIEW_BASE_SIZE / 2;
            scrollListLeftOffset = -10;
        }

        TextInputWidget searchField = new TextInputWidget(this.field_22793, this.field_22789 / 2 - 100, 30, 200, 20, class_2561.method_43471("bplb.config.search"));
        searchField.method_1863(text -> {
            this.searchQuery = text.toLowerCase();
            rebuildListWithoutScroll();
        });
        this.method_37063(searchField);

        this.scrollableList = new ScrollableListWidget(this.field_22787, this.field_22789, 60, this.field_22790 - 35, 24);
        this.scrollableList.setRowWidth(uiWidth);
        this.scrollableList.setRowLeft(this.field_22789 / 2 - uiWidth / 2 + scrollListLeftOffset);
        this.scrollableList.setScrollbarX(this.field_22789 - 6);
        populateOptions();
        this.method_25429(this.scrollableList);
        this.method_37063(this.scrollableList);

        int startX = (int) ((double) this.field_22789 / 2 - Constants.CONFIG_BUTTON_WIDTH * 1.5 - Constants.CONFIG_BUTTON_SPACING * 1.5);
        int buttonY = this.field_22790 - 27;

        this.method_37063(ButtonWidget.builder(class_2561.method_43471("gui.cancel"), button -> this.method_25419()).dimensions(startX, buttonY, Constants.CONFIG_BUTTON_WIDTH, 20).build());
        this.applyButton = this.method_37063(ButtonWidget.builder(class_2561.method_43471("screen.bplb.config.apply"), button -> applyChanges()).dimensions(startX + Constants.CONFIG_BUTTON_WIDTH + Constants.CONFIG_BUTTON_SPACING, buttonY, Constants.CONFIG_BUTTON_WIDTH, 20).build());
        this.doneButton = this.method_37063(ButtonWidget.builder(class_5244.field_24334, button -> {
            if (hasChanges) applyChanges();
            this.method_25419();
        }).dimensions(startX + (Constants.CONFIG_BUTTON_WIDTH + Constants.CONFIG_BUTTON_SPACING) * 2, buttonY, Constants.CONFIG_BUTTON_WIDTH, 20).build());

        updateButtons();
    }

    public void rebuildList() {
        if (this.field_22787 != null) {
            double scroll = this.scrollableList.method_25341();
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            this.scrollableList.method_25307(scroll);
        }
    }

    private void rebuildListWithoutScroll() {
        if (this.field_22787 == null) return;

        double scroll = this.scrollableList.method_25341();
        scrollableList.method_25339();
        populateOptions();
        this.scrollableList.method_25307(scroll);
    }

    @Override
    public void method_25395(class_364 focused) {
        class_364 oldFocused = this.method_25399();
        super.method_25395(focused);
        if (oldFocused != focused && !(focused instanceof TextInputWidget)) {
            rebuildListWithoutScroll();
        }
    }

    private void addIntSlider(String key, int actualValue, int min, int max, Consumer<Integer> setter) {
        scrollableList.addPublicEntry(new IntegerSliderOptionEntry(this.field_22787, key, actualValue, min, max, setter, this::markDirty));
    }

    private void addSection(String key) {
        scrollableList.addPublicEntry(new SectionHeaderEntry(this.field_22787, class_2561.method_43471(Constants.CONFIG_KEY_PREFIX + "section." + key)));
    }

    private void addToggle(String key, boolean initialValue, Consumer<Boolean> setter) {
        scrollableList.addPublicEntry(new ToggleOptionEntry(this.field_22787, key, initialValue, setter, this::markDirty));
    }

    private void updateSearchMatches() {
        searchMatches.clear();
        this.scrollableList.method_25307(0);
        if (searchQuery.isEmpty()) return;

        List<String> allKeys = List.of("modEnabled", "apply_hotbar_offset", "always_show_player_heads", "always_show_player_names", "max_visible_icons", "position_update_rate_ticks", "lerp_speed", "icon_size", "dot_type", "icon_border_style", "icon_border_type", "inherit_border_color", "height_difference_mode", "arrow_type", "vertical_padding", "adjust_to_fov", "fov_multiplier", "death_marker_type", "death_marker_border_type", "death_marker_inherit_border_color", "nameplate_scale", "name_border_style", "fade_end_distance", "fade_start_distance", "fade_alpha_max", "fade_alpha_min");

        for (String key : allKeys) {
            String translated = class_2561.method_43471(Constants.CONFIG_KEY_PREFIX + key).getString().toLowerCase();
            List<Integer> indices = findMatchIndices(translated, searchQuery);
            if (!indices.isEmpty()) {
                searchMatches.put(key, new SearchMatch(translated, indices));
            }
        }
    }

    private void addFloatSlider(String key, float initialValue, float min, float max, Consumer<Float> setter) {
        scrollableList.addPublicEntry(new FloatSliderOptionEntry(this.field_22787, key, initialValue, min, max, setter, this::markDirty));
    }

    private <T> void addCycle(String key, T initialValue, List<T> options, Function<T, class_2561> textSupplier, Consumer<T> setter, boolean active) {
        scrollableList.addPublicEntry(new CycleOptionEntry<>(this.field_22787, key, initialValue, options, textSupplier, setter, this::markDirty, active));
    }

    private List<Integer> findMatchIndices(String text, String query) {
        List<Integer> indices = new ArrayList<>();
        int index = 0;
        while ((index = text.indexOf(query, index)) != -1) {
            for (int i = 0; i < query.length(); i++) {
                indices.add(index + i);
            }
            index++;
        }
        return indices;
    }

    private boolean matchesSearch(String key) {
        return searchQuery.isEmpty() || searchMatches.containsKey(key);
    }

    private class_2561 getTranslatedAssetName(String assetId, String category) {
        String key = "bplb.config.asset." + category + "." + assetId;
        class_2561 translated = class_2561.method_43471(key);
        return translated.getString().equals(key) ? class_2561.method_43470(assetId) : translated;
    }

    private void populateOptions() {
        updateSearchMatches();

        boolean isBowtie = workingConfig.getDotType().equals("bowtie");

        List<String> borderStyles = Arrays.asList(Constants.BORDER_STYLE_ROUNDED, Constants.BORDER_STYLE_SQUARED);
        List<String> borderTypes = Arrays.asList("default", "minimal");
        List<String> heightModes = Arrays.asList("player", "camera");
        List<String> markerTypes = Arrays.asList("default", "minimal");

        Function<String, class_2561> borderStyleText = value -> class_2561.method_43471(Constants.CONFIG_KEY_PREFIX + "border_style." + value.toLowerCase());
        Function<String, class_2561> borderTypeText = value -> class_2561.method_43471(Constants.CONFIG_KEY_PREFIX + "border_type." + value.toLowerCase());
        Function<String, class_2561> heightModeText = value -> class_2561.method_43471(Constants.CONFIG_KEY_PREFIX + "height_difference_mode." + value.toLowerCase());

        if (hasAnyMatch("modEnabled", "apply_hotbar_offset", "always_show_player_heads", "always_show_player_names", "max_visible_icons", "position_update_rate_ticks", "lerp_speed")) {
            addSection("general");
            addIfMatch("modEnabled", () -> addToggle("modEnabled", workingConfig.isModEnabled(), workingConfig::setModEnabled));
            addIfMatch("apply_hotbar_offset", () -> addToggle("apply_hotbar_offset", workingConfig.isApplyHotbarOffset(), workingConfig::setApplyHotbarOffset));
            addIfMatch("always_show_player_heads", () -> addToggle("always_show_player_heads", workingConfig.isAlwaysShowPlayerHeads(), workingConfig::setAlwaysShowPlayerHeads));
            addIfMatch("always_show_player_names", () -> addToggle("always_show_player_names", workingConfig.isAlwaysShowPlayerNames(), workingConfig::setAlwaysShowPlayerNames));
            addIfMatch("max_visible_icons", () -> addIntSlider("max_visible_icons", workingConfig.getMaxVisibleIcons(), 1, 200, workingConfig::setMaxVisibleIcons));
            addIfMatch("lerp_speed", () -> addFloatSlider("lerp_speed", workingConfig.getLerpSpeed(), 0.1f, 1.0f, workingConfig::setLerpSpeed));
        }

        if (hasAnyMatch("icon_size", "dot_type", "icon_border_style", "icon_border_type", "height_difference_mode", "arrow_type", "vertical_padding", "inherit_border_color", "adjust_to_fov", "fov_multiplier")) {
            addSection("icon");
            addIfMatch("icon_size", () -> addIntSlider("icon_size", workingConfig.getIconSize(), 1, 4, workingConfig::setIconSize));

            if (matchesSearch("dot_type")) {
                List<String> dotsToShow = Client.availableDots.stream().filter(d -> !d.equals("bowtie")).toList();
                scrollableList.addPublicEntry(new CycleOptionEntry<>(this.field_22787, "dot_type", workingConfig.getDotType(), dotsToShow, id -> getTranslatedAssetName(id, "dot"), val -> {
                    workingConfig.setDotType(val);
                    markDirty();
                    rebuildList();
                }, this::markDirty, true));
            }

            addIfMatch("icon_border_style", () -> addCycle("icon_border_style", workingConfig.getIconBorderStyle(), borderStyles, borderStyleText, workingConfig::setIconBorderStyle, !isBowtie));
            addIfMatch("icon_border_type", () -> addCycle("icon_border_type", workingConfig.getIconBorderType(), borderTypes, borderTypeText, workingConfig::setIconBorderType, !isBowtie));
            addIfMatch("inherit_border_color", () -> addToggle("inherit_border_color", workingConfig.isInheritBorderColor(), workingConfig::setInheritBorderColor));
            addIfMatch("height_difference_mode", () -> addCycle("height_difference_mode", workingConfig.getHeightDifferenceMode(), heightModes, heightModeText, workingConfig::setHeightDifferenceMode, true));

            if (matchesSearch("arrow_type")) {
                List<String> arrows = Client.availableArrows.isEmpty() ? List.of("default") : Client.availableArrows;
                scrollableList.addPublicEntry(new CycleOptionEntry<>(this.field_22787, "arrow_type", workingConfig.getArrowType(), arrows, id -> getTranslatedAssetName(id, "arrow"), val -> {
                    workingConfig.setArrowType(val);
                    previewArrowAnimator = null;
                    markDirty();
                }, this::markDirty, true));
            }

            addIfMatch("vertical_padding", () -> addIntSlider("vertical_padding", workingConfig.getVerticalPadding(), 0, 4, workingConfig::setVerticalPadding));
            addIfMatch("adjust_to_fov", () -> addToggle("adjust_to_fov", workingConfig.isAdjustToFov(), workingConfig::setAdjustToFov));
            addIfMatch("fov_multiplier", () -> addFloatSlider("fov_multiplier", workingConfig.getFovMultiplier(), 0.5f, 2.0f, workingConfig::setFovMultiplier));
        }

        if (hasAnyMatch("death_marker_type", "death_marker_border_type", "death_marker_inherit_border_color")) {
            addSection("markers");
            addIfMatch("death_marker_type", () -> addCycle("death_marker_type", workingConfig.getDeathMarkerType(), markerTypes, id -> getTranslatedAssetName(id, "marker"), workingConfig::setDeathMarkerType, true));
            addIfMatch("death_marker_border_type", () -> addCycle("death_marker_border_type", workingConfig.getDeathMarkerBorderType(), borderTypes, borderTypeText, workingConfig::setDeathMarkerBorderType, true));
            addIfMatch("death_marker_inherit_border_color", () -> addToggle("death_marker_inherit_border_color", workingConfig.isDeathMarkerInheritBorderColor(), workingConfig::setDeathMarkerInheritBorderColor));
        }

        if (hasAnyMatch("nameplate_scale", "name_border_style")) {
            addSection("player_name");
            addIfMatch("nameplate_scale", () -> addFloatSlider("nameplate_scale", workingConfig.getNameplateScale(), 0.5f, 1.5f, workingConfig::setNameplateScale));
            addIfMatch("name_border_style", () -> addCycle("name_border_style", workingConfig.getNameBorderStyle(), borderStyles, borderStyleText, workingConfig::setNameBorderStyle, true));
        }

        if (hasAnyMatch("fade_start_distance", "fade_end_distance", "fade_alpha_max", "fade_alpha_min")) {
            addSection("fading");
            addIfMatch("fade_start_distance", () -> addIntSlider("fade_start_distance", workingConfig.getFadeStartDistance(), 5, 9995, workingConfig::setFadeStartDistance));
            addIfMatch("fade_end_distance", () -> addIntSlider("fade_end_distance", workingConfig.getFadeEndDistance(), 10, 10000, workingConfig::setFadeEndDistance));
            addIfMatch("fade_alpha_max", () -> scrollableList.addPublicEntry(new FloatSliderOptionEntry(this.field_22787, "fade_alpha_max", workingConfig.getFadeAlphaMax(), workingConfig.getFadeAlphaMin(), 1.0f, val -> {
                workingConfig.setFadeAlphaMax(val);
                rebuildListWithoutScroll();
            }, this::markDirty)));
            addIfMatch("fade_alpha_min", () -> scrollableList.addPublicEntry(new FloatSliderOptionEntry(this.field_22787, "fade_alpha_min", workingConfig.getFadeAlphaMin(), 0.0f, workingConfig.getFadeAlphaMax(), val -> {
                workingConfig.setFadeAlphaMin(val);
                rebuildListWithoutScroll();
            }, this::markDirty)));
        }

        if (searchQuery.isEmpty() || workingConfig.getPlayerConfigs().keySet().stream().anyMatch(name -> matchesSearch("player." + name))) {
            addSection("player_appearance");
            scrollableList.addPublicEntry(new AddPlayerEntry(Objects.requireNonNull(this.field_22787), this, workingConfig));
            workingConfig.getPlayerConfigs().keySet().stream().sorted().forEach(name -> {
                boolean expanded = workingConfig.isPlayerExpanded(name);
                scrollableList.addPublicEntry(new PlayerListEntry(this.field_22787, this, workingConfig, name, expanded));
                if (expanded) {
                    Config.PlayerAppearance pc = workingConfig.getPlayerConfigs().get(name);
                    if (pc != null) {
                        addPlayerOption(name, "color", () -> {
                            UUID uuid = getUuidFromCache(name);
                            int defaultColor = uuid != null ? generateColorFromUUID(uuid) : 0xFF808080;
                            scrollableList.addPublicEntry(new ColorTextFieldEntry(this.field_22787, "player_appearance.color", pc.color != null ? pc.color : defaultColor, color -> {
                                pc.color = color;
                                markDirty();
                            }, this));
                        });
                        addPlayerOption(name, "dot_type", () -> {
                            List<String> dotsToShow = Client.availableDots.stream().filter(d -> !d.equals("bowtie")).toList();
                            scrollableList.addPublicEntry(new CycleOptionEntry<>(this.field_22787, "player_appearance.dot_type", pc.dotType != null ? pc.dotType : "default", dotsToShow, id -> getTranslatedAssetName(id, "dot"), val -> {
                                pc.dotType = val;
                                markDirty();
                            }, this::markDirty, true));
                        });
                        addPlayerOption(name, "icon_border_style", () -> scrollableList.addPublicEntry(new CycleOptionEntry<>(this.field_22787, "player_appearance.icon_border_style", pc.iconBorderStyle != null ? pc.iconBorderStyle : "rounded", borderStyles, borderStyleText, val -> {
                            pc.iconBorderStyle = val;
                            markDirty();
                        }, this::markDirty, true)));
                        addPlayerOption(name, "icon_border_type", () -> scrollableList.addPublicEntry(new CycleOptionEntry<>(this.field_22787, "player_appearance.icon_border_type", pc.iconBorderType != null ? pc.iconBorderType : "default", borderTypes, borderTypeText, val -> {
                            pc.iconBorderType = val;
                            markDirty();
                        }, this::markDirty, true)));
                        addPlayerOption(name, "arrow_type", () -> scrollableList.addPublicEntry(new CycleOptionEntry<>(this.field_22787, "player_appearance.arrow_type", pc.arrowType != null ? pc.arrowType : "default", Client.availableArrows, id -> getTranslatedAssetName(id, "arrow"), val -> {
                            pc.arrowType = val;
                            markDirty();
                        }, this::markDirty, true)));
                    }
                }
            });
        }

        if (searchQuery.isEmpty()) scrollableList.addPublicEntry(new ResetSettingsEntry(this.field_22787, this, this::markDirty, workingConfig));
    }

    private boolean hasAnyMatch(String... keys) {
        if (searchQuery.isEmpty()) return true;
        for (String key : keys) {
            if (matchesSearch(key)) return true;
        }
        return false;
    }

    private void addIfMatch(String key, Runnable action) {
        if (matchesSearch(key)) {
            action.run();
        }
    }

    private void addPlayerOption(String playerName, String option, Runnable action) {
        if (matchesSearch("player." + playerName + "." + option)) {
            action.run();
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.scrollableList != null) this.scrollableList.tick();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, Constants.WHITE_COLOR);
        renderGlobalPreview(context);

        if (Client.isLocalMode()) {
            class_2561 warningText = class_2561.method_43471("bplb.config.local_mode_warning").method_27692(class_124.field_1061);
            context.method_27535(this.field_22793, warningText, this.field_22789 - this.field_22793.method_27525(warningText) - 5, this.field_22790 - 15, Constants.WHITE_COLOR);
        }
    }

    public void drawLabelWithHighlight(class_332 context, class_2561 label, int x, int y, String key) {
        String text = label.getString();

        if (searchQuery.isEmpty() || !searchMatches.containsKey(key)) {
            context.method_27535(this.field_22793, label, x, y, Constants.WHITE_COLOR);
            return;
        }

        String textLower = text.toLowerCase();
        String query = searchQuery.toLowerCase();

        boolean[] highlighted = new boolean[text.length()];
        int pos = 0;
        while ((pos = textLower.indexOf(query, pos)) != -1) {
            for (int i = pos; i < pos + query.length() && i < text.length(); i++) {
                highlighted[i] = true;
            }
            pos++;
        }

        int currentX = x;
        int start = 0;

        while (start < text.length()) {
            int end = start;
            boolean isHighlighted = highlighted[start];

            while (end < text.length() && highlighted[end] == isHighlighted) {
                end++;
            }

            String segment = text.substring(start, end);
            int color = isHighlighted ? 0xFFFFFF00 : Constants.WHITE_COLOR;
            context.method_27535(this.field_22793, class_2561.method_43470(segment), currentX, y, color);
            currentX += this.field_22793.method_1727(segment);
            start = end;
        }
    }

    private void renderGlobalPreview(class_332 context) {
        int previewOffset = this.field_22789 < MAX_UI_WIDTH ? 20 : 0;
        int previewCenterX = this.field_22789 - 70 + preview_close_size + previewOffset;
        int previewCenterY = this.field_22790 / 2 + 30;
        int previewAdjustmentY = Constants.ICON_BASE_SIZE * 2;
        int verticalPadding = workingConfig.getVerticalPadding() * 5 + 3;

        renderArrowPreview(context, previewCenterX, previewCenterY - PREVIEW_BASE_SIZE * 2 - verticalPadding + previewAdjustmentY, true);
        renderIconPreview(context, previewCenterX, previewCenterY - PREVIEW_BASE_SIZE + 1);
        renderArrowPreview(context, previewCenterX, previewCenterY + verticalPadding - previewAdjustmentY + 1, false);
        renderDeathMarkerPreview(context, previewCenterX, previewCenterY + PREVIEW_BASE_SIZE);
    }

    private void renderIconPreview(class_332 context, int centerX, int centerY) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(centerX - PREVIEW_BASE_SIZE / 2f, centerY - PREVIEW_BASE_SIZE / 2f, 0);
        int textureIndex = workingConfig.getIconSize() == 4 ? 0 : 4 - workingConfig.getIconSize();

        String dotId = workingConfig.getDotType();
        String borderStyle = workingConfig.getIconBorderStyle();
        String borderType = workingConfig.getIconBorderType();
        int color = 0xFFFFFFFF;

        class_2960 dotTexture = net.bichal.bplb.client.render.TextureManager.getPlayerDotTexture(dotId, textureIndex);
        class_2960 outlineTexture = net.bichal.bplb.client.render.TextureManager.getPlayerDotOutlineTexture(dotId, borderStyle, borderType, textureIndex);

        int borderColor = workingConfig.isInheritBorderColor() ? net.bichal.bplb.util.ColorUtils.darkerColoring(color) : Constants.BLACK_COLOR;
        RenderUtils.renderTintedTexture(context, outlineTexture, 0, 0, PREVIEW_BASE_SIZE, PREVIEW_BASE_SIZE, borderColor, 1.0f);
        RenderUtils.renderTintedTexture(context, dotTexture, 0, 0, PREVIEW_BASE_SIZE, PREVIEW_BASE_SIZE, color, 1.0f);

        context.method_51448().method_22909();
    }

    private void renderArrowPreview(class_332 context, int centerX, int centerY, boolean isUp) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(centerX, centerY, 0);
        if (previewArrowAnimator == null) previewArrowAnimator = new TextureAnimator(10, 4);
        class_2960 arrowTexture = TextureManager.getArrowTexture(workingConfig.getArrowType());
        int frame = previewArrowAnimator.getCurrentFrame();
        float u = isUp ? 0 : Constants.ICON_BASE_SIZE;
        float v = frame * Constants.ICON_BASE_SIZE;
        context.method_25293(arrowTexture, -PREVIEW_BASE_SIZE / 2, -PREVIEW_BASE_SIZE / 2, PREVIEW_BASE_SIZE, PREVIEW_BASE_SIZE, u, v, Constants.ICON_BASE_SIZE, Constants.ICON_BASE_SIZE, Constants.ICON_BASE_SIZE * 2, Constants.ICON_BASE_SIZE * 2);
        context.method_51448().method_22909();
    }

    private void renderDeathMarkerPreview(class_332 context, int centerX, int centerY) {
        RenderUtils.withMatrixPush(context, centerX - PREVIEW_BASE_SIZE / 2f, centerY - PREVIEW_BASE_SIZE / 2f, () -> RenderAddons.renderDeathMarker(context, 0, 0, PREVIEW_BASE_SIZE, 1.0f, workingConfig));
    }

    private void applyChanges() {
        for (Map.Entry<String, Config.PlayerAppearance> entry : workingConfig.getPlayerConfigs().entrySet()) {
            UUID uuid = getUuidFromCache(entry.getKey());
            if (uuid != null) {
                Config.PlayerAppearance pc = entry.getValue();
                pc.playerUuid = uuid;
                pc.playerName = entry.getKey();
            }
        }

        Config.copy(workingConfig, Config.getInstance());
        Config.getInstance().save();
        hasChanges = false;
        updateButtons();
    }

    @Override
    public void method_25419() {
        if (this.field_22787 != null) this.field_22787.method_1507(this.parent);
    }

    public void markDirty() {
        hasChanges = true;
        updateButtons();
    }

    private void updateButtons() {
        if (applyButton != null) applyButton.field_22763 = hasChanges;
        if (doneButton != null) doneButton.field_22763 = !hasChanges;
    }

    private record SearchMatch(String key, List<Integer> matchIndices) {
    }
}
