package net.bichal.bplb.config.entries;

import net.bichal.bplb.config.ConfigScreen;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.bichal.bplb.config.widget.SliderWidget;
import net.bichal.bplb.util.Constants;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import java.util.List;

public abstract class AbstractSliderOptionEntry extends ScrollableListWidget.Entry {
    protected final SliderWidget slider;
    protected final class_2561 label;
    private final class_310 client;

    public AbstractSliderOptionEntry(class_310 client, String key, SliderWidget slider) {
        this.client = client;
        this.label = class_2561.method_43471(Constants.CONFIG_KEY_PREFIX + key);
        this.slider = slider;
        this.slider.updateMessage();
    }

    @Override
    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        slider.method_46421(x + entryWidth - Constants.CONFIG_SLIDER_WIDTH - Constants.CONFIG_PADDING);
        slider.method_46419(y + 2);

        if (this.client.field_1755 instanceof ConfigScreen screen) {
            screen.drawLabelWithHighlight(context, label, x + Constants.CONFIG_PADDING, y + 6, extractKeyFromLabel());
        } else {
            context.method_27535(this.client.field_1772, label, x + Constants.CONFIG_PADDING, y + 6, Constants.WHITE_COLOR);
        }

        context.method_27535(this.client.field_1772, slider.method_25369(), slider.method_46426() - this.client.field_1772.method_27525(slider.method_25369()) - 5, y + 6, Constants.WHITE_COLOR);
        slider.method_25394(context, mouseX, mouseY, tickDelta);
    }

    private String extractKeyFromLabel() {
        String fullKey = label.getString();
        if (fullKey.startsWith(Constants.CONFIG_KEY_PREFIX)) {
            return fullKey.substring(Constants.CONFIG_KEY_PREFIX.length());
        }
        return fullKey;
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return List.of(this.slider);
    }

    @Override
    public List<? extends class_364> method_25396() {
        return List.of(this.slider);
    }
}
