package net.bichal.bplb.config.entries;

import net.bichal.bplb.config.Config;
import net.bichal.bplb.config.ConfigScreen;
import net.bichal.bplb.config.widget.ButtonWidget;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.bichal.bplb.config.widget.TextInputWidget;
import net.bichal.bplb.util.Constants;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import java.util.Arrays;
import java.util.List;

public class AddPlayerEntry extends ScrollableListWidget.Entry {
    private final ConfigScreen parent;
    private final Config workingConfig;
    private final TextInputWidget inputField;
    private final ButtonWidget addButton;

    public AddPlayerEntry(class_310 client, ConfigScreen parent, Config workingConfig) {
        this.parent = parent;
        this.workingConfig = workingConfig;
        this.inputField = new TextInputWidget(client.field_1772, 0, 0, 150, 20, class_2561.method_43470(""));
        this.inputField.method_1880(16);
        this.inputField.method_47404(class_2561.method_43471("bplb.config.player_appearance.add_player").method_27692(class_124.field_1080));
        this.addButton = ButtonWidget.builder(class_2561.method_43470("+"), btn -> addPlayer()).dimensions(0, 0, 20, 20).build();
    }

    private void addPlayer() {
        String name = inputField.method_1882().trim();
        if (!name.isEmpty() && !workingConfig.getPlayerConfigs().containsKey(name)) {
            workingConfig.getPlayerConfigs().put(name, new Config.PlayerAppearance());
            parent.markDirty();
            inputField.method_1852("");
            inputField.method_25365(false);
            parent.rebuildList();
        }
    }

    @Override
    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        int inputX = x + Constants.CONFIG_PADDING;
        int inputY = y + 2;
        int buttonX = inputX + inputField.method_25368() + 5;
        int buttonY = y + 2;

        inputField.method_46421(inputX);
        inputField.method_46419(inputY);
        inputField.method_25394(context, mouseX, mouseY, tickDelta);
        addButton.field_22763 = !inputField.method_1882().trim().isEmpty() && !workingConfig.getPlayerConfigs().containsKey(inputField.method_1882().trim());
        addButton.method_46421(buttonX);
        addButton.method_46419(buttonY);
        addButton.method_25394(context, mouseX, mouseY, tickDelta);
    }

    @Override
    public List<? extends class_364> method_25396() {
        return Arrays.asList(inputField, addButton);
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return Arrays.asList(inputField, addButton);
    }
}
