package net.bichal.bplb.config.entries;

import net.bichal.bplb.config.widget.SliderWidget;
import net.bichal.bplb.util.Constants;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import java.text.DecimalFormat;
import java.util.function.Consumer;

public class FloatSliderOptionEntry extends AbstractSliderOptionEntry {
    public FloatSliderOptionEntry(class_310 client, String key, float initialValue, float min, float max, Consumer<Float> valueConsumer, Runnable onDirty) {
        super(client, key, createSlider(initialValue, min, max, valueConsumer, onDirty));
    }

    private static SliderWidget createSlider(float initialValue, float min, float max, Consumer<Float> valueConsumer, Runnable onDirty) {
        int steps = (int) ((max - min) * 20);
        boolean useSteps = steps <= Constants.CONFIG_SLIDER_WIDTH && steps > 0;

        float safeMin = Math.min(min, max);
        float safeMax = Math.max(min, max);
        float range = safeMax - safeMin;
        if (range < 0.01f) {
            range = 0.01f;
            safeMax = safeMin + range;
        }

        final float finalRange = range;
        final float finalSafeMin = safeMin;
        final float finalSafeMax = safeMax;

        return new SliderWidget(0, 0, Constants.CONFIG_SLIDER_WIDTH, 20, class_2561.method_43473(), class_3532.method_15363((initialValue - finalSafeMin) / finalRange, 0.0f, 1.0f)) {
            @Override
            public void updateMessage() {
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(2);
                float value = finalSafeMin + finalRange * (float) this.value;
                this.method_25355(class_2561.method_43470(String.valueOf(df.format(value))));
            }

            @Override
            protected void applyValue() {
                if (useSteps) {
                    int step = Math.round((float) (this.value * steps));
                    this.value = class_3532.method_15363((float) step / steps, 0.0f, 1.0f);
                }
                float value = class_3532.method_15363(finalSafeMin + finalRange * (float) this.value, finalSafeMin, finalSafeMax);
                valueConsumer.accept(value);
                onDirty.run();
            }

            @Override
            protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
                super.method_25349(mouseX, mouseY, deltaX, deltaY);
                if (useSteps) {
                    int step = Math.round((float) (this.value * steps));
                    this.value = class_3532.method_15363((float) step / steps, 0.0f, 1.0f);
                }
                updateMessage();
            }
        };
    }
}
