package net.bichal.bplb.config.entries;

import net.bichal.bplb.config.Config;
import net.bichal.bplb.config.ConfigScreen;
import net.bichal.bplb.config.widget.ButtonWidget;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.bichal.bplb.util.Constants;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import java.util.List;

public class PlayerListEntry extends ScrollableListWidget.Entry {
    private final ButtonWidget removeButton;
    private final String playerName;
    private final class_310 client;
    private final Config workingConfig;
    private final ConfigScreen parent;
    private int lastX, lastY, lastWidth, lastHeight;
    private boolean expanded;

    public PlayerListEntry(class_310 client, ConfigScreen parent, Config workingConfig, String playerName, boolean expanded) {
        this.client = client;
        this.parent = parent;
        this.playerName = playerName;
        this.workingConfig = workingConfig;
        this.expanded = expanded;

        this.removeButton = ButtonWidget.builder(class_2561.method_43470("-"), button -> {
            workingConfig.getPlayerConfigs().remove(playerName);
            parent.markDirty();
            parent.rebuildList();
        }).dimensions(0, 0, 20, 20).build();
    }

    @Override
    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.lastX = x;
        this.lastY = y;
        this.lastWidth = entryWidth;
        this.lastHeight = entryHeight;

        int bgColor = hovered ? 0xA0303030 : 0x80202020;
        context.method_25294(x + Constants.CONFIG_PADDING, y, x + entryWidth - Constants.CONFIG_PADDING * 4 + 5, y + entryHeight, bgColor);

        String arrow = expanded ? "▼" : "▶";
        context.method_27535(this.client.field_1772, class_2561.method_43470(arrow), x + Constants.CONFIG_PADDING * 2, y + 6, 0xFF808080);
        context.method_27535(this.client.field_1772, class_2561.method_43470(this.playerName), x + Constants.CONFIG_PADDING * 4, y + 6, Constants.WHITE_COLOR);

        this.removeButton.method_46421(x + entryWidth - Constants.CONFIG_PADDING - 20);
        this.removeButton.method_46419(y);
        this.removeButton.method_25394(context, mouseX, mouseY, tickDelta);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.removeButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }

        if (button == 0 && mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() &&
                mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight()) {
            this.expanded = !this.expanded;
            workingConfig.setPlayerExpanded(playerName, this.expanded);
            parent.rebuildList();
            return true;
        }
        return false;
    }

    @SuppressWarnings("unused") // Temporal
    public boolean isExpanded() {
        return expanded;
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return List.of(this.removeButton);
    }

    @Override
    public List<? extends class_364> method_25396() {
        return List.of(this.removeButton);
    }

    private int getX() { return lastX; }
    private int getY() { return lastY; }
    private int getWidth() { return lastWidth; }
    private int getHeight() { return lastHeight; }
}
