package net.bichal.bplb.config.entries;

import net.bichal.bplb.config.Config;
import net.bichal.bplb.config.ConfigScreen;
import net.bichal.bplb.config.widget.ButtonWidget;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.bichal.bplb.util.Constants;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import java.util.List;

public class ResetSettingsEntry extends ScrollableListWidget.Entry {
    private final class_310 client;
    private final ButtonWidget resetButton;
    private final ConfigScreen parentScreen;

    public ResetSettingsEntry(class_310 client, ConfigScreen parentScreen, Runnable onDirty, Config workingConfig) {
        this.client = client;
        this.parentScreen = parentScreen;
        this.resetButton = ButtonWidget.builder(class_2561.method_43471("bplb.config.reset_settings"), button -> {
            if (this.client != null) {
                this.client.method_1507(new class_410(confirmed -> {
                    if (confirmed) {
                        workingConfig.resetToDefaults();
                        onDirty.run();
                        this.parentScreen.rebuildList();
                        this.client.method_1507(this.parentScreen);
                    } else {
                        this.client.method_1507(this.parentScreen);
                    }
                }, class_2561.method_43471("bplb.config.reset_confirm.title"), class_2561.method_43471("bplb.config.reset_confirm.message")));
            }
        }).dimensions(0, 0, Constants.CONFIG_BUTTON_WIDTH + 20, 20).build();
    }

    @Override
    public void tick() {
        this.resetButton.field_22763 = class_437.method_25442();
    }

    @Override
    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.resetButton.method_46421(x + (entryWidth - this.resetButton.method_25368()) / 2);
        this.resetButton.method_46419(y + 2);
        this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return List.of(this.resetButton);
    }

    @Override
    public List<? extends class_364> method_25396() {
        return List.of(this.resetButton);
    }
}
