package net.bichal.bplb.config.entries;

import net.bichal.bplb.config.ConfigScreen;
import net.bichal.bplb.config.widget.ButtonWidget;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.bichal.bplb.util.Constants;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import java.util.List;
import java.util.function.Consumer;

public class ToggleOptionEntry extends ScrollableListWidget.Entry {
    private final ButtonWidget button;
    private final class_2561 label;
    private final class_310 client;
    private Boolean value;

    public ToggleOptionEntry(class_310 client, String key, boolean initialValue, Consumer<Boolean> valueConsumer, Runnable onDirty) {
        this.client = client;
        this.label = class_2561.method_43471(Constants.CONFIG_KEY_PREFIX + key);
        this.value = initialValue;
        this.button = ButtonWidget.builder(class_2561.method_43473(), button -> {
            this.value = !this.value;
            valueConsumer.accept(this.value);
            onDirty.run();
        }).dimensions(0, 0, Constants.CONFIG_TOGGLE_WIDTH, 20).build();
    }

    @Override
    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        if (this.client.field_1755 instanceof ConfigScreen screen) {
            String key = label.getString().replace(Constants.CONFIG_KEY_PREFIX, "");
            screen.drawLabelWithHighlight(context, this.label, x + Constants.CONFIG_PADDING, y + 6, key);
        } else {
            context.method_27535(this.client.field_1772, this.label, x + Constants.CONFIG_PADDING, y + 6, Constants.WHITE_COLOR);
        }
        button.method_46421(x + entryWidth - Constants.CONFIG_TOGGLE_WIDTH - Constants.CONFIG_PADDING);
        button.method_46419(y + 2);
        class_2561 toggleText = value ? class_2561.method_43471("gui.yes") : class_2561.method_43471("gui.no");
        int color = button.field_22763 ? (value ? 0x55FF55 : 0xFF5555) : 0xAAAAAA;
        button.method_25394(context, mouseX, mouseY, tickDelta);
        context.method_27534(this.client.field_1772, toggleText, button.method_46426() + button.method_25368() / 2, y + 8, color);
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return List.of(this.button);
    }

    @Override
    public List<? extends class_364> method_25396() {
        return List.of(this.button);
    }
}
