package net.bichal.bplb.config.widget;

import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_3532;

public abstract class AnimatedWidget extends class_339 {
    protected float hoverProgress = 0f;
    protected float borderBrightness = 0.3f;

    public AnimatedWidget(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
    }

    @SuppressWarnings("SameParameterValue") // Temporal
    protected void updateHoverAnimation(int mouseX, int mouseY, float hoverSpeed) {
        float targetHover = this.method_25405(mouseX, mouseY) ? 1f : 0f;
        hoverProgress = class_3532.method_16439(hoverSpeed, hoverProgress, targetHover);
        float targetBrightness = hoverProgress > 0.5f ? 0.6f : 0.3f;
        borderBrightness = class_3532.method_16439(0.15f, borderBrightness, targetBrightness);
    }

    protected int getBorderColor() {
        int value = (int) (0x80 * borderBrightness);
        return 0xFF000000 | (value << 16) | (value << 8) | value;
    }
}
