package net.bichal.bplb.config.widget;

import net.bichal.bplb.util.Constants;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8494;

@Environment(EnvType.CLIENT)
public abstract class PressableWidget extends AnimatedWidget {
    public PressableWidget(int i, int j, int k, int l, class_2561 text) {
        super(i, j, k, l, text);
    }
    public abstract void onPress();

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        updateHoverAnimation(mouseX, mouseY, 0.2f);
        class_310 minecraftClient = class_310.method_1551();
        renderButtonBase(context);
        context.method_51422(1.0F, 1.0F, 1.0F, this.field_22765);
        int color = this.field_22763 ? Constants.WHITE_COLOR : Constants.GRAY_COLOR;
        this.drawMessage(context, minecraftClient.field_1772, color | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
        context.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
    }

    private void renderButtonBase(class_332 context) {
        int backgroundColor = this.field_22763 ? 0x80000000 | ((int) (0x20 * borderBrightness) << 16) | ((int) (0x20 * borderBrightness) << 8 | (int) (0x20 * borderBrightness)) : 0x803D3D3D | ((int) (0x80 * borderBrightness) << 16) | ((int) (0x80 * borderBrightness) << 8 | (int) (0x80 * borderBrightness));
        int borderColor = this.field_22763 ? Constants.BLACK_COLOR | ((int) (0x80 * borderBrightness) << 16 | ((int) (0x80 * borderBrightness) << 8) | (int) (0x80 * borderBrightness)) : 0x20000000 | ((int) (0x20 * borderBrightness) << 16 | ((int) (0x20 * borderBrightness) << 8) | (int) (0x20 * borderBrightness));
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, backgroundColor);
        renderBorderButton(context, borderColor);
    }

    private void renderBorderButton(class_332 context, int borderColor) {
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + 1, borderColor);
        context.method_25294(this.method_46426(), this.method_46427() + this.field_22759 - 1, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, borderColor);
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + 1, this.method_46427() + this.field_22759, borderColor);
        context.method_25294(this.method_46426() + this.field_22758 - 1, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, borderColor);
    }

    public void drawMessage(class_332 context, class_327 textRenderer, int color) {
        int x = this.method_46426() + (this.field_22758 - textRenderer.method_27525(this.method_25369())) / 2;
        int y = this.method_46427() + (this.field_22759 - 8) / 2;
        context.method_51439(textRenderer, this.method_25369(), x, y, color, true);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        this.onPress();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        } else if (class_8494.method_51255(keyCode)) {
            this.method_25354(class_310.method_1551().method_1483());
            this.method_25348(0, 0);
            return true;
        } else {
            return false;
        }
    }
}
