package net.bichal.bplb.config.widget;

import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8015;
import net.minecraft.class_8494;
import org.lwjgl.glfw.GLFW;

public abstract class SliderWidget extends AnimatedWidget {
    public double value;
    private boolean sliderFocused;
    private static final int TRACK_HEIGHT = 2;
    private static final int HANDLE_WIDTH = 6;
    private static final int HANDLE_HEIGHT = 16;

    public SliderWidget(int x, int y, int width, int height, class_2561 text, double value) {
        super(x, y, width, height, text);
        this.value = value;
    }

    @Override
    protected class_5250 method_25360() {
        return class_2561.method_43469("gui.narrate.slider", this.method_25369());
    }

    @Override
    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, this.method_25360());
        if (this.field_22763) {
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, class_2561.method_43471("narration.slider.usage.focused"));
            } else {
                builder.method_37034(class_6381.field_33791, class_2561.method_43471("narration.slider.usage.hovered"));
            }
        }
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        updateHoverAnimation(mouseX, mouseY, 0.2f);
        int trackY = this.method_46427() + (this.field_22759 - TRACK_HEIGHT) / 2;
        int trackColor = getBorderColor();
        context.method_25294(this.method_46426() + 2, trackY, this.method_46426() + this.field_22758 - 2, trackY + TRACK_HEIGHT, trackColor);
        int filledWidth = (int) ((this.field_22758 - 4) * this.value);
        context.method_25294(this.method_46426() + 2, trackY, this.method_46426() + 2 + filledWidth, trackY + TRACK_HEIGHT, trackColor);
        int handleX = this.method_46426() + (int) ((this.field_22758 - HANDLE_WIDTH) * this.value);
        int handleY = this.method_46427() + (this.field_22759 - HANDLE_HEIGHT) / 2;
        int handleColor = getHandleColor();
        context.method_25294(handleX, handleY, handleX + HANDLE_WIDTH, handleY + HANDLE_HEIGHT, handleColor);
    }

    private int getHandleColor() {
        return 0xFF000000 | ((int) (0xC0 * borderBrightness) << 16 | (int) (0xC0 * borderBrightness) << 8) | (int) (0xC0 * borderBrightness);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    @Override
    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.sliderFocused = false;
        } else {
            class_8015 guiNavigationType = class_310.method_1551().method_48186();
            if (guiNavigationType == class_8015.field_41778 || guiNavigationType == class_8015.field_41780) {
                this.sliderFocused = true;
            }
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_8494.method_51255(keyCode)) {
            this.sliderFocused = !this.sliderFocused;
            return true;
        } else {
            if (this.sliderFocused) {
                boolean bl = keyCode == GLFW.GLFW_KEY_LEFT;
                if (bl || keyCode == GLFW.GLFW_KEY_RIGHT) {
                    float f = bl ? -1.0F : 1.0F;
                    this.setValue(this.value + (double) (f / (float) (this.field_22758 - 8)));
                    return true;
                }
            }
            return false;
        }
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double) (this.method_46426() + 4)) / (double) (this.field_22758 - 8));
    }

    private void setValue(double value) {
        double d = this.value;
        this.value = class_3532.method_15350(value, 0.0, 1.0);
        if (d != this.value) {
            this.applyValue();
        }
        this.updateMessage();
    }

    @Override
    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(mouseX);
        super.method_25349(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public void method_25354(class_1144 soundManager) {
    }

    @Override
    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
    }
    public abstract void updateMessage();
    protected abstract void applyValue();
}
