package net.bichal.bplb.network;

import net.bichal.bplb.util.Constants;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public record PositionUpdatePayload(List<PlayerInfo> newPlayers, List<PositionData> positions, List<UUID> disconnectedPlayers) implements class_8710 {
    public static final class_8710.class_9154<PositionUpdatePayload> ID = new class_8710.class_9154<>(class_2960.method_60655(Constants.MOD_ID, "position_update"));
    public static final class_9139<class_2540, PositionUpdatePayload> CODEC = class_9139.method_56438(PositionUpdatePayload::write, PositionUpdatePayload::read);
    private static final byte PRECISION_ULTRA = 0;
    private static final byte PRECISION_HIGH = 1;
    private static final byte PRECISION_MEDIUM = 2;

    public static PositionUpdatePayload read(class_2540 buf) {
        int newPlayersSize = buf.method_10816();
        List<PlayerInfo> newPlayers = new ArrayList<>(newPlayersSize);
        for (int i = 0; i < newPlayersSize; i++) {
            newPlayers.add(new PlayerInfo(buf.method_10790(), buf.method_10800(16)));
        }
        int positionsSize = buf.method_10816();
        List<PositionData> positions = new ArrayList<>(positionsSize);
        for (int i = 0; i < positionsSize; i++) {
            byte precision = buf.readByte();
            UUID uuid = buf.method_10790();
            double x, y, z;
            switch (precision) {
                case PRECISION_ULTRA -> {
                    x = buf.readInt() / 100.0;
                    y = buf.readInt() / 100.0;
                    z = buf.readInt() / 100.0;
                }
                case PRECISION_HIGH -> {
                    x = buf.readInt() / 10.0;
                    y = buf.readInt() / 10.0;
                    z = buf.readInt() / 10.0;
                }
                default -> {
                    x = buf.readInt();
                    y = buf.readInt();
                    z = buf.readInt();
                }
            }
            positions.add(new PositionData(uuid, x, y, z, 0.0));
        }
        int disconnectedSize = buf.method_10816();
        List<UUID> disconnected = new ArrayList<>(disconnectedSize);
        for (int i = 0; i < disconnectedSize; i++) {
            disconnected.add(buf.method_10790());
        }
        return new PositionUpdatePayload(newPlayers, positions, disconnected);
    }

    private static byte determinePrecision(double distance) {
        if (distance <= 32.0) return PRECISION_ULTRA;
        if (distance < 64.0) return PRECISION_HIGH;
        return PRECISION_MEDIUM;
    }

    public void write(class_2540 buf) {
        buf.method_10804(newPlayers.size());
        for (PlayerInfo player : newPlayers) {
            buf.method_10797(player.uuid());
            buf.method_10788(player.name(), 16);
        }
        buf.method_10804(positions.size());
        for (PositionData pos : positions) {
            byte precision = determinePrecision(pos.distance());
            buf.method_52997(precision);
            buf.method_10797(pos.uuid());
            switch (precision) {
                case PRECISION_ULTRA -> {
                    buf.method_53002((int) (pos.x() * 100.0));
                    buf.method_53002((int) (pos.y() * 100.0));
                    buf.method_53002((int) (pos.z() * 100.0));
                }
                case PRECISION_HIGH -> {
                    buf.method_53002((int) (pos.x() * 10.0));
                    buf.method_53002((int) (pos.y() * 10.0));
                    buf.method_53002((int) (pos.z() * 10.0));
                }
                default -> {
                    buf.method_53002((int) pos.x());
                    buf.method_53002((int) pos.y());
                    buf.method_53002((int) pos.z());
                }
            }
        }
        buf.method_10804(disconnectedPlayers.size());
        for (UUID uuid : disconnectedPlayers) {
            buf.method_10797(uuid);
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public record PlayerInfo(UUID uuid, String name) {
    }

    public record PositionData(UUID uuid, double x, double y, double z, double distance) {
    }
}
