/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.client;

import java.util.ArrayList;
import java.util.List;
import net.bichal.bplb.client.Hud;
import net.bichal.bplb.client.Keybinds;
import net.bichal.bplb.client.render.AssetScanner;
import net.bichal.bplb.command.ConfigCommand;
import net.bichal.bplb.config.Config;
import net.bichal.bplb.network.HandshakePayload;
import net.bichal.bplb.util.Constants;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class Client
implements ClientModInitializer {
    public static List<String> availableDots = new ArrayList<String>();
    public static List<String> availableArrows = new ArrayList<String>();
    public static List<String> availableIconBorders = new ArrayList<String>();
    public static List<String> availableNameBorders = new ArrayList<String>();
    public static List<String> availableDeathMarkers = new ArrayList<String>();
    private static long lastServerUpdateTime = 0L;
    private static boolean isLocalMode = true;
    private static boolean playerHasOp = false;

    public static boolean isLocalMode() {
        return isLocalMode;
    }

    public static void updateLastServerUpdateTime() {
        lastServerUpdateTime = System.currentTimeMillis();
    }

    public void onInitializeClient() {
        Constants.LOGGER.info("[{}] Initializing mod client side!", (Object)"BPLB");
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"bplb", (String)"asset_scanner");
            }

            public void method_14491(class_3300 manager) {
                availableDots = AssetScanner.getPlayerDots(manager);
                availableArrows = AssetScanner.getArrowTypes(manager);
                availableIconBorders = AssetScanner.getIconBorderStyles(manager);
                availableNameBorders = AssetScanner.getNameplateBorderStyles(manager);
                availableDeathMarkers = AssetScanner.getDeathMarkerTypes(manager);
                Constants.LOGGER.info("[{}] Scanned assets: {} dots, {} arrows, {} icon borders, {} name borders, {} death markers", new Object[]{"BPLB", availableDots.size(), availableArrows.size(), availableIconBorders.size(), availableNameBorders.size(), availableDeathMarkers.size()});
                if (!availableDots.isEmpty() && !availableDots.contains(Config.getInstance().getDotType())) {
                    Config.getInstance().setDotType(availableDots.getFirst());
                }
                if (!availableArrows.isEmpty() && !availableArrows.contains(Config.getInstance().getArrowType())) {
                    Config.getInstance().setArrowType(availableArrows.getFirst());
                }
            }
        });
        HudRenderCallback.EVENT.register((context, tickCounter) -> {
            if (!isLocalMode && System.currentTimeMillis() - lastServerUpdateTime > 5000L) {
                isLocalMode = true;
                Constants.LOGGER.info("[{}] Server timeout, switching to local mode", (Object)"BPLB");
            }
            Hud.render(context);
        });
        ClientTickEvents.END_CLIENT_TICK.register(Hud::tick);
        Hud.registerEvents();
        Config.getInstance();
        Keybinds.register();
        ConfigCommand.register();
        ClientPlayNetworking.registerGlobalReceiver(HandshakePayload.ID, (payload, context) -> {
            isLocalMode = false;
            playerHasOp = payload.playerHasOp();
            lastServerUpdateTime = System.currentTimeMillis();
            Constants.LOGGER.info("[{}] Server has mod installed (OP: {}), switching to remote mode", (Object)"BPLB", (Object)playerHasOp);
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            isLocalMode = true;
            playerHasOp = false;
            lastServerUpdateTime = 0L;
        });
        Constants.LOGGER.info("[{}] Client side initialized!", (Object)"BPLB");
    }
}

