/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.client.render;

import java.awt.Dimension;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.bichal.bplb.util.Constants;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class AssetScanner {
    private static final Map<class_2960, Dimension> dimensionCache = new HashMap<class_2960, Dimension>();

    public static List<String> getPlayerDots(class_3300 resourceManager) {
        String[] dotTypes;
        ArrayList<String> dots = new ArrayList<String>();
        for (String dotType : dotTypes = new String[]{"default", "minimal", "mojang", "bowtie"}) {
            class_2960 testId = class_2960.method_60655((String)"bplb", (String)String.format("textures/sprites/hud/player_dots/%s_0.png", dotType));
            if (!resourceManager.method_14486(testId).isPresent()) continue;
            dots.add(dotType);
        }
        return dots;
    }

    public static List<String> getIconBorderStyles(class_3300 resourceManager) {
        return AssetScanner.checkExistence(resourceManager, new String[]{"rounded", "squared"}, style -> String.format("textures/sprites/hud/player_dots_outlines/%s/default_0.png", style));
    }

    public static List<String> getNameplateBorderStyles(class_3300 resourceManager) {
        return AssetScanner.checkExistence(resourceManager, new String[]{"rounded", "squared"}, style -> String.format("textures/sprites/hud/tags/%s/default.png", style));
    }

    public static List<String> getArrowTypes(class_3300 resourceManager) {
        return AssetScanner.checkExistence(resourceManager, new String[]{"default", "mojang"}, arrow -> String.format("textures/sprites/hud/arrows/%s.png", arrow));
    }

    public static List<String> getDeathMarkerTypes(class_3300 resourceManager) {
        return AssetScanner.checkExistence(resourceManager, new String[]{"default", "minimal"}, marker -> String.format("textures/sprites/hud/death_markers_dots/%s.png", marker));
    }

    private static List<String> checkExistence(class_3300 resourceManager, String[] types, Function<String, String> pathBuilder) {
        ArrayList<String> result = new ArrayList<String>();
        for (String type : types) {
            class_2960 testId = class_2960.method_60655((String)"bplb", (String)pathBuilder.apply(type));
            if (!resourceManager.method_14486(testId).isPresent()) continue;
            result.add(type);
        }
        return result;
    }

    public static Dimension getTextureDimensions(class_2960 id) {
        return dimensionCache.computeIfAbsent(id, key -> {
            block14: {
                try {
                    class_3300 resourceManager = class_310.method_1551().method_1478();
                    Optional resourceOpt = resourceManager.method_14486(key);
                    if (!resourceOpt.isPresent()) break block14;
                    try (InputStream stream = ((class_3298)resourceOpt.get()).method_14482();){
                        Dimension dimension;
                        block15: {
                            class_1011 image = class_1011.method_4309((InputStream)stream);
                            try {
                                dimension = new Dimension(image.method_4307(), image.method_4323());
                                if (image == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (image != null) {
                                    try {
                                        image.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            image.close();
                        }
                        return dimension;
                    }
                }
                catch (Exception e) {
                    Constants.LOGGER.warn("Could not read dimensions for texture: {}", key, (Object)e);
                }
            }
            return new Dimension(9, 9);
        });
    }
}

