/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.config.entries;

import java.util.List;
import java.util.function.Consumer;
import net.bichal.bplb.config.ConfigScreen;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.bichal.bplb.config.widget.TextInputWidget;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6379;

public class ColorTextFieldEntry
extends ScrollableListWidget.Entry {
    private final TextInputWidget textField;
    private final class_2561 label;
    private final class_310 client;
    private final Consumer<Integer> valueConsumer;
    private final ConfigScreen parent;
    private Integer currentColor;

    public ColorTextFieldEntry(class_310 client, String key, int initialColor, Consumer<Integer> valueConsumer, ConfigScreen parent) {
        this.client = client;
        this.parent = parent;
        this.label = class_2561.method_43471((String)("bplb.config." + key));
        this.currentColor = initialColor;
        this.valueConsumer = valueConsumer;
        String hexValue = String.format("%06X", initialColor & 0xFFFFFF);
        this.textField = new TextInputWidget(client.field_1772, 0, 0, 80, 20, (class_2561)class_2561.method_43470((String)hexValue));
        this.textField.method_1852(hexValue);
        this.textField.method_1880(6);
        this.textField.method_1863(this::onTextChanged);
    }

    private void onTextChanged(String text) {
        if (text.isEmpty()) {
            return;
        }
        String sanitized = text.toUpperCase();
        try {
            int color = Integer.parseInt(sanitized, 16);
            this.currentColor = 0xFF1A1A1A | color;
            this.valueConsumer.accept(this.currentColor);
            this.parent.markDirty();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        context.method_27535(this.client.field_1772, this.label, x + 10, y + 6, 0xFAFAFA);
        int fieldWidth = 76;
        int fieldX = x + entryWidth - 100 - 10;
        int previewX = fieldX + fieldWidth + 4;
        this.textField.method_46421(fieldX);
        this.textField.method_46419(y + 2);
        this.textField.method_25358(fieldWidth);
        this.textField.method_25394(context, mouseX, mouseY, tickDelta);
        context.method_25294(previewX, y + 2, previewX + 20, y + 22, this.currentColor.intValue());
        context.method_49601(previewX, y + 2, 20, 20, 0xFAFAFA);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.textField.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (chr >= '0' && chr <= '9' || chr >= 'A' && chr <= 'F' || chr >= 'a' && chr <= 'f') {
            return this.textField.method_25400(chr, modifiers);
        }
        return false;
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (focused) {
            this.textField.method_25365(true);
        }
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return List.of(this.textField);
    }

    @Override
    public List<? extends class_364> method_25396() {
        return List.of(this.textField);
    }
}

