/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.bichal.bplb.client.Client;
import net.bichal.bplb.client.Keybinds;
import net.bichal.bplb.client.render.RenderAddons;
import net.bichal.bplb.client.render.RenderUtils;
import net.bichal.bplb.config.Config;
import net.bichal.bplb.network.PositionUpdatePayload;
import net.bichal.bplb.util.ColorUtils;
import net.bichal.bplb.util.Constants;
import net.bichal.bplb.util.DistanceUtils;
import net.bichal.bplb.util.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;

@Environment(value=EnvType.CLIENT)
public class Hud {
    private static final Map<UUID, PlayerPosition> playerPositions = new HashMap<UUID, PlayerPosition>();
    private static final Map<Object, Float> currentIconPositions = new HashMap<Object, Float>();
    public static final List<class_243> deathMarkers = new ArrayList<class_243>();
    private static final int MAX_DEATH_MARKERS = 4;
    private static List<PlayerPosition> positionsToRenderCache = new ArrayList<PlayerPosition>();
    private static final Map<Object, class_243> lastKnownPositions = new HashMap<Object, class_243>();
    private static final Map<Object, Long> lastPositionUpdateTime = new HashMap<Object, Long>();
    private static boolean shouldApplyHudOffset = false;
    private static final float MIN_Z_DEPTH = 500.0f;

    private static void updateRenderCache(class_310 client) {
        if (client.field_1724 == null) {
            positionsToRenderCache.clear();
            return;
        }
        List<PlayerPosition> positions = Hud.getPositionsToRender(client);
        positions.removeIf(pos -> pos.uuid().equals(client.field_1724.method_5667()));
        class_243 playerPos = client.field_1724.method_19538();
        int maxIcons = Constants.CONFIG.getMaxVisibleIcons();
        positions.sort(Comparator.comparingDouble(pos -> {
            double dx = playerPos.field_1352 - pos.x;
            double dz = playerPos.field_1350 - pos.z;
            return dx * dx + dz * dz;
        }));
        for (PlayerPosition pos2 : positions) {
            if (!currentIconPositions.containsKey(pos2.uuid())) {
                float initialPos = Hud.calculateRelativePosition((class_1657)client.field_1724, pos2);
                if (!(initialPos >= 0.0f)) continue;
                currentIconPositions.put(pos2.uuid(), Float.valueOf(initialPos * 182.0f));
                continue;
            }
            float currentPos = Hud.calculateRelativePosition((class_1657)client.field_1724, pos2);
            if (!(currentPos < 0.0f)) continue;
            currentIconPositions.remove(pos2.uuid());
        }
        for (class_243 marker : deathMarkers) {
            PlayerPosition markerPos;
            float initialPos;
            if (currentIconPositions.containsKey(marker) || !((initialPos = Hud.calculateRelativePosition((class_1657)client.field_1724, markerPos = new PlayerPosition(new UUID(marker.hashCode(), marker.hashCode()), "Death", marker.field_1352, marker.field_1351, marker.field_1350))) >= 0.0f)) continue;
            currentIconPositions.put(marker, Float.valueOf(initialPos * 182.0f));
        }
        positionsToRenderCache = positions.size() > maxIcons ? new ArrayList<PlayerPosition>(positions.subList(0, maxIcons)) : new ArrayList<PlayerPosition>(positions);
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        Hud.updateRenderCache(client);
        if (client.field_1724 != null) {
            deathMarkers.removeIf(marker -> {
                if (client.field_1724.method_19538().method_1022(marker) < 10.0) {
                    currentIconPositions.remove(marker);
                    return true;
                }
                return false;
            });
        }
    }

    public static void addDeathLocation(class_243 location) {
        if (deathMarkers.stream().anyMatch(marker -> marker.method_1022(location) < 5.0)) {
            return;
        }
        deathMarkers.add(location);
        while (deathMarkers.size() > 4) {
            class_243 oldest = deathMarkers.removeFirst();
            currentIconPositions.remove(oldest);
        }
    }

    public static void registerEvents() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            playerPositions.clear();
            currentIconPositions.clear();
            deathMarkers.clear();
            lastKnownPositions.clear();
            lastPositionUpdateTime.clear();
            Constants.LOGGER.info("[{}] Cleared all caches on join", (Object)"BPLB");
            ClientPlayNetworking.registerReceiver(PositionUpdatePayload.ID, (payload, context) -> {
                Client.updateLastServerUpdateTime();
                client.execute(() -> {
                    List<PositionUpdatePayload.PositionData> list;
                    List<PositionUpdatePayload.PlayerInfo> newPlayersList;
                    if (payload == null) {
                        return;
                    }
                    List<UUID> disconnectedList = payload.disconnectedPlayers();
                    if (disconnectedList != null) {
                        for (UUID uUID : disconnectedList) {
                            if (uUID == null) continue;
                            playerPositions.remove(uUID);
                            currentIconPositions.remove(uUID);
                        }
                    }
                    if ((newPlayersList = payload.newPlayers()) != null) {
                        for (PositionUpdatePayload.PlayerInfo newPlayer : newPlayersList) {
                            if (newPlayer == null || newPlayer.uuid() == null) continue;
                            PlayerPosition existingData = playerPositions.get(newPlayer.uuid());
                            if (existingData != null) {
                                playerPositions.put(newPlayer.uuid(), new PlayerPosition(newPlayer.uuid(), newPlayer.name(), existingData.x(), existingData.y(), existingData.z()));
                                continue;
                            }
                            playerPositions.put(newPlayer.uuid(), new PlayerPosition(newPlayer.uuid(), newPlayer.name(), 0.0, 0.0, 0.0));
                        }
                    }
                    if ((list = payload.positions()) != null) {
                        for (PositionUpdatePayload.PositionData posUpdate : list) {
                            String name;
                            if (posUpdate == null || posUpdate.uuid() == null) continue;
                            PlayerPosition existingPosData = playerPositions.get(posUpdate.uuid());
                            if (existingPosData != null) {
                                name = existingPosData.name();
                            } else {
                                class_1657 localPlayer = client.field_1687 != null ? client.field_1687.method_18470(posUpdate.uuid()) : null;
                                name = localPlayer != null ? localPlayer.method_5477().getString() : "Player";
                            }
                            playerPositions.put(posUpdate.uuid(), new PlayerPosition(posUpdate.uuid(), name, posUpdate.x(), posUpdate.y(), posUpdate.z()));
                        }
                    }
                });
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null || !Constants.CONFIG.isModEnabled()) {
            shouldApplyHudOffset = false;
            return;
        }
        if (positionsToRenderCache.isEmpty() && deathMarkers.isEmpty()) {
            shouldApplyHudOffset = false;
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int barX = (context.method_51421() - 182) / 2;
        int barY = context.method_51443() + -26;
        boolean showDetails = Keybinds.shouldShowPlayerNames() || Constants.CONFIG.isAlwaysShowPlayerNames();
        ArrayList<RenderEntry> allEntries = new ArrayList<RenderEntry>();
        for (PlayerPosition pos : positionsToRenderCache) {
            class_1657 targetPlayer = client.field_1687.method_18470(pos.uuid());
            if (targetPlayer != null && Hud.shouldHideTarget(targetPlayer)) continue;
            double distance = DistanceUtils.calculateDistance(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321(), pos.x, pos.y, pos.z);
            float alpha = Hud.getDistanceAlpha(distance);
            allEntries.add(new RenderEntry(pos, pos.uuid(), distance, alpha, false));
        }
        for (class_243 marker : deathMarkers) {
            double distance = DistanceUtils.calculateDistance(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321(), marker.field_1352, marker.field_1351, marker.field_1350);
            PlayerPosition markerPos = new PlayerPosition(new UUID(marker.hashCode(), marker.hashCode()), "Death", marker.field_1352, marker.field_1351, marker.field_1350);
            allEntries.add(new RenderEntry(markerPos, marker, distance, 1.0f, true));
        }
        allEntries.sort(Comparator.comparingDouble(RenderEntry::distance).reversed());
        for (int i = 0; i < allEntries.size(); ++i) {
            RenderEntry entry = (RenderEntry)allEntries.get(i);
            float baseZ = 500.0f + (float)i * 100.0f;
            context.method_51448().method_22903();
            try {
                Hud.renderBarIcon(context, entry.pos, entry.key, barX, barY, baseZ, showDetails, entry.alpha);
                continue;
            }
            finally {
                context.method_51448().method_22909();
            }
        }
        RenderSystem.disableBlend();
        shouldApplyHudOffset = Hud.hasVisibleIconsInVisibleRange(client);
    }

    public static boolean hasVisibleIconsInVisibleRange(class_310 client) {
        if (client.field_1724 == null) {
            return false;
        }
        int barLeft = (client.method_22683().method_4486() - 182) / 2;
        int barRight = barLeft + 182;
        for (PlayerPosition pos : positionsToRenderCache) {
            Float currentPos;
            float targetPos = Hud.calculateRelativePosition((class_1657)client.field_1724, pos);
            if (targetPos < 0.0f || !Hud.currentIconPos(barLeft, barRight, currentPos = currentIconPositions.get(pos.uuid()))) continue;
            return true;
        }
        for (class_243 marker : deathMarkers) {
            Float currentPos;
            PlayerPosition markerPos = new PlayerPosition(new UUID(marker.hashCode(), marker.hashCode()), "Death", marker.field_1352, marker.field_1351, marker.field_1350);
            float targetPos = Hud.calculateRelativePosition((class_1657)client.field_1724, markerPos);
            if (targetPos < 0.0f || !Hud.currentIconPos(barLeft, barRight, currentPos = currentIconPositions.get(marker))) continue;
            return true;
        }
        return false;
    }

    private static boolean currentIconPos(int barLeft, int barRight, Float currentPos) {
        if (currentPos != null) {
            int iconCenterX = barLeft + Math.round(currentPos.floatValue());
            int iconLeft = iconCenterX - 5;
            int iconRight = iconCenterX + 5;
            return iconRight >= barLeft && iconLeft <= barRight;
        }
        return false;
    }

    private static void renderBarIcon(class_332 context, PlayerPosition pos, Object key, int barX, int barY, float baseZ, boolean showDetails, float alpha) {
        String borderStyle;
        int color;
        Config.PlayerAppearance appearance;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        Float targetPos = Float.valueOf(Hud.calculateRelativePosition((class_1657)client.field_1724, pos));
        if (targetPos.floatValue() < 0.0f) {
            return;
        }
        Float currentPos = currentIconPositions.getOrDefault(key, targetPos = Float.valueOf(targetPos.floatValue() * 182.0f));
        float distance = Math.abs(currentPos.floatValue() - targetPos.floatValue());
        if (distance > 136.5f) {
            currentPos = targetPos;
            currentIconPositions.put(key, currentPos);
        } else {
            float delta = targetPos.floatValue() - currentPos.floatValue();
            float t = Math.min(Constants.CONFIG.getLerpSpeed(), 1.0f);
            currentPos = Float.valueOf(currentPos.floatValue() + delta * MathUtils.easeInOutQuad(t));
            currentIconPositions.put(key, currentPos);
        }
        int iconCenterX = barX + Math.round(currentPos.floatValue());
        float edgeAlpha = Hud.calculateEdgeAlpha(iconCenterX, barX);
        alpha *= edgeAlpha;
        if (alpha <= 0.01f && Math.abs(currentPos.floatValue() - targetPos.floatValue()) < 1.0f) {
            return;
        }
        float topLeftX = (float)iconCenterX - 4.5f;
        float topLeftY = (float)barY - 4.5f;
        boolean isDeathMarker = key instanceof class_243;
        boolean showHead = !isDeathMarker && (Constants.CONFIG.isAlwaysShowPlayerHeads() || Keybinds.shouldShowPlayerNames());
        Config.PlayerAppearance playerAppearance = appearance = isDeathMarker ? null : Constants.CONFIG.getPlayerConfig(pos.name());
        if (isDeathMarker) {
            color = Constants.CONFIG.getDeathMarkerColor();
            borderStyle = Constants.CONFIG.getDeathMarkerBorderStyle();
        } else {
            color = appearance != null && appearance.color != null ? appearance.color : ColorUtils.generateColorFromUUID(pos.uuid());
            borderStyle = appearance != null && appearance.iconBorderStyle != null ? appearance.iconBorderStyle : Constants.CONFIG.getNameBorderStyle();
        }
        context.method_51448().method_46416(0.0f, 0.0f, baseZ);
        if (isDeathMarker) {
            RenderAddons.renderDeathMarker(context, topLeftX, topLeftY, 9, alpha, Constants.CONFIG);
        } else {
            double iconDistance = DistanceUtils.calculateDistance(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321(), pos.x, pos.y, pos.z);
            RenderAddons.renderPlayerIcon(context, pos.name(), pos.uuid(), iconDistance, topLeftX, topLeftY, 9, showHead, Constants.CONFIG, alpha);
        }
        Hud.renderHeightIndicator(context, pos, iconCenterX, (int)(topLeftY + 4.5f), alpha, appearance);
        if (showDetails) {
            String text = isDeathMarker ? (int)pos.x + " " + (int)pos.y + " " + (int)pos.z : pos.name();
            RenderAddons.renderNameplate(context, text, borderStyle, color, (float)iconCenterX - ((float)client.field_1772.method_1727(text) * Constants.CONFIG.getNameplateScale() + 4.0f) / 2.0f, topLeftY - 12.0f * Constants.CONFIG.getNameplateScale() - 4.0f, alpha, Constants.CONFIG.getNameplateScale());
        }
    }

    public static boolean shouldApplyHudOffset() {
        return shouldApplyHudOffset;
    }

    private static boolean showUp(class_310 client, PlayerPosition pos) {
        return Hud.isArrowUp(client, pos);
    }

    private static boolean showDown(class_310 client, PlayerPosition pos) {
        return Hud.isArrowDown(client, pos);
    }

    private static void renderHeightIndicator(class_332 context, PlayerPosition pos, int centerX, int centerY, float alpha, Config.PlayerAppearance appearance) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (Hud.showUp(client, pos) || Hud.showDown(client, pos)) {
            String arrowId = appearance != null && appearance.arrowType != null ? appearance.arrowType : Constants.CONFIG.getArrowType();
            Hud.renderHeightArrow(context, centerX, centerY, alpha, Hud.showUp(client, pos), arrowId);
        }
    }

    private static void renderHeightArrow(class_332 context, int centerX, int centerY, float alpha, boolean isUp, String arrowId) {
        int arrowX = centerX - 5;
        int arrowY = isUp ? centerY - 9 - 2 - Constants.CONFIG.getVerticalPadding() : centerY + 2 + Constants.CONFIG.getVerticalPadding();
        RenderAddons.renderArrow(context, arrowId, isUp, arrowX, arrowY, 9, alpha);
    }

    private static List<PlayerPosition> getPositionsToRender(class_310 client) {
        boolean useServerData;
        if (client.field_1687 == null || client.field_1724 == null) {
            return Collections.emptyList();
        }
        boolean bl = useServerData = !Client.isLocalMode();
        if (useServerData && !playerPositions.isEmpty()) {
            return new ArrayList<PlayerPosition>(playerPositions.values());
        }
        return client.field_1687.method_18456().stream().filter(p -> !p.method_5667().equals(client.field_1724.method_5667())).map(p -> new PlayerPosition(p.method_5667(), p.method_5477().getString(), p.method_23317(), p.method_23318(), p.method_23321())).collect(Collectors.toList());
    }

    private static float getDistanceAlpha(double distance) {
        if (distance > (double)Constants.CONFIG.getFadeEndDistance()) {
            return Constants.CONFIG.getFadeAlphaMin();
        }
        if (distance < (double)Constants.CONFIG.getFadeStartDistance()) {
            return Constants.CONFIG.getFadeAlphaMax();
        }
        float progress = (float)((distance - (double)Constants.CONFIG.getFadeStartDistance()) / (double)(Constants.CONFIG.getFadeEndDistance() - Constants.CONFIG.getFadeStartDistance()));
        return class_3532.method_16439((float)MathUtils.easeInOutQuad(progress), (float)Constants.CONFIG.getFadeAlphaMax(), (float)Constants.CONFIG.getFadeAlphaMin());
    }

    private static boolean isArrowUp(class_310 client, PlayerPosition pos) {
        return Hud.shouldShowArrow(client, pos, true);
    }

    private static boolean isArrowDown(class_310 client, PlayerPosition pos) {
        return Hud.shouldShowArrow(client, pos, false);
    }

    private static double getDynamicAngleThreshold(class_310 client, PlayerPosition pos) {
        if (client.field_1724 == null) {
            return 0.0;
        }
        double dx = pos.x - client.field_1724.method_23317();
        double dz = pos.z - client.field_1724.method_23321();
        double deltaH = Math.sqrt(dx * dx + dz * dz);
        double deltaY = Math.abs(pos.y - (client.field_1724.method_23318() + 1.0));
        double minAngle = 8.0;
        double maxAngle = 45.0;
        double maxEffectiveDeltaY = 30.0;
        double maxEffectiveDeltaH = 64.0;
        double yFactor = 1.0 - Math.min(deltaY, maxEffectiveDeltaY) / maxEffectiveDeltaY;
        double hFactor = 1.0 - Math.min(deltaH, maxEffectiveDeltaH) / maxEffectiveDeltaH;
        return class_3532.method_16436((double)(yFactor * hFactor), (double)minAngle, (double)maxAngle);
    }

    private static double getCameraAngleDifference(class_4184 camera, PlayerPosition pos) {
        class_243 cameraPos = camera.method_19326();
        double dx = pos.x - cameraPos.field_1352;
        double dz = pos.z - cameraPos.field_1350;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        double targetY = pos.y + 1.62;
        return -(Math.toDegrees(Math.atan2(targetY - cameraPos.field_1351, horizontalDist)) + (double)camera.method_19329());
    }

    private static float calculateRelativePosition(class_1657 viewer, PlayerPosition target) {
        long timeDelta;
        class_243 currentPos;
        if (viewer == null) {
            return -1.0f;
        }
        class_243 smoothedPos = currentPos = new class_243(target.x, target.y, target.z);
        Long currentTime = System.currentTimeMillis();
        class_243 lastPos = lastKnownPositions.get(target.uuid());
        Long lastTime = lastPositionUpdateTime.get(target.uuid());
        if (lastPos != null && lastTime != null && (timeDelta = currentTime - lastTime) < 1000L) {
            float alpha = Math.min((float)timeDelta / 100.0f * Constants.CONFIG.getLerpSpeed(), 1.0f);
            smoothedPos = lastPos.method_35590(currentPos, (double)MathUtils.easeInOutQuad(alpha));
        }
        lastKnownPositions.put(target.uuid(), smoothedPos);
        lastPositionUpdateTime.put(target.uuid(), currentTime);
        double relativeAngle = Hud.getRelativeAngle(viewer, smoothedPos);
        if (Math.abs(relativeAngle) > 90.0) {
            return -1.0f;
        }
        return (float)(relativeAngle + 90.0) / 180.0f;
    }

    private static double getRelativeAngle(class_1657 viewer, class_243 smoothedPos) {
        double relativeAngle = class_3532.method_15338((double)(Math.toDegrees(Math.atan2(smoothedPos.field_1350 - viewer.method_23321(), smoothedPos.field_1352 - viewer.method_23317())) - 90.0 - (double)class_3532.method_15393((float)viewer.method_36454())));
        if (Constants.CONFIG.isAdjustToFov()) {
            class_310 client = RenderUtils.getClient();
            float fov = ((Integer)client.field_1690.method_41808().method_41753()).intValue();
            float fovFactor = 90.0f / fov * Constants.CONFIG.getFovMultiplier();
            relativeAngle *= (double)fovFactor;
        }
        return relativeAngle;
    }

    private static float calculateEdgeAlpha(int iconX, int barX) {
        int edgeDistance = Math.min(iconX - barX, 182 - (iconX - barX));
        if (edgeDistance >= 10) {
            return 1.0f;
        }
        return class_3532.method_15363((float)((float)edgeDistance / 10.0f), (float)0.0f, (float)1.0f);
    }

    private static boolean shouldHideTarget(class_1657 target) {
        class_1799 headStack = target.method_6118(class_1304.field_6169);
        return target.method_5715() || target.method_5767() || !headStack.method_7960() && !(headStack.method_7909() instanceof class_1738);
    }

    private static boolean shouldShowArrow(class_310 client, PlayerPosition pos, boolean up) {
        if (client.field_1724 == null) {
            return false;
        }
        if (Constants.CONFIG.getHeightDifferenceMode().equalsIgnoreCase("player")) {
            double diff = pos.y - (client.field_1724.method_23318() + 1.0);
            return up ? diff > 5.5 : diff < -5.5;
        }
        double angleDiff = Hud.getCameraAngleDifference(client.field_1773.method_19418(), pos);
        double threshold = Hud.getDynamicAngleThreshold(client, pos);
        return up ? angleDiff < -threshold : angleDiff > threshold;
    }

    public record PlayerPosition(UUID uuid, String name, double x, double y, double z) {
    }

    private record RenderEntry(PlayerPosition pos, Object key, double distance, float alpha, boolean isDeathMarker) {
    }
}

