/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.client.render;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.bichal.bplb.client.render.RenderUtils;
import net.bichal.bplb.client.render.TextureAnimator;
import net.bichal.bplb.client.render.TextureManager;
import net.bichal.bplb.config.Config;
import net.bichal.bplb.util.ColorUtils;
import net.bichal.bplb.util.Constants;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class RenderAddons {
    private static final Map<String, TextureAnimator> textureAnimators = new HashMap<String, TextureAnimator>();

    private static void renderIcon(class_332 context, float x, float y, int size, float alpha, String dotId, String borderStyle, String borderType, int color, int textureIndex, Config config) {
        class_2960 dotTexture = TextureManager.getPlayerDotTexture(dotId, textureIndex);
        class_2960 outlineTexture = TextureManager.getPlayerDotOutlineTexture(dotId, borderStyle, borderType, textureIndex);
        int borderColor = config.isInheritBorderColor() ? ColorUtils.darkerColoring(color) : -16777216;
        RenderUtils.renderTintedTexture(context, outlineTexture, x, y, size, size, borderColor, alpha);
        RenderUtils.renderTintedTexture(context, dotTexture, x, y, size, size, color, alpha);
    }

    public static void renderPlayerIcon(class_332 context, String playerName, UUID playerUuid, double distance, float x, float y, int size, boolean showHead, Config config, float alpha) {
        Config.PlayerAppearance appearance = config.getPlayerConfig(playerName);
        int textureIndex = RenderAddons.getAdjustedTextureIndex(distance, config);
        String dotId = appearance != null && appearance.dotType != null ? appearance.dotType : config.getDotType();
        String borderStyle = appearance != null && appearance.iconBorderStyle != null ? appearance.iconBorderStyle : config.getIconBorderStyle();
        int color = appearance != null && appearance.color != null ? appearance.color : ColorUtils.generateColorFromUUID(playerUuid);
        RenderAddons.renderIcon(context, x, y, size, alpha, dotId, borderStyle, config.getIconBorderType(), color, showHead ? 0 : textureIndex, config);
        String textureOverride = appearance != null ? appearance.textureHeadOverride : null;
        RenderAddons.renderPlayerHeadOverlay(context, playerUuid, x, y, size, textureOverride, showHead ? 1.0f * alpha : 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderPlayerHeadOverlay(class_332 context, UUID playerUuid, float x, float y, int size, String textureOverride, float alpha) {
        class_310 client = class_310.method_1551();
        if (alpha <= 0.01f) {
            return;
        }
        if (client.field_1687 == null || playerUuid == null) {
            return;
        }
        class_2960 skin = Constants.STEVE_SKIN_TEXTURE;
        try {
            if (textureOverride != null && !textureOverride.isEmpty()) {
                class_742 overridePlayer;
                UUID overrideUuid = RenderAddons.getUuidFromCache(textureOverride);
                if (overrideUuid != null && (overridePlayer = (class_742)client.field_1687.method_18470(overrideUuid)) != null && overridePlayer.method_52814() != null) {
                    skin = overridePlayer.method_52814().comp_1626();
                }
            } else {
                class_742 player = (class_742)client.field_1687.method_18470(playerUuid);
                if (player != null && player.method_52814() != null) {
                    skin = player.method_52814().comp_1626();
                }
            }
        }
        catch (Exception e) {
            Constants.LOGGER.debug("Error loading skin texture", (Throwable)e);
        }
        try {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int padding = 2;
            int texSize = Math.max(1, size - padding * 2);
            context.method_25293(skin, (int)x + padding, (int)y + padding, texSize, texSize, 8.0f, 8.0f, 8, 8, 64, 64);
        }
        finally {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderDeathMarker(class_332 context, float x, float y, int size, float alpha, Config config) {
        String markerType = config.getDeathMarkerType();
        int color = config.getDeathMarkerColor();
        class_2960 markerTexture = TextureManager.getDeathMarkerTexture(markerType);
        class_2960 outlineTexture = TextureManager.getDeathMarkerOutlineTexture(markerType, config.getDeathMarkerBorderStyle(), config.getDeathMarkerBorderType());
        int borderColor = config.isDeathMarkerInheritBorderColor() ? ColorUtils.darkerColoring(color) : -16777216;
        RenderUtils.renderTintedTexture(context, outlineTexture, x, y, size, size, borderColor, alpha);
        RenderUtils.renderTintedTexture(context, markerTexture, x, y, size, size, color, alpha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderArrow(class_332 context, String arrowType, boolean isUp, float x, float y, int size, float alpha) {
        if (alpha <= 0.01f) {
            return;
        }
        TextureAnimator animator = textureAnimators.computeIfAbsent(arrowType + "_" + isUp, k -> new TextureAnimator(10, 4));
        class_2960 arrowTexture = TextureManager.getArrowTexture(arrowType);
        context.method_51448().method_22903();
        try {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int frame = animator.getCurrentFrame();
            float u = isUp ? 0.0f : 9.0f;
            float v = frame * 9;
            context.method_25293(arrowTexture, (int)x, (int)y, size, size, u, v, 9, 9, 18, 18);
        }
        finally {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            context.method_51448().method_22909();
        }
    }

    public static void renderNameplate(class_332 context, String text, String borderStyle, int color, float x, float y, float alpha, float scale) {
        if (alpha <= 0.01f) {
            return;
        }
        class_310 client = class_310.method_1551();
        int textWidth = client.field_1772.method_1727(text);
        int boxWidth = (int)((float)textWidth * scale) + 4;
        int boxHeight = (int)(12.0f * scale);
        class_2960 nameplateTexture = TextureManager.getNameplateTexture(borderStyle);
        int tintColor = ColorUtils.darkerColoring(color);
        RenderUtils.withMatrixPush(context, x, y, () -> {
            RenderUtils.setShaderColorRGBA(tintColor, alpha);
            RenderUtils.drawNineSlicedTexture(context, nameplateTexture, 0, 0, boxWidth, boxHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_51448().method_46416((float)boxWidth / 2.0f, (float)boxHeight / 2.0f, 1.0f);
            context.method_51448().method_22905(scale, scale, 1.0f);
            int textColor = 0xFAFAFA | (int)(alpha * 255.0f) << 24;
            class_327 class_3272 = client.field_1772;
            int n = -textWidth / 2;
            Objects.requireNonNull(client.field_1772);
            context.method_51433(class_3272, text, n, -9 / 2, textColor, true);
        });
    }

    private static int getAdjustedTextureIndex(double distance, Config config) {
        int baseIndex = TextureManager.getTextureIndexFromDistance(distance);
        int configSize = config.getIconSize();
        int offset = 4 - configSize;
        return Math.min(3, Math.max(0, baseIndex + offset));
    }

    @Nullable
    public static UUID getUuidFromCache(String nameOrUuid) {
        if (nameOrUuid == null || nameOrUuid.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(nameOrUuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UUID directUuid = RenderAddons.getUuid(nameOrUuid);
            if (directUuid != null) {
                return directUuid;
            }
            try {
                File cacheFile = FabricLoader.getInstance().getGameDir().resolve("usercache.json").toFile();
                if (!cacheFile.exists()) {
                    return null;
                }
                byte[] data = Files.readAllBytes(cacheFile.toPath());
                if (data.length == 0) {
                    return null;
                }
                String json = new String(data);
                if (json.trim().isEmpty()) {
                    return null;
                }
                JsonElement element = JsonParser.parseString((String)json);
                if (!element.isJsonArray()) {
                    return null;
                }
                JsonArray array = element.getAsJsonArray();
                for (JsonElement entry : array) {
                    String objName;
                    JsonObject obj;
                    if (!entry.isJsonObject() || !(obj = entry.getAsJsonObject()).has("name") || !obj.has("uuid")) continue;
                    JsonElement nameEl = obj.get("name");
                    JsonElement uuidEl = obj.get("uuid");
                    if (nameEl == null || uuidEl == null || !nameEl.isJsonPrimitive() || !uuidEl.isJsonPrimitive() || (objName = nameEl.getAsString()) == null || !objName.equalsIgnoreCase(nameOrUuid)) continue;
                    try {
                        return UUID.fromString(uuidEl.getAsString());
                    }
                    catch (Exception e) {
                        Constants.LOGGER.debug("Invalid UUID entry in usercache.json");
                    }
                }
            }
            catch (Exception e) {
                Constants.LOGGER.debug("Failed to read usercache.json", (Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    public static UUID getUuid(String name) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            for (class_742 player : client.field_1687.method_18456()) {
                if (!player.method_5477().getString().equals(name)) continue;
                return player.method_5667();
            }
        }
        return null;
    }
}

