/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.config.entries;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.bichal.bplb.config.ConfigScreen;
import net.bichal.bplb.config.widget.ButtonWidget;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6379;

public class CycleOptionEntry<T>
extends ScrollableListWidget.Entry {
    private final ButtonWidget button;
    private final class_2561 label;
    private final List<T> options;
    private final String key;
    private T value;
    private final Function<T, class_2561> textProvider;
    private final Consumer<T> valueConsumer;
    private final Runnable onDirty;
    private final boolean activeCycle;
    private final class_310 client;

    public CycleOptionEntry(class_310 client, String key, T initialValue, List<T> options, Function<T, class_2561> textProvider, Consumer<T> valueConsumer, Runnable onDirty, boolean activeCycle) {
        this.client = client;
        this.key = key;
        this.label = class_2561.method_43471((String)("bplb.config." + key));
        this.value = initialValue;
        this.options = options;
        this.textProvider = textProvider;
        this.valueConsumer = valueConsumer;
        this.onDirty = onDirty;
        this.activeCycle = activeCycle;
        this.button = ButtonWidget.builder(textProvider.apply(this.value), button -> {}).dimensions(0, 0, 100, 20).build();
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.button.field_22763 = this.activeCycle || this.options != null && !this.options.isEmpty();
        this.button.method_46421(x + entryWidth - 100 - 10);
        this.button.method_46419(y + 2);
        class_437 class_4372 = this.client.field_1755;
        if (class_4372 instanceof ConfigScreen) {
            ConfigScreen screen = (ConfigScreen)class_4372;
            String key = this.key.replace("player.", "").replaceAll("\\..*", "");
            screen.drawLabelWithHighlight(context, this.label, x + 10, y + 6, key);
        } else {
            context.method_27535(this.client.field_1772, this.label, x + 10, y + 6, 0xFAFAFA);
        }
        this.button.method_25394(context, mouseX, mouseY, tickDelta);
    }

    private int calculateNextIndex(int currentIndex, int buttonId) {
        if (currentIndex == -1 && this.key.equals("dot_type") && this.value.equals("bowtie")) {
            return 0;
        }
        if (buttonId == 0) {
            return (currentIndex + 1) % this.options.size();
        }
        if (buttonId == 1) {
            return (currentIndex - 1 + this.options.size()) % this.options.size();
        }
        return -1;
    }

    public boolean method_25402(double mouseX, double mouseY, int buttonId) {
        if (this.button.method_25405(mouseX, mouseY) && this.button.field_22763) {
            this.button.method_25354(class_310.method_1551().method_1483());
            if (this.key.equals("dot_type") && buttonId == 0 && class_437.method_25442()) {
                String bowtieValue = "bowtie";
                this.value = bowtieValue;
                this.button.method_25355(this.textProvider.apply(this.value));
                this.valueConsumer.accept(this.value);
                this.onDirty.run();
                return true;
            }
            if (this.options == null || this.options.isEmpty()) {
                return false;
            }
            int nextIndex = this.calculateNextIndex(this.options.indexOf(this.value), buttonId);
            if (nextIndex != -1) {
                this.value = this.options.get(nextIndex);
                this.button.method_25355(this.textProvider.apply(this.value));
                this.valueConsumer.accept(this.value);
                this.onDirty.run();
                return true;
            }
        }
        return false;
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return List.of(this.button);
    }

    @Override
    public List<? extends class_364> method_25396() {
        return List.of(this.button);
    }
}

