/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.config.entries;

import java.util.function.Consumer;
import net.bichal.bplb.config.entries.AbstractSliderOptionEntry;
import net.bichal.bplb.config.widget.SliderWidget;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class IntegerSliderOptionEntry
extends AbstractSliderOptionEntry {
    public IntegerSliderOptionEntry(class_310 client, String key, int initialValue, int min, int max, Consumer<Integer> valueConsumer, Runnable onDirty) {
        super(client, key, IntegerSliderOptionEntry.createSlider(initialValue, min, max, valueConsumer, onDirty));
    }

    private static SliderWidget createSlider(int initialValue, final int min, final int max, final Consumer<Integer> valueConsumer, final Runnable onDirty) {
        final boolean useSteps = max - min <= 80;
        return new SliderWidget(0, 0, 80, 20, (class_2561)class_2561.method_43473(), class_3532.method_15363((float)((float)(initialValue - min) / (float)(max - min)), (float)0.0f, (float)1.0f)){

            @Override
            public void updateMessage() {
                int value = min + (int)Math.round(this.value * (double)(max - min));
                this.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(value)));
            }

            @Override
            protected void applyValue() {
                if (useSteps) {
                    int steps = max - min;
                    int step = Math.round((float)(this.value * (double)steps));
                    this.value = (float)step / (float)steps;
                }
                int value = min + (int)Math.round(this.value * (double)(max - min));
                valueConsumer.accept(value);
                onDirty.run();
            }

            @Override
            protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
                super.method_25349(mouseX, mouseY, deltaX, deltaY);
                if (useSteps) {
                    int steps = max - min;
                    int step = Math.round((float)(this.value * (double)steps));
                    this.value = (float)step / (float)steps;
                }
                this.updateMessage();
            }
        };
    }
}

