/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.network;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record PositionUpdatePayload(List<PlayerInfo> newPlayers, List<PositionData> positions, List<UUID> disconnectedPlayers) implements class_8710
{
    public static final class_8710.class_9154<PositionUpdatePayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"bplb", (String)"position_update"));
    public static final class_9139<class_2540, PositionUpdatePayload> CODEC = class_9139.method_56438(PositionUpdatePayload::write, PositionUpdatePayload::read);
    private static final byte PRECISION_ULTRA = 0;
    private static final byte PRECISION_HIGH = 1;
    private static final byte PRECISION_MEDIUM = 2;

    public static PositionUpdatePayload read(class_2540 buf) {
        int newPlayersSize = buf.method_10816();
        ArrayList<PlayerInfo> newPlayers = new ArrayList<PlayerInfo>(newPlayersSize);
        for (int i = 0; i < newPlayersSize; ++i) {
            newPlayers.add(new PlayerInfo(buf.method_10790(), buf.method_10800(16)));
        }
        int positionsSize = buf.method_10816();
        ArrayList<PositionData> positions = new ArrayList<PositionData>(positionsSize);
        for (int i = 0; i < positionsSize; ++i) {
            double y;
            double x;
            byte precision = buf.readByte();
            UUID uuid = buf.method_10790();
            positions.add(new PositionData(uuid, x, y, switch (precision) {
                case 0 -> {
                    x = (double)buf.readInt() / 100.0;
                    y = (double)buf.readInt() / 100.0;
                    yield (double)buf.readInt() / 100.0;
                }
                case 1 -> {
                    x = (double)buf.readInt() / 10.0;
                    y = (double)buf.readInt() / 10.0;
                    yield (double)buf.readInt() / 10.0;
                }
                default -> {
                    x = buf.readInt();
                    y = buf.readInt();
                    yield buf.readInt();
                }
            }, 0.0));
        }
        int disconnectedSize = buf.method_10816();
        ArrayList<UUID> disconnected = new ArrayList<UUID>(disconnectedSize);
        for (int i = 0; i < disconnectedSize; ++i) {
            disconnected.add(buf.method_10790());
        }
        return new PositionUpdatePayload(newPlayers, positions, disconnected);
    }

    private static byte determinePrecision(double distance) {
        if (distance <= 32.0) {
            return 0;
        }
        if (distance < 64.0) {
            return 1;
        }
        return 2;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.newPlayers.size());
        for (PlayerInfo player : this.newPlayers) {
            buf.method_10797(player.uuid());
            buf.method_10788(player.name(), 16);
        }
        buf.method_10804(this.positions.size());
        block5: for (PositionData pos : this.positions) {
            byte precision = PositionUpdatePayload.determinePrecision(pos.distance());
            buf.method_52997((int)precision);
            buf.method_10797(pos.uuid());
            switch (precision) {
                case 0: {
                    buf.method_53002((int)(pos.x() * 100.0));
                    buf.method_53002((int)(pos.y() * 100.0));
                    buf.method_53002((int)(pos.z() * 100.0));
                    continue block5;
                }
                case 1: {
                    buf.method_53002((int)(pos.x() * 10.0));
                    buf.method_53002((int)(pos.y() * 10.0));
                    buf.method_53002((int)(pos.z() * 10.0));
                    continue block5;
                }
            }
            buf.method_53002((int)pos.x());
            buf.method_53002((int)pos.y());
            buf.method_53002((int)pos.z());
        }
        buf.method_10804(this.disconnectedPlayers.size());
        for (UUID uuid : this.disconnectedPlayers) {
            buf.method_10797(uuid);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public record PlayerInfo(UUID uuid, String name) {
    }

    public record PositionData(UUID uuid, double x, double y, double z, double distance) {
    }
}

