/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.server;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.bichal.bplb.server.ServerConfig;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PlayerTracker {
    private final Map<UUID, PlayerInfo> playerInfoCache = new ConcurrentHashMap<UUID, PlayerInfo>();
    private final Map<UUID, PlayerPosition> currentPositions = new ConcurrentHashMap<UUID, PlayerPosition>();
    private final Map<UUID, PlayerPosition> movedPlayers = new ConcurrentHashMap<UUID, PlayerPosition>();
    private final double positionThresholdSq;

    public PlayerTracker() {
        ServerConfig config = ServerConfig.getInstance();
        this.positionThresholdSq = Math.pow(config.positionChangeThreshold(), 2.0);
    }

    public void updatePlayer(class_3222 player) {
        PlayerPosition oldPos;
        if (player == null) {
            return;
        }
        UUID uuid = player.method_5667();
        PlayerPosition newPos = new PlayerPosition(player.method_23317(), player.method_23318(), player.method_23321());
        if (newPos.hasSignificantChange(oldPos = this.currentPositions.put(uuid, newPos), this.positionThresholdSq)) {
            this.movedPlayers.put(uuid, newPos);
        }
        this.playerInfoCache.computeIfAbsent(uuid, k -> new PlayerInfo((UUID)k, player.method_5477().getString()));
    }

    public void removePlayer(@Nullable UUID uuid) {
        if (uuid == null) {
            return;
        }
        this.playerInfoCache.remove(uuid);
        this.currentPositions.remove(uuid);
        this.movedPlayers.remove(uuid);
    }

    public Map<UUID, PlayerPosition> getAndClearMovedPlayers() {
        if (this.movedPlayers.isEmpty()) {
            return Map.of();
        }
        ConcurrentHashMap<UUID, PlayerPosition> moved = new ConcurrentHashMap<UUID, PlayerPosition>(this.movedPlayers);
        this.movedPlayers.clear();
        return moved;
    }

    @Nullable
    public PlayerInfo getPlayerInfo(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return this.playerInfoCache.get(uuid);
    }

    public void cleanup() {
        long cutoff = System.currentTimeMillis() - (long)ServerConfig.getInstance().cleanupIntervalTicks() * 50L;
        this.currentPositions.entrySet().removeIf(entry -> entry.getValue() == null || ((PlayerPosition)entry.getValue()).timestamp < cutoff);
        this.playerInfoCache.entrySet().removeIf(entry -> entry.getValue() == null || ((PlayerInfo)entry.getValue()).firstSeen < cutoff);
        this.movedPlayers.entrySet().removeIf(entry -> entry.getValue() == null || ((PlayerPosition)entry.getValue()).timestamp < cutoff);
    }

    public static class PlayerPosition {
        public final double x;
        public final double y;
        public final double z;
        public final long timestamp;

        public PlayerPosition(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean hasSignificantChange(@Nullable PlayerPosition other, double thresholdSq) {
            if (other == null) {
                return true;
            }
            double dx = this.x - other.x;
            double dy = this.y - other.y;
            double dz = this.z - other.z;
            return dx * dx + dy * dy + dz * dz > thresholdSq;
        }
    }

    public static class PlayerInfo {
        public final UUID uuid;
        public final String name;
        public final long firstSeen;

        public PlayerInfo(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name != null ? name : "Unknown";
            this.firstSeen = System.currentTimeMillis();
        }
    }
}

