/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.bichal.bplb.network.HandshakePayload;
import net.bichal.bplb.network.PositionUpdatePayload;
import net.bichal.bplb.server.PlayerTracker;
import net.bichal.bplb.server.ServerConfig;
import net.bichal.bplb.util.Constants;
import net.bichal.bplb.util.DistanceUtils;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class Server
implements DedicatedServerModInitializer {
    private final PlayerTracker playerTracker = new PlayerTracker();
    private static final long PLAYER_LIST_CACHE_DURATION = 50L;
    private final Set<UUID> newPlayers = ConcurrentHashMap.newKeySet(16);
    private final Set<UUID> disconnectedPlayers = ConcurrentHashMap.newKeySet(16);
    private final Map<UUID, Map<UUID, Double>> distanceCache = new ConcurrentHashMap<UUID, Map<UUID, Double>>(32);
    private final Map<UUID, CachedPlayerData> playerDataCache = new ConcurrentHashMap<UUID, CachedPlayerData>(64);
    private long lastUpdateTime = 0L;
    private final ExecutorService executor = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2), r -> {
        Thread t = new Thread(r, "BPLB-Worker");
        t.setDaemon(true);
        return t;
    });
    private List<class_3222> playerListCache = new ArrayList<class_3222>();
    private long playerListCacheTime = 0L;

    public void onInitializeServer() {
        Constants.LOGGER.info("[{}] Initializing server!", (Object)"BPLB");
        ServerConfig.getInstance();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (handler == null || handler.field_14140 == null) {
                return;
            }
            UUID playerId = handler.field_14140.method_5667();
            if (playerId == null) {
                return;
            }
            this.playerTracker.updatePlayer(handler.field_14140);
            this.newPlayers.add(playerId);
            this.invalidatePlayerListCache();
            if (ServerPlayNetworking.canSend((class_3222)handler.field_14140, HandshakePayload.ID)) {
                boolean hasOp = server.method_3760().method_14569(handler.field_14140.method_7334());
                ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new HandshakePayload(hasOp));
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (handler == null || handler.field_14140 == null) {
                return;
            }
            UUID playerId = handler.field_14140.method_5667();
            if (playerId == null) {
                return;
            }
            this.disconnectedPlayers.add(playerId);
            this.playerTracker.removePlayer(playerId);
            this.newPlayers.remove(playerId);
            this.distanceCache.remove(playerId);
            this.invalidatePlayerListCache();
        });
        ServerTickEvents.END_SERVER_TICK.register(this::tick);
        Constants.LOGGER.info("[{}] Server initialized!", (Object)"BPLB");
    }

    private void tick(@Nullable MinecraftServer server) {
        if (server == null) {
            return;
        }
        long currentTime = server.method_3780();
        List<class_3222> players = this.getCachedPlayerList(server);
        if (players.size() > 10) {
            ArrayList futures = new ArrayList();
            int chunkSize = Math.max(5, players.size() / 4);
            for (int start = 0; start < players.size(); start += chunkSize) {
                int end = Math.min(start + chunkSize, players.size());
                List<class_3222> chunk = players.subList(start, end);
                futures.add(CompletableFuture.runAsync(() -> {
                    for (class_3222 player : chunk) {
                        if (player == null) continue;
                        this.playerTracker.updatePlayer(player);
                    }
                }, this.executor));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        } else {
            for (class_3222 player : players) {
                if (player == null) continue;
                this.playerTracker.updatePlayer(player);
            }
        }
        ServerConfig config = ServerConfig.getInstance();
        if (currentTime - this.lastUpdateTime >= (long)config.positionUpdateRateTicks()) {
            this.sendUpdate(server);
            this.lastUpdateTime = currentTime;
        }
    }

    private List<class_3222> getCachedPlayerList(@Nullable MinecraftServer server) {
        if (server == null) {
            return Collections.emptyList();
        }
        long now = System.currentTimeMillis();
        if (now - this.playerListCacheTime > 50L) {
            this.playerListCache = server.method_3760().method_14571();
            this.playerListCacheTime = now;
        }
        return this.playerListCache;
    }

    private void invalidatePlayerListCache() {
        this.playerListCacheTime = 0L;
    }

    private void sendUpdate(MinecraftServer server) {
        if (server == null) {
            return;
        }
        List<class_3222> players = this.getCachedPlayerList(server);
        if (players.isEmpty()) {
            return;
        }
        ArrayList<PositionUpdatePayload.PlayerInfo> newPlayerInfos = new ArrayList<PositionUpdatePayload.PlayerInfo>();
        HashMap initialPositions = new HashMap();
        this.newPlayers.removeIf(uuid -> {
            if (uuid == null) {
                return true;
            }
            PlayerTracker.PlayerInfo info = this.playerTracker.getPlayerInfo((UUID)uuid);
            if (info != null) {
                newPlayerInfos.add(new PositionUpdatePayload.PlayerInfo((UUID)uuid, info.name));
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player != null) {
                    PlayerTracker.PlayerPosition pos = new PlayerTracker.PlayerPosition(player.method_23317(), player.method_23318(), player.method_23321());
                    initialPositions.put(uuid, pos);
                }
                return true;
            }
            return false;
        });
        HashMap<UUID, PlayerTracker.PlayerPosition> movedPlayersData = new HashMap<UUID, PlayerTracker.PlayerPosition>(this.playerTracker.getAndClearMovedPlayers());
        movedPlayersData.putAll(initialPositions);
        for (class_3222 player : players) {
            if (player == null || movedPlayersData.containsKey(player.method_5667())) continue;
            PlayerTracker.PlayerPosition pos = new PlayerTracker.PlayerPosition(player.method_23317(), player.method_23318(), player.method_23321());
            movedPlayersData.put(player.method_5667(), pos);
        }
        if (movedPlayersData.isEmpty() && newPlayerInfos.isEmpty() && this.disconnectedPlayers.isEmpty()) {
            return;
        }
        for (class_3222 viewer : players) {
            UUID viewerId;
            if (viewer == null || (viewerId = viewer.method_5667()) == null) continue;
            ArrayList<PositionUpdatePayload.PositionData> positions = new ArrayList<PositionUpdatePayload.PositionData>();
            Map viewerDistCache = this.distanceCache.computeIfAbsent(viewerId, k -> new ConcurrentHashMap());
            double vx = viewer.method_23317();
            double vy = viewer.method_23318();
            double vz = viewer.method_23321();
            long now = System.currentTimeMillis();
            for (Map.Entry entry : movedPlayersData.entrySet()) {
                UUID uuid2 = (UUID)entry.getKey();
                PlayerTracker.PlayerPosition pos = (PlayerTracker.PlayerPosition)entry.getValue();
                if (uuid2 == null || pos == null || uuid2.equals(viewerId)) continue;
                CachedPlayerData cached = this.playerDataCache.get(uuid2);
                if (cached != null && cached.isValid(now)) {
                    if (cached.shouldHide) continue;
                    double distance = DistanceUtils.calculateDistance(vx, vy, vz, cached.x, cached.y, cached.z);
                    if (distance > ServerConfig.getInstance().maxRelevantDistance()) {
                        viewerDistCache.remove(uuid2);
                        continue;
                    }
                    viewerDistCache.put(uuid2, distance);
                    positions.add(new PositionUpdatePayload.PositionData(uuid2, pos.x, pos.y, pos.z, distance));
                    continue;
                }
                class_3222 targetPlayer = server.method_3760().method_14602(uuid2);
                if (targetPlayer == null || viewer.method_37908() != targetPlayer.method_37908()) continue;
                boolean shouldHide = this.shouldHideTarget(targetPlayer);
                String playerName = targetPlayer.method_5477().getString();
                this.playerDataCache.put(uuid2, new CachedPlayerData(pos.x, pos.y, pos.z, shouldHide, playerName));
                if (shouldHide || targetPlayer.method_7325()) continue;
                double distance = DistanceUtils.calculateDistance(vx, vy, vz, pos.x, pos.y, pos.z);
                if (distance > ServerConfig.getInstance().maxRelevantDistance()) {
                    viewerDistCache.remove(uuid2);
                    continue;
                }
                viewerDistCache.put(uuid2, distance);
                this.playerTracker.updatePlayer(targetPlayer);
                positions.add(new PositionUpdatePayload.PositionData(uuid2, pos.x, pos.y, pos.z, distance));
            }
            if (newPlayerInfos.isEmpty() && positions.isEmpty() && this.disconnectedPlayers.isEmpty()) continue;
            PositionUpdatePayload payload = new PositionUpdatePayload(newPlayerInfos, positions, new ArrayList<UUID>(this.disconnectedPlayers));
            if (!ServerPlayNetworking.canSend((class_3222)viewer, PositionUpdatePayload.ID)) continue;
            ServerPlayNetworking.send((class_3222)viewer, (class_8710)payload);
        }
        this.disconnectedPlayers.clear();
    }

    private boolean shouldHideTarget(class_3222 target) {
        class_1799 headStack = target.method_6118(class_1304.field_6169);
        return target.method_5715() || target.method_5767() || !headStack.method_7960() && !(headStack.method_7909() instanceof class_1738);
    }

    private static class CachedPlayerData {
        final double x;
        final double y;
        final double z;
        final boolean shouldHide;
        final String playerName;
        final long timestamp;

        CachedPlayerData(double x, double y, double z, boolean shouldHide, String playerName) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.shouldHide = shouldHide;
            this.playerName = playerName;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isValid(long now) {
            return now - this.timestamp < 50L;
        }
    }
}

