/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.bichal.bplb.client.render.RenderAddons;
import net.bichal.bplb.util.Constants;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("BetterPlayerLocatorBar/options.json").toFile();
    private static final File PLAYERS_FILE = FabricLoader.getInstance().getConfigDir().resolve("BetterPlayerLocatorBar/players.json").toFile();
    private final Map<String, PlayerAppearance> playerConfigs = new HashMap<String, PlayerAppearance>();
    private static Config instance;
    private final Map<String, Boolean> playerExpandedStates = new HashMap<String, Boolean>();
    private float lerpSpeed = 0.65f;
    private boolean applyHotbarOffset = true;
    private boolean alwaysShowPlayerHeads = false;
    private boolean alwaysShowPlayerNames = false;
    private int fadeStartDistance = 512;
    private int fadeEndDistance = 4096;
    private float fadeAlphaMax = 1.0f;
    private float fadeAlphaMin = 0.25f;
    private String nameBorderStyle = "rounded";
    private String iconBorderStyle = "rounded";
    private String iconBorderType = "default";
    private boolean inheritBorderColor = true;
    private int iconSize = 4;
    private String dotType = "default";
    private String arrowType = "default";
    private String deathMarkerType = "default";
    private int deathMarkerColor = 0xFF4C4C;
    private String heightDifferenceMode = "PLAYER";
    private boolean modEnabled = true;
    private int maxVisibleIcons = 100;
    private float nameplateScale = 1.0f;
    private String deathMarkerBorderStyle = "rounded";
    private String deathMarkerBorderType = "default";
    private boolean deathMarkerInheritBorderColor = true;
    private int verticalPadding = 0;
    private boolean adjustToFov = false;
    private float fovMultiplier = 1.0f;

    public static void copy(Config source, Config target) {
        target.fadeEndDistance = source.fadeEndDistance;
        target.fadeStartDistance = source.fadeStartDistance;
        target.lerpSpeed = source.lerpSpeed;
        target.applyHotbarOffset = source.applyHotbarOffset;
        target.alwaysShowPlayerHeads = source.alwaysShowPlayerHeads;
        target.alwaysShowPlayerNames = source.alwaysShowPlayerNames;
        target.fadeAlphaMax = source.fadeAlphaMax;
        target.fadeAlphaMin = source.fadeAlphaMin;
        target.iconSize = source.iconSize;
        target.nameBorderStyle = source.nameBorderStyle;
        target.iconBorderStyle = source.iconBorderStyle;
        target.iconBorderType = source.iconBorderType;
        target.inheritBorderColor = source.inheritBorderColor;
        target.maxVisibleIcons = source.maxVisibleIcons;
        target.dotType = source.dotType;
        target.arrowType = source.arrowType;
        target.deathMarkerType = source.deathMarkerType;
        target.deathMarkerColor = source.deathMarkerColor;
        target.heightDifferenceMode = source.heightDifferenceMode;
        target.modEnabled = source.modEnabled;
        target.verticalPadding = source.verticalPadding;
        target.nameplateScale = source.nameplateScale;
        target.deathMarkerBorderStyle = source.deathMarkerBorderStyle;
        target.deathMarkerBorderType = source.deathMarkerBorderType;
        target.deathMarkerInheritBorderColor = source.deathMarkerInheritBorderColor;
        target.adjustToFov = source.adjustToFov;
        target.fovMultiplier = source.fovMultiplier;
        target.playerConfigs.clear();
        target.playerConfigs.putAll(source.playerConfigs);
        target.playerExpandedStates.clear();
        target.playerExpandedStates.putAll(source.playerExpandedStates);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Config loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Config loaded = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loaded != null) {
                    loaded.validate();
                    Config.loadPlayers(loaded);
                    loaded.save();
                    Constants.LOGGER.info("[{}] Config loaded successfully", (Object)"BPLB");
                    Config config = loaded;
                    return config;
                }
            }
            catch (IOException e) {
                Constants.LOGGER.error("Error loading config file", (Throwable)e);
            }
            catch (JsonParseException e) {
                Constants.LOGGER.error("Config file is corrupted, creating backup and resetting to defaults", (Throwable)e);
                Config.backupAndDelete();
            }
            catch (Exception e) {
                Constants.LOGGER.error("Unexpected error loading config, resetting to defaults", (Throwable)e);
                Config.backupAndDelete();
            }
        }
        Config newConfig = new Config();
        newConfig.save();
        Constants.LOGGER.info("[{}] Created new config with defaults", (Object)"BPLB");
        return newConfig;
    }

    private static void backupAndDelete() {
        try {
            File backup = new File(CONFIG_FILE.getParent(), "options.json.backup." + System.currentTimeMillis());
            Files.copy(CONFIG_FILE.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!CONFIG_FILE.delete()) {
                Constants.LOGGER.warn("Failed to delete corrupted config file");
            }
            Constants.LOGGER.info("Backup saved to: {}", (Object)backup.getAbsolutePath());
        }
        catch (IOException ex) {
            Constants.LOGGER.error("Failed to backup corrupted config", (Throwable)ex);
        }
    }

    private void validate() {
        ArrayList<String> correctedFields = new ArrayList<String>();
        correctedFields.addAll(this.validateFloat("lerpSpeed", v -> {
            this.lerpSpeed = v.floatValue();
        }, this.lerpSpeed, 0.1f, 1.0f, 0.65f));
        correctedFields.addAll(this.validateInt("fadeStartDistance", v -> {
            this.fadeStartDistance = v;
        }, this.fadeStartDistance, 5, 9995, 512));
        correctedFields.addAll(this.validateInt("fadeEndDistance", v -> {
            this.fadeEndDistance = v;
        }, this.fadeEndDistance, 10, 10000, 4096));
        correctedFields.addAll(this.validateFloat("fadeAlphaMax", v -> {
            this.fadeAlphaMax = v.floatValue();
        }, this.fadeAlphaMax, 0.01f, 1.0f, 1.0f));
        correctedFields.addAll(this.validateFloat("fadeAlphaMin", v -> {
            this.fadeAlphaMin = v.floatValue();
        }, this.fadeAlphaMin, 0.0f, 1.0f, 0.25f));
        correctedFields.addAll(this.validateInt("iconSize", v -> {
            this.iconSize = v;
        }, this.iconSize, 1, 4, 4));
        correctedFields.addAll(this.validateInt("maxVisibleIcons", v -> {
            this.maxVisibleIcons = v;
        }, this.maxVisibleIcons, 1, 200, 100));
        correctedFields.addAll(this.validateFloat("nameplateScale", v -> {
            this.nameplateScale = v.floatValue();
        }, this.nameplateScale, 0.5f, 1.5f, 1.0f));
        correctedFields.addAll(this.validateInt("verticalPadding", v -> {
            this.verticalPadding = v;
        }, this.verticalPadding, 0, 10, 2));
        correctedFields.addAll(this.validateFloat("fovMultiplier", v -> {
            this.fovMultiplier = v.floatValue();
        }, this.fovMultiplier, 0.5f, 2.0f, 1.0f));
        if (this.fadeStartDistance >= this.fadeEndDistance) {
            this.fadeStartDistance = 512;
            this.fadeEndDistance = 4096;
            correctedFields.add("fadeStartDistance/fadeEndDistance (range)");
        }
        if (this.fadeAlphaMin >= this.fadeAlphaMax) {
            this.fadeAlphaMin = 0.25f;
            this.fadeAlphaMax = 1.0f;
            correctedFields.add("fadeAlphaMin/fadeAlphaMax (range)");
        }
        correctedFields.addAll(this.validateString("nameBorderStyle", v -> {
            this.nameBorderStyle = v;
        }, this.nameBorderStyle, List.of("rounded", "squared"), "rounded"));
        correctedFields.addAll(this.validateString("iconBorderStyle", v -> {
            this.iconBorderStyle = v;
        }, this.iconBorderStyle, List.of("rounded", "squared"), "rounded"));
        correctedFields.addAll(this.validateString("iconBorderType", v -> {
            this.iconBorderType = v;
        }, this.iconBorderType, List.of("default", "minimal"), "default"));
        correctedFields.addAll(this.validateString("deathMarkerBorderStyle", v -> {
            this.deathMarkerBorderStyle = v;
        }, this.deathMarkerBorderStyle, List.of("rounded", "squared"), "rounded"));
        correctedFields.addAll(this.validateString("deathMarkerBorderType", v -> {
            this.deathMarkerBorderType = v;
        }, this.deathMarkerBorderType, List.of("default", "minimal"), "default"));
        correctedFields.addAll(this.validateString("heightDifferenceMode", v -> {
            this.heightDifferenceMode = v;
        }, this.heightDifferenceMode != null ? this.heightDifferenceMode.toLowerCase() : null, List.of("player", "camera"), "player"));
        correctedFields.addAll(this.validateNotEmpty("dotType", v -> {
            this.dotType = v;
        }, this.dotType));
        correctedFields.addAll(this.validateNotEmpty("arrowType", v -> {
            this.arrowType = v;
        }, this.arrowType));
        correctedFields.addAll(this.validateNotEmpty("deathMarkerType", v -> {
            this.deathMarkerType = v;
        }, this.deathMarkerType));
        boolean removed = this.playerConfigs.entrySet().removeIf(entry -> entry.getKey() == null || ((String)entry.getKey()).isEmpty() || entry.getValue() == null);
        if (removed) {
            correctedFields.add("playerConfigs (removed invalid entries)");
        }
        if (!correctedFields.isEmpty()) {
            Constants.LOGGER.warn("Corrected invalid config fields: {}", (Object)String.join((CharSequence)", ", correctedFields));
        }
    }

    private List<String> validateFloat(String name, Consumer<Float> setter, float value, float min, float max, float defaultValue) {
        if (value < min || value > max || Float.isNaN(value) || Float.isInfinite(value)) {
            setter.accept(Float.valueOf(defaultValue));
            return List.of(name);
        }
        return List.of();
    }

    private List<String> validateInt(String name, Consumer<Integer> setter, int value, int min, int max, int defaultValue) {
        if (value < min || value > max) {
            setter.accept(defaultValue);
            return List.of(name);
        }
        return List.of();
    }

    private List<String> validateString(String name, Consumer<String> setter, String value, List<String> validValues, String defaultValue) {
        if (value == null || !validValues.contains(value)) {
            setter.accept(defaultValue);
            return List.of(name);
        }
        return List.of();
    }

    private List<String> validateNotEmpty(String name, Consumer<String> setter, String value) {
        if (value == null || value.isEmpty()) {
            setter.accept("default");
            return List.of(name);
        }
        return List.of();
    }

    private static void loadPlayers(Config config) {
        if (!PLAYERS_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(PLAYERS_FILE);){
            Type type = new TypeToken<Map<String, PlayerAppearance>>(){}.getType();
            Map loaded = (Map)GSON.fromJson((Reader)reader, type);
            if (loaded != null) {
                config.playerConfigs.putAll(loaded);
            }
        }
        catch (IOException e) {
            Constants.LOGGER.error("Error loading players config", (Throwable)e);
        }
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = Config.loadConfig();
        }
        return instance;
    }

    private static UUID getUuidFromCache(String name) {
        return RenderAddons.getUuidFromCache(name);
    }

    public void setPlayerExpanded(String playerName, boolean expanded) {
        this.playerExpandedStates.put(playerName, expanded);
        this.save();
    }

    public boolean isPlayerExpanded(String playerName) {
        return this.playerExpandedStates.getOrDefault(playerName, false);
    }

    public void resetToDefaults() {
        Config.copy(new Config(), this);
    }

    private <T> void set(T value, Consumer<T> setter) {
        setter.accept(value);
        this.save();
    }

    public Map<String, PlayerAppearance> getPlayerConfigs() {
        return this.playerConfigs;
    }

    public void save() {
        try {
            File parentDir = CONFIG_FILE.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                Constants.LOGGER.error("Failed to create config directory");
                return;
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
            this.savePlayers();
        }
        catch (IOException e) {
            Constants.LOGGER.error("Error saving config file", (Throwable)e);
        }
    }

    private void savePlayers() {
        try {
            File parent = PLAYERS_FILE.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                Constants.LOGGER.error("Failed to create players config directory");
                return;
            }
            HashMap<String, PlayerAppearance> toSave = new HashMap<String, PlayerAppearance>();
            for (Map.Entry<String, PlayerAppearance> entry : this.playerConfigs.entrySet()) {
                UUID uuid = Config.getUuidFromCache(entry.getKey());
                if (uuid == null) continue;
                PlayerAppearance pa = entry.getValue();
                pa.playerUuid = uuid;
                pa.playerName = entry.getKey();
                toSave.put(entry.getKey(), pa);
            }
            try (FileWriter writer = new FileWriter(PLAYERS_FILE);){
                GSON.toJson(toSave, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Constants.LOGGER.error("Error saving players config", (Throwable)e);
        }
    }

    @Nullable
    public PlayerAppearance getPlayerConfig(String playerName) {
        return this.playerConfigs.get(playerName);
    }

    public void setMaxVisibleIcons(int value) {
        this.set(class_3532.method_15340((int)value, (int)1, (int)200), v -> {
            this.maxVisibleIcons = v;
        });
    }

    public int getFadeEndDistance() {
        return this.fadeEndDistance;
    }

    public void setFadeEndDistance(int value) {
        this.set(value, v -> {
            this.fadeEndDistance = v;
        });
    }

    public int getFadeStartDistance() {
        return this.fadeStartDistance;
    }

    public void setFadeStartDistance(int value) {
        this.set(value, v -> {
            this.fadeStartDistance = v;
        });
    }

    public float getLerpSpeed() {
        return this.lerpSpeed;
    }

    public void setLerpSpeed(float value) {
        this.set(Float.valueOf(value), v -> {
            this.lerpSpeed = v.floatValue();
        });
    }

    public boolean isApplyHotbarOffset() {
        return this.applyHotbarOffset;
    }

    public void setApplyHotbarOffset(boolean value) {
        this.set(value, v -> {
            this.applyHotbarOffset = v;
        });
    }

    public boolean isAlwaysShowPlayerHeads() {
        return this.alwaysShowPlayerHeads;
    }

    public void setAlwaysShowPlayerHeads(boolean value) {
        this.set(value, v -> {
            this.alwaysShowPlayerHeads = v;
        });
    }

    public boolean isAlwaysShowPlayerNames() {
        return this.alwaysShowPlayerNames;
    }

    public void setAlwaysShowPlayerNames(boolean value) {
        this.set(value, v -> {
            this.alwaysShowPlayerNames = v;
        });
    }

    public float getFadeAlphaMax() {
        return this.fadeAlphaMax;
    }

    public void setFadeAlphaMax(float value) {
        float clampedValue = class_3532.method_15363((float)value, (float)(this.fadeAlphaMin + 0.01f), (float)1.0f);
        this.set(Float.valueOf(clampedValue), v -> {
            this.fadeAlphaMax = v.floatValue();
        });
    }

    public float getFadeAlphaMin() {
        return this.fadeAlphaMin;
    }

    public void setFadeAlphaMin(float value) {
        float clampedValue = class_3532.method_15363((float)value, (float)0.0f, (float)(this.fadeAlphaMax - 0.01f));
        this.set(Float.valueOf(clampedValue), v -> {
            this.fadeAlphaMin = v.floatValue();
        });
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int value) {
        this.set(value, v -> {
            this.iconSize = v;
        });
    }

    public String getNameBorderStyle() {
        return this.nameBorderStyle;
    }

    public void setNameBorderStyle(String value) {
        this.set(value, v -> {
            this.nameBorderStyle = v;
        });
    }

    public String getIconBorderStyle() {
        return this.iconBorderStyle;
    }

    public void setIconBorderStyle(String value) {
        this.set(value, v -> {
            this.iconBorderStyle = v;
        });
    }

    public String getIconBorderType() {
        return this.iconBorderType;
    }

    public void setIconBorderType(String value) {
        this.set(value, v -> {
            this.iconBorderType = v;
        });
    }

    public boolean isInheritBorderColor() {
        return this.inheritBorderColor;
    }

    public void setInheritBorderColor(boolean value) {
        this.set(value, v -> {
            this.inheritBorderColor = v;
        });
    }

    public int getMaxVisibleIcons() {
        return this.maxVisibleIcons;
    }

    public void setDeathMarkerColor(int value) {
        this.set(value, v -> {
            this.deathMarkerColor = v;
        });
    }

    public String getDotType() {
        return this.dotType;
    }

    public void setDotType(String value) {
        this.set(value, v -> {
            this.dotType = v;
        });
    }

    public String getArrowType() {
        return this.arrowType;
    }

    public void setArrowType(String value) {
        this.set(value, v -> {
            this.arrowType = v;
        });
    }

    public String getDeathMarkerType() {
        return this.deathMarkerType;
    }

    public void setDeathMarkerType(String value) {
        this.set(value, v -> {
            this.deathMarkerType = v;
        });
    }

    public int getDeathMarkerColor() {
        return this.deathMarkerColor;
    }

    public void setDeathMarkerBorderStyle(String value) {
        this.set(value, v -> {
            this.deathMarkerBorderStyle = v;
        });
    }

    public String getHeightDifferenceMode() {
        return this.heightDifferenceMode;
    }

    public void setHeightDifferenceMode(String value) {
        this.set(value, v -> {
            this.heightDifferenceMode = v;
        });
    }

    public boolean isModEnabled() {
        return this.modEnabled;
    }

    public void setModEnabled(boolean value) {
        this.set(value, v -> {
            this.modEnabled = v;
        });
    }

    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public void setVerticalPadding(int value) {
        this.set(value, v -> {
            this.verticalPadding = v;
        });
    }

    public float getNameplateScale() {
        return this.nameplateScale;
    }

    public void setNameplateScale(float value) {
        this.set(Float.valueOf(value), v -> {
            this.nameplateScale = v.floatValue();
        });
    }

    public String getDeathMarkerBorderStyle() {
        return this.deathMarkerBorderStyle;
    }

    public boolean isAdjustToFov() {
        return this.adjustToFov;
    }

    public String getDeathMarkerBorderType() {
        return this.deathMarkerBorderType;
    }

    public void setDeathMarkerBorderType(String value) {
        this.set(value, v -> {
            this.deathMarkerBorderType = v;
        });
    }

    public boolean isDeathMarkerInheritBorderColor() {
        return this.deathMarkerInheritBorderColor;
    }

    public void setDeathMarkerInheritBorderColor(boolean value) {
        this.set(value, v -> {
            this.deathMarkerInheritBorderColor = v;
        });
    }

    public void setAdjustToFov(boolean value) {
        this.set(value, v -> {
            this.adjustToFov = v;
        });
    }

    public float getFovMultiplier() {
        return this.fovMultiplier;
    }

    public void setFovMultiplier(float value) {
        this.set(Float.valueOf(class_3532.method_15363((float)value, (float)0.5f, (float)2.0f)), v -> {
            this.fovMultiplier = v.floatValue();
        });
    }

    public static class PlayerAppearance {
        public String playerName;
        public UUID playerUuid;
        public String dotType;
        public String iconBorderStyle;
        public String iconBorderType;
        public String arrowType;
        public Integer color;
        public String textureHeadOverride;
    }
}

