/*
 * Decompiled with CFR 0.152.
 */
package net.bichal.bplb.config;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.bichal.bplb.client.Client;
import net.bichal.bplb.client.render.RenderAddons;
import net.bichal.bplb.client.render.RenderUtils;
import net.bichal.bplb.client.render.TextureAnimator;
import net.bichal.bplb.client.render.TextureManager;
import net.bichal.bplb.config.Config;
import net.bichal.bplb.config.entries.AddPlayerEntry;
import net.bichal.bplb.config.entries.ColorTextFieldEntry;
import net.bichal.bplb.config.entries.CycleOptionEntry;
import net.bichal.bplb.config.entries.FloatSliderOptionEntry;
import net.bichal.bplb.config.entries.IntegerSliderOptionEntry;
import net.bichal.bplb.config.entries.PlayerListEntry;
import net.bichal.bplb.config.entries.ResetSettingsEntry;
import net.bichal.bplb.config.entries.SectionHeaderEntry;
import net.bichal.bplb.config.entries.ToggleOptionEntry;
import net.bichal.bplb.config.widget.ButtonWidget;
import net.bichal.bplb.config.widget.ScrollableListWidget;
import net.bichal.bplb.config.widget.TextInputWidget;
import net.bichal.bplb.util.ColorUtils;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ConfigScreen
extends class_437 {
    private static final int PREVIEW_BASE_SIZE = 45;
    private static final int preview_close_size = 0;
    private static final int MAX_UI_WIDTH = 460;
    private final class_437 parent;
    private TextureAnimator previewArrowAnimator = null;
    private final Config workingConfig;
    private ScrollableListWidget scrollableList;
    private boolean hasChanges = false;
    private final Map<String, SearchMatch> searchMatches = new HashMap<String, SearchMatch>();
    private ButtonWidget applyButton;
    private ButtonWidget doneButton;
    private String searchQuery = "";

    public ConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"bplb.config.title"));
        this.parent = parent;
        this.workingConfig = new Config();
        Config.copy(Config.getInstance(), this.workingConfig);
    }

    protected void method_25426() {
        super.method_25426();
        int uiWidth = Math.min(this.field_22789 - 100 - 50, 460);
        int scrollListLeftOffset = 0;
        if (this.field_22789 < 460) {
            uiWidth = this.field_22789 - 50 - 45 - 22;
            scrollListLeftOffset = -10;
        }
        TextInputWidget searchField = new TextInputWidget(this.field_22793, this.field_22789 / 2 - 100, 30, 200, 20, (class_2561)class_2561.method_43471((String)"bplb.config.search"));
        searchField.method_1863(text -> {
            this.searchQuery = text.toLowerCase();
            this.rebuildListWithoutScroll();
        });
        this.method_37063((class_364)searchField);
        this.scrollableList = new ScrollableListWidget(this.field_22787, this.field_22789, 60, this.field_22790 - 35, 24);
        this.scrollableList.setRowWidth(uiWidth);
        this.scrollableList.setRowLeft(this.field_22789 / 2 - uiWidth / 2 + scrollListLeftOffset);
        this.scrollableList.setScrollbarX(this.field_22789 - 6);
        this.populateOptions();
        this.method_25429((class_364)this.scrollableList);
        this.method_37063((class_364)this.scrollableList);
        int startX = (int)((double)this.field_22789 / 2.0 - 150.0 - 7.5);
        int buttonY = this.field_22790 - 27;
        this.method_37063((class_364)ButtonWidget.builder((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.method_25419()).dimensions(startX, buttonY, 100, 20).build());
        this.applyButton = (ButtonWidget)this.method_37063((class_364)ButtonWidget.builder((class_2561)class_2561.method_43471((String)"screen.bplb.config.apply"), button -> this.applyChanges()).dimensions(startX + 100 + 5, buttonY, 100, 20).build());
        this.doneButton = (ButtonWidget)this.method_37063((class_364)ButtonWidget.builder(class_5244.field_24334, button -> {
            if (this.hasChanges) {
                this.applyChanges();
            }
            this.method_25419();
        }).dimensions(startX + 210, buttonY, 100, 20).build());
        this.updateButtons();
    }

    public void rebuildList() {
        if (this.field_22787 != null) {
            double scroll = this.scrollableList.method_25341();
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            this.scrollableList.method_25307(scroll);
        }
    }

    private void rebuildListWithoutScroll() {
        if (this.field_22787 == null) {
            return;
        }
        double scroll = this.scrollableList.method_25341();
        this.scrollableList.method_25339();
        this.populateOptions();
        this.scrollableList.method_25307(scroll);
    }

    public void method_25395(class_364 focused) {
        class_364 oldFocused = this.method_25399();
        super.method_25395(focused);
        if (oldFocused != focused && !(focused instanceof TextInputWidget)) {
            this.rebuildListWithoutScroll();
        }
    }

    private void addIntSlider(String key, int actualValue, int min, int max, Consumer<Integer> setter) {
        this.scrollableList.addPublicEntry(new IntegerSliderOptionEntry(this.field_22787, key, actualValue, min, max, setter, this::markDirty));
    }

    private void addSection(String key) {
        this.scrollableList.addPublicEntry(new SectionHeaderEntry(this.field_22787, (class_2561)class_2561.method_43471((String)("bplb.config.section." + key))));
    }

    private void addToggle(String key, boolean initialValue, Consumer<Boolean> setter) {
        this.scrollableList.addPublicEntry(new ToggleOptionEntry(this.field_22787, key, initialValue, setter, this::markDirty));
    }

    private void updateSearchMatches() {
        this.searchMatches.clear();
        this.scrollableList.method_25307(0.0);
        if (this.searchQuery.isEmpty()) {
            return;
        }
        List<String> allKeys = List.of("modEnabled", "apply_hotbar_offset", "always_show_player_heads", "always_show_player_names", "max_visible_icons", "position_update_rate_ticks", "lerp_speed", "icon_size", "dot_type", "icon_border_style", "icon_border_type", "inherit_border_color", "height_difference_mode", "arrow_type", "vertical_padding", "adjust_to_fov", "fov_multiplier", "death_marker_type", "death_marker_border_type", "death_marker_inherit_border_color", "nameplate_scale", "name_border_style", "fade_end_distance", "fade_start_distance", "fade_alpha_max", "fade_alpha_min");
        for (String key : allKeys) {
            String translated = class_2561.method_43471((String)("bplb.config." + key)).getString().toLowerCase();
            List<Integer> indices = this.findMatchIndices(translated, this.searchQuery);
            if (indices.isEmpty()) continue;
            this.searchMatches.put(key, new SearchMatch(translated, indices));
        }
    }

    private void addFloatSlider(String key, float initialValue, float min, float max, Consumer<Float> setter) {
        this.scrollableList.addPublicEntry(new FloatSliderOptionEntry(this.field_22787, key, initialValue, min, max, setter, this::markDirty));
    }

    private <T> void addCycle(String key, T initialValue, List<T> options, Function<T, class_2561> textSupplier, Consumer<T> setter, boolean active) {
        this.scrollableList.addPublicEntry(new CycleOptionEntry<T>(this.field_22787, key, initialValue, options, textSupplier, setter, this::markDirty, active));
    }

    private List<Integer> findMatchIndices(String text, String query) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int index = 0;
        while ((index = text.indexOf(query, index)) != -1) {
            for (int i = 0; i < query.length(); ++i) {
                indices.add(index + i);
            }
            ++index;
        }
        return indices;
    }

    private boolean matchesSearch(String key) {
        return this.searchQuery.isEmpty() || this.searchMatches.containsKey(key);
    }

    private class_2561 getTranslatedAssetName(String assetId, String category) {
        String key = "bplb.config.asset." + category + "." + assetId;
        class_5250 translated = class_2561.method_43471((String)key);
        return translated.getString().equals(key) ? class_2561.method_43470((String)assetId) : translated;
    }

    private void populateOptions() {
        this.updateSearchMatches();
        boolean isBowtie = this.workingConfig.getDotType().equals("bowtie");
        List<String> borderStyles = Arrays.asList("rounded", "squared");
        List<String> borderTypes = Arrays.asList("default", "minimal");
        List<String> heightModes = Arrays.asList("player", "camera");
        List<String> markerTypes = Arrays.asList("default", "minimal");
        Function<String, class_2561> borderStyleText = value -> class_2561.method_43471((String)("bplb.config.border_style." + value.toLowerCase()));
        Function<String, class_2561> borderTypeText = value -> class_2561.method_43471((String)("bplb.config.border_type." + value.toLowerCase()));
        Function<String, class_2561> heightModeText = value -> class_2561.method_43471((String)("bplb.config.height_difference_mode." + value.toLowerCase()));
        if (this.hasAnyMatch("modEnabled", "apply_hotbar_offset", "always_show_player_heads", "always_show_player_names", "max_visible_icons", "position_update_rate_ticks", "lerp_speed")) {
            this.addSection("general");
            this.addIfMatch("modEnabled", () -> this.addToggle("modEnabled", this.workingConfig.isModEnabled(), this.workingConfig::setModEnabled));
            this.addIfMatch("apply_hotbar_offset", () -> this.addToggle("apply_hotbar_offset", this.workingConfig.isApplyHotbarOffset(), this.workingConfig::setApplyHotbarOffset));
            this.addIfMatch("always_show_player_heads", () -> this.addToggle("always_show_player_heads", this.workingConfig.isAlwaysShowPlayerHeads(), this.workingConfig::setAlwaysShowPlayerHeads));
            this.addIfMatch("always_show_player_names", () -> this.addToggle("always_show_player_names", this.workingConfig.isAlwaysShowPlayerNames(), this.workingConfig::setAlwaysShowPlayerNames));
            this.addIfMatch("max_visible_icons", () -> this.addIntSlider("max_visible_icons", this.workingConfig.getMaxVisibleIcons(), 1, 200, this.workingConfig::setMaxVisibleIcons));
            this.addIfMatch("lerp_speed", () -> this.addFloatSlider("lerp_speed", this.workingConfig.getLerpSpeed(), 0.1f, 1.0f, this.workingConfig::setLerpSpeed));
        }
        if (this.hasAnyMatch("icon_size", "dot_type", "icon_border_style", "icon_border_type", "height_difference_mode", "arrow_type", "vertical_padding", "inherit_border_color", "adjust_to_fov", "fov_multiplier")) {
            this.addSection("icon");
            this.addIfMatch("icon_size", () -> this.addIntSlider("icon_size", this.workingConfig.getIconSize(), 1, 4, this.workingConfig::setIconSize));
            if (this.matchesSearch("dot_type")) {
                List<String> dotsToShow = Client.availableDots.stream().filter(d -> !d.equals("bowtie")).toList();
                this.scrollableList.addPublicEntry(new CycleOptionEntry<String>(this.field_22787, "dot_type", this.workingConfig.getDotType(), dotsToShow, id -> this.getTranslatedAssetName((String)id, "dot"), val -> {
                    this.workingConfig.setDotType((String)val);
                    this.markDirty();
                    this.rebuildList();
                }, this::markDirty, true));
            }
            this.addIfMatch("icon_border_style", () -> this.addCycle("icon_border_style", this.workingConfig.getIconBorderStyle(), borderStyles, borderStyleText, this.workingConfig::setIconBorderStyle, !isBowtie));
            this.addIfMatch("icon_border_type", () -> this.addCycle("icon_border_type", this.workingConfig.getIconBorderType(), borderTypes, borderTypeText, this.workingConfig::setIconBorderType, !isBowtie));
            this.addIfMatch("inherit_border_color", () -> this.addToggle("inherit_border_color", this.workingConfig.isInheritBorderColor(), this.workingConfig::setInheritBorderColor));
            this.addIfMatch("height_difference_mode", () -> this.addCycle("height_difference_mode", this.workingConfig.getHeightDifferenceMode(), heightModes, heightModeText, this.workingConfig::setHeightDifferenceMode, true));
            if (this.matchesSearch("arrow_type")) {
                List<String> arrows = Client.availableArrows.isEmpty() ? List.of("default") : Client.availableArrows;
                this.scrollableList.addPublicEntry(new CycleOptionEntry<String>(this.field_22787, "arrow_type", this.workingConfig.getArrowType(), arrows, id -> this.getTranslatedAssetName((String)id, "arrow"), val -> {
                    this.workingConfig.setArrowType((String)val);
                    this.previewArrowAnimator = null;
                    this.markDirty();
                }, this::markDirty, true));
            }
            this.addIfMatch("vertical_padding", () -> this.addIntSlider("vertical_padding", this.workingConfig.getVerticalPadding(), 0, 4, this.workingConfig::setVerticalPadding));
            this.addIfMatch("adjust_to_fov", () -> this.addToggle("adjust_to_fov", this.workingConfig.isAdjustToFov(), this.workingConfig::setAdjustToFov));
            this.addIfMatch("fov_multiplier", () -> this.addFloatSlider("fov_multiplier", this.workingConfig.getFovMultiplier(), 0.5f, 2.0f, this.workingConfig::setFovMultiplier));
        }
        if (this.hasAnyMatch("death_marker_type", "death_marker_border_type", "death_marker_inherit_border_color")) {
            this.addSection("markers");
            this.addIfMatch("death_marker_type", () -> this.addCycle("death_marker_type", this.workingConfig.getDeathMarkerType(), markerTypes, id -> this.getTranslatedAssetName((String)id, "marker"), this.workingConfig::setDeathMarkerType, true));
            this.addIfMatch("death_marker_border_type", () -> this.addCycle("death_marker_border_type", this.workingConfig.getDeathMarkerBorderType(), borderTypes, borderTypeText, this.workingConfig::setDeathMarkerBorderType, true));
            this.addIfMatch("death_marker_inherit_border_color", () -> this.addToggle("death_marker_inherit_border_color", this.workingConfig.isDeathMarkerInheritBorderColor(), this.workingConfig::setDeathMarkerInheritBorderColor));
        }
        if (this.hasAnyMatch("nameplate_scale", "name_border_style")) {
            this.addSection("player_name");
            this.addIfMatch("nameplate_scale", () -> this.addFloatSlider("nameplate_scale", this.workingConfig.getNameplateScale(), 0.5f, 1.5f, this.workingConfig::setNameplateScale));
            this.addIfMatch("name_border_style", () -> this.addCycle("name_border_style", this.workingConfig.getNameBorderStyle(), borderStyles, borderStyleText, this.workingConfig::setNameBorderStyle, true));
        }
        if (this.hasAnyMatch("fade_start_distance", "fade_end_distance", "fade_alpha_max", "fade_alpha_min")) {
            this.addSection("fading");
            this.addIfMatch("fade_start_distance", () -> this.addIntSlider("fade_start_distance", this.workingConfig.getFadeStartDistance(), 5, 9995, this.workingConfig::setFadeStartDistance));
            this.addIfMatch("fade_end_distance", () -> this.addIntSlider("fade_end_distance", this.workingConfig.getFadeEndDistance(), 10, 10000, this.workingConfig::setFadeEndDistance));
            this.addIfMatch("fade_alpha_max", () -> this.scrollableList.addPublicEntry(new FloatSliderOptionEntry(this.field_22787, "fade_alpha_max", this.workingConfig.getFadeAlphaMax(), this.workingConfig.getFadeAlphaMin(), 1.0f, val -> {
                this.workingConfig.setFadeAlphaMax(val.floatValue());
                this.rebuildListWithoutScroll();
            }, this::markDirty)));
            this.addIfMatch("fade_alpha_min", () -> this.scrollableList.addPublicEntry(new FloatSliderOptionEntry(this.field_22787, "fade_alpha_min", this.workingConfig.getFadeAlphaMin(), 0.0f, this.workingConfig.getFadeAlphaMax(), val -> {
                this.workingConfig.setFadeAlphaMin(val.floatValue());
                this.rebuildListWithoutScroll();
            }, this::markDirty)));
        }
        if (this.searchQuery.isEmpty() || this.workingConfig.getPlayerConfigs().keySet().stream().anyMatch(name -> this.matchesSearch("player." + name))) {
            this.addSection("player_appearance");
            this.scrollableList.addPublicEntry(new AddPlayerEntry(Objects.requireNonNull(this.field_22787), this, this.workingConfig));
            this.workingConfig.getPlayerConfigs().keySet().stream().sorted().forEach(name -> {
                Config.PlayerAppearance pc;
                boolean expanded = this.workingConfig.isPlayerExpanded((String)name);
                this.scrollableList.addPublicEntry(new PlayerListEntry(this.field_22787, this, this.workingConfig, (String)name, expanded));
                if (expanded && (pc = this.workingConfig.getPlayerConfigs().get(name)) != null) {
                    this.addPlayerOption((String)name, "color", () -> {
                        UUID uuid = RenderAddons.getUuidFromCache(name);
                        int defaultColor = uuid != null ? ColorUtils.generateColorFromUUID(uuid) : -8355712;
                        this.scrollableList.addPublicEntry(new ColorTextFieldEntry(this.field_22787, "player_appearance.color", pc.color != null ? pc.color : defaultColor, color -> {
                            pc.color = color;
                            this.markDirty();
                        }, this));
                    });
                    this.addPlayerOption((String)name, "dot_type", () -> {
                        List<String> dotsToShow = Client.availableDots.stream().filter(d -> !d.equals("bowtie")).toList();
                        this.scrollableList.addPublicEntry(new CycleOptionEntry<String>(this.field_22787, "player_appearance.dot_type", pc.dotType != null ? pc.dotType : "default", dotsToShow, id -> this.getTranslatedAssetName((String)id, "dot"), val -> {
                            pc.dotType = val;
                            this.markDirty();
                        }, this::markDirty, true));
                    });
                    this.addPlayerOption((String)name, "icon_border_style", () -> this.scrollableList.addPublicEntry(new CycleOptionEntry<String>(this.field_22787, "player_appearance.icon_border_style", pc.iconBorderStyle != null ? pc.iconBorderStyle : "rounded", borderStyles, borderStyleText, val -> {
                        pc.iconBorderStyle = val;
                        this.markDirty();
                    }, this::markDirty, true)));
                    this.addPlayerOption((String)name, "icon_border_type", () -> this.scrollableList.addPublicEntry(new CycleOptionEntry<String>(this.field_22787, "player_appearance.icon_border_type", pc.iconBorderType != null ? pc.iconBorderType : "default", borderTypes, borderTypeText, val -> {
                        pc.iconBorderType = val;
                        this.markDirty();
                    }, this::markDirty, true)));
                    this.addPlayerOption((String)name, "arrow_type", () -> this.scrollableList.addPublicEntry(new CycleOptionEntry<String>(this.field_22787, "player_appearance.arrow_type", pc.arrowType != null ? pc.arrowType : "default", Client.availableArrows, id -> this.getTranslatedAssetName((String)id, "arrow"), val -> {
                        pc.arrowType = val;
                        this.markDirty();
                    }, this::markDirty, true)));
                }
            });
        }
        if (this.searchQuery.isEmpty()) {
            this.scrollableList.addPublicEntry(new ResetSettingsEntry(this.field_22787, this, this::markDirty, this.workingConfig));
        }
    }

    private boolean hasAnyMatch(String ... keys) {
        if (this.searchQuery.isEmpty()) {
            return true;
        }
        for (String key : keys) {
            if (!this.matchesSearch(key)) continue;
            return true;
        }
        return false;
    }

    private void addIfMatch(String key, Runnable action) {
        if (this.matchesSearch(key)) {
            action.run();
        }
    }

    private void addPlayerOption(String playerName, String option, Runnable action) {
        if (this.matchesSearch("player." + playerName + "." + option)) {
            action.run();
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.scrollableList != null) {
            this.scrollableList.tick();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, 0xFAFAFA);
        this.renderGlobalPreview(context);
        if (Client.isLocalMode()) {
            class_5250 warningText = class_2561.method_43471((String)"bplb.config.local_mode_warning").method_27692(class_124.field_1061);
            context.method_27535(this.field_22793, (class_2561)warningText, this.field_22789 - this.field_22793.method_27525((class_5348)warningText) - 5, this.field_22790 - 15, 0xFAFAFA);
        }
    }

    public void drawLabelWithHighlight(class_332 context, class_2561 label, int x, int y, String key) {
        String text = label.getString();
        if (this.searchQuery.isEmpty() || !this.searchMatches.containsKey(key)) {
            context.method_27535(this.field_22793, label, x, y, 0xFAFAFA);
            return;
        }
        String textLower = text.toLowerCase();
        String query = this.searchQuery.toLowerCase();
        boolean[] highlighted = new boolean[text.length()];
        int pos = 0;
        while ((pos = textLower.indexOf(query, pos)) != -1) {
            for (int i = pos; i < pos + query.length() && i < text.length(); ++i) {
                highlighted[i] = true;
            }
            ++pos;
        }
        int currentX = x;
        int start = 0;
        while (start < text.length()) {
            int end;
            boolean isHighlighted = highlighted[start];
            for (end = start; end < text.length() && highlighted[end] == isHighlighted; ++end) {
            }
            String segment = text.substring(start, end);
            int color = isHighlighted ? -256 : 0xFAFAFA;
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)segment), currentX, y, color);
            currentX += this.field_22793.method_1727(segment);
            start = end;
        }
    }

    private void renderGlobalPreview(class_332 context) {
        int previewOffset = this.field_22789 < 460 ? 20 : 0;
        int previewCenterX = this.field_22789 - 70 + 0 + previewOffset;
        int previewCenterY = this.field_22790 / 2 + 30;
        int previewAdjustmentY = 18;
        int verticalPadding = this.workingConfig.getVerticalPadding() * 5 + 3;
        this.renderArrowPreview(context, previewCenterX, previewCenterY - 90 - verticalPadding + previewAdjustmentY, true);
        this.renderIconPreview(context, previewCenterX, previewCenterY - 45 + 1);
        this.renderArrowPreview(context, previewCenterX, previewCenterY + verticalPadding - previewAdjustmentY + 1, false);
        this.renderDeathMarkerPreview(context, previewCenterX, previewCenterY + 45);
    }

    private void renderIconPreview(class_332 context, int centerX, int centerY) {
        RenderUtils.withMatrixPush(context, (float)centerX - 22.5f, (float)centerY - 22.5f, () -> {
            int textureIndex = this.workingConfig.getIconSize() == 4 ? 0 : 4 - this.workingConfig.getIconSize();
            String dotId = this.workingConfig.getDotType();
            String borderStyle = this.workingConfig.getIconBorderStyle();
            String borderType = this.workingConfig.getIconBorderType();
            int color = 0xFAFAFA;
            class_2960 dotTexture = TextureManager.getPlayerDotTexture(dotId, textureIndex);
            class_2960 outlineTexture = TextureManager.getPlayerDotOutlineTexture(dotId, borderStyle, borderType, textureIndex);
            int borderColor = this.workingConfig.isInheritBorderColor() ? ColorUtils.darkerColoring(color) : -15066598;
            RenderUtils.renderTintedTexture(context, outlineTexture, 0.0f, 0.0f, 45.0f, 45.0f, borderColor, 1.0f);
            RenderUtils.renderTintedTexture(context, dotTexture, 0.0f, 0.0f, 45.0f, 45.0f, color, 1.0f);
        });
    }

    private void renderArrowPreview(class_332 context, int centerX, int centerY, boolean isUp) {
        RenderUtils.withMatrixPush(context, centerX, centerY, () -> {
            if (this.previewArrowAnimator == null) {
                this.previewArrowAnimator = new TextureAnimator(10, 4);
            }
            class_2960 arrowTexture = TextureManager.getArrowTexture(this.workingConfig.getArrowType());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int frame = this.previewArrowAnimator.getCurrentFrame();
            float u = isUp ? 0.0f : 9.0f;
            float v = frame * 9;
            context.method_25302(class_1921::method_62277, arrowTexture, -22, -22, u, v, 45, 45, 9, 9, 18, 18);
        });
    }

    private void renderDeathMarkerPreview(class_332 context, int centerX, int centerY) {
        RenderUtils.withMatrixPush(context, (float)centerX - 22.5f, (float)centerY - 22.5f, () -> RenderAddons.renderDeathMarker(context, 0.0f, 0.0f, 45, 1.0f, this.workingConfig));
    }

    private void applyChanges() {
        for (Map.Entry<String, Config.PlayerAppearance> entry : this.workingConfig.getPlayerConfigs().entrySet()) {
            UUID uuid = RenderAddons.getUuidFromCache(entry.getKey());
            if (uuid == null) continue;
            Config.PlayerAppearance pc = entry.getValue();
            pc.playerUuid = uuid;
            pc.playerName = entry.getKey();
        }
        Config.copy(this.workingConfig, Config.getInstance());
        Config.getInstance().save();
        this.hasChanges = false;
        this.updateButtons();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void markDirty() {
        this.hasChanges = true;
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.applyButton != null) {
            this.applyButton.field_22763 = this.hasChanges;
        }
        if (this.doneButton != null) {
            this.doneButton.field_22763 = !this.hasChanges;
        }
    }

    private record SearchMatch(String key, List<Integer> matchIndices) {
    }
}

