/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.commands;

import com.fancyinnovations.fancydialogs.FancyDialogsPlugin;
import com.fancyinnovations.fancydialogs.api.Dialog;
import com.fancyinnovations.fancydialogs.api.data.DialogData;
import com.fancyinnovations.fancydialogs.api.dialogs.ConfirmationDialog;
import com.fancyinnovations.fancydialogs.config.FancyDialogsConfig;
import com.fancyinnovations.fancydialogs.dialog.DialogImpl;
import de.oliver.fancyanalytics.logger.LogLevel;
import de.oliver.fancylib.translations.Language;
import de.oliver.fancylib.translations.Translator;
import java.util.Collection;
import java.util.List;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Description;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;

public final class FancyDialogsCMD {
    public static final FancyDialogsCMD INSTANCE = new FancyDialogsCMD();
    private final FancyDialogsPlugin plugin = FancyDialogsPlugin.get();
    private final Translator translator = FancyDialogsPlugin.get().getTranslator();

    private FancyDialogsCMD() {
    }

    @Command(value={"fancydialogs version"})
    @Description(value="Shows the version of FancyDialogs")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.version")
    public void version(BukkitCommandActor actor) {
        String version = this.plugin.getPluginMeta().getVersion();
        this.translator.translate("commands.fancydialogs.version").replace("version", version).send(actor.sender());
    }

    @Command(value={"fancydialogs config reload"})
    @Description(value="Reloads the FancyDialogs configuration file")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.config.reload")
    public void configReload(BukkitCommandActor actor) {
        if (actor.isPlayer()) {
            new ConfirmationDialog("Are you sure you want to reload the configuration? This will reset all changes made to the config file.").withTitle("Confirm reload").withOnConfirm(() -> this.reloadConfig(actor)).withOnCancel(() -> this.translator.translate("commands.fancydialogs.config.reload.cancelled").send(actor.sender())).ask(actor.asPlayer());
        } else {
            this.reloadConfig(actor);
        }
    }

    private void reloadConfig(BukkitCommandActor actor) {
        FancyDialogsConfig config = this.plugin.getFancyDialogsConfig();
        config.load();
        this.plugin.getFancyLogger().setCurrentLevel(LogLevel.valueOf(config.getLogLevel()));
        this.translator.loadLanguages(this.plugin.getDataFolder().getAbsolutePath());
        Language selectedLanguage = this.translator.getLanguages().stream().filter(language -> language.getLanguageName().equals(config.getLanguage())).findFirst().orElse(this.translator.getFallbackLanguage());
        this.translator.setSelectedLanguage(selectedLanguage);
        this.translator.translate("commands.fancydialogs.config.reload.success").send(actor.sender());
    }

    @Command(value={"fancydialogs storage save"})
    @Description(value="Saves all dialog data to the storage")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.storage.save")
    public void storageSave(BukkitCommandActor actor) {
        List<DialogData> dialogs = this.plugin.getDialogRegistry().getAll().stream().map(Dialog::getData).toList();
        this.plugin.getDialogStorage().saveBatch(dialogs);
        this.translator.translate("commands.fancydialogs.storage.save.success").replace("count", String.valueOf(dialogs.size())).send(actor.sender());
    }

    @Command(value={"fancydialogs storage load"})
    @Description(value="Loads all dialog data from the storage")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.storage.load")
    public void storageLoad(BukkitCommandActor actor) {
        if (actor.isPlayer()) {
            new ConfirmationDialog("Are you sure you want to load all dialog data from the storage? This will overwrite any existing dialogs.").withTitle("Confirm load").withOnConfirm(() -> this.loadStorage(actor)).withOnCancel(() -> this.translator.translate("commands.fancydialogs.storage.load.cancelled").send(actor.sender())).ask(actor.asPlayer());
        } else {
            this.loadStorage(actor);
        }
    }

    private void loadStorage(BukkitCommandActor actor) {
        Collection<DialogData> dialogs = this.plugin.getDialogStorage().loadAll();
        for (DialogData dialogData : dialogs) {
            DialogImpl dialog = new DialogImpl(dialogData.id(), dialogData);
            this.plugin.getDialogRegistry().register(dialog);
        }
        this.translator.translate("commands.fancydialogs.storage.load.success").replace("count", String.valueOf(dialogs.size())).send(actor.sender());
    }

    @Command(value={"fancydialogs storage reload"})
    @Description(value="Clears the dialog registry and loads all dialog data from the storage")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.storage.reload")
    public void storageReload(BukkitCommandActor actor) {
        if (actor.isPlayer()) {
            new ConfirmationDialog("Are you sure you want to reload all dialog data from the storage? This will clear the dialog registry and overwrite any existing dialogs.").withTitle("Confirm reload").withOnConfirm(() -> this.reloadStorage(actor)).withOnCancel(() -> this.translator.translate("commands.fancydialogs.storage.reload.cancelled").send(actor.sender())).ask(actor.asPlayer());
        } else {
            this.reloadStorage(actor);
        }
    }

    private void reloadStorage(BukkitCommandActor actor) {
        this.plugin.getDialogRegistry().clear();
        Collection<DialogData> dialogs = this.plugin.getDialogStorage().loadAll();
        for (DialogData dialogData : dialogs) {
            DialogImpl dialog = new DialogImpl(dialogData.id(), dialogData);
            this.plugin.getDialogRegistry().register(dialog);
        }
        this.translator.translate("commands.fancydialogs.storage.reload.success").replace("count", String.valueOf(dialogs.size())).send(actor.sender());
    }

    @Command(value={"fancydialogs registry list"})
    @Description(value="Lists all registered dialogs")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.registry.list")
    public void registryList(BukkitCommandActor actor) {
        Collection<Dialog> dialogs = this.plugin.getDialogRegistry().getAll();
        if (dialogs.isEmpty()) {
            this.translator.translate("commands.dialog.list.empty").send(actor.sender());
            return;
        }
        this.translator.translate("commands.dialog.list.header").replace("count", String.valueOf(dialogs.size())).send(actor.sender());
        for (Dialog dialog : dialogs) {
            this.translator.translate("commands.dialog.list.entry").replace("id", dialog.getId()).replace("title", dialog.getData().title()).send(actor.sender());
        }
    }

    @Command(value={"fancydialogs registry clear"})
    @Description(value="Clears the dialog registry")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.registry.clear")
    public void registryClear(BukkitCommandActor actor) {
        if (actor.isPlayer()) {
            new ConfirmationDialog("Are you sure you want to clear the dialog registry? This will remove all registered dialogs.").withTitle("Confirm clear").withOnConfirm(() -> this.clearRegistry(actor)).withOnCancel(() -> this.translator.translate("commands.fancydialogs.registry.clear.cancelled").send(actor.sender())).ask(actor.asPlayer());
        } else {
            this.clearRegistry(actor);
        }
    }

    private void clearRegistry(BukkitCommandActor actor) {
        this.plugin.getDialogRegistry().clear();
        this.translator.translate("commands.fancydialogs.registry.clear.success").send(actor.sender());
    }

    @Command(value={"fancydialogs registry unregister <dialog>"})
    @Description(value="Unregisters a dialog by its ID")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.registry.unregister")
    public void registryUnregister(BukkitCommandActor actor, Dialog dialog) {
        if (actor.isPlayer()) {
            new ConfirmationDialog("Are you sure you want to unregister the dialog with ID '" + dialog.getId() + "'? This will remove it from the registry.").withTitle("Confirm unregister").withOnConfirm(() -> this.unregisterDialog(actor, dialog)).withOnCancel(() -> this.translator.translate("commands.fancydialogs.registry.unregister.cancelled").send(actor.sender())).ask(actor.asPlayer());
        } else {
            this.unregisterDialog(actor, dialog);
        }
    }

    private void unregisterDialog(BukkitCommandActor actor, Dialog dialog) {
        this.plugin.getDialogRegistry().unregister(dialog.getId());
        this.translator.translate("commands.fancydialogs.registry.unregister.success").replace("id", dialog.getId()).send(actor.sender());
    }

    @Command(value={"fancydialogs joined_players_cache clear"})
    @Description(value="Clears the joined players cache")
    @CommandPermission(value="fancydialogs.commands.fancydialogs.joined_players_cache.clear")
    public void joinedPlayersCacheClear(BukkitCommandActor actor) {
        if (actor.isPlayer()) {
            new ConfirmationDialog("Are you sure you want to clear the joined players cache?").withTitle("Confirm clear").withOnConfirm(() -> this.clearJoinedPlayersCache(actor)).withOnCancel(() -> this.translator.translate("commands.fancydialogs.joined_players_cache.clear.cancelled").send(actor.sender())).ask(actor.asPlayer());
        } else {
            this.clearJoinedPlayersCache(actor);
        }
    }

    private void clearJoinedPlayersCache(BukkitCommandActor actor) {
        this.plugin.getJoinedPlayersCache().clear();
        this.translator.translate("commands.fancydialogs.joined_players_cache.clear.success").send(actor.sender());
    }
}

