/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.libs.chatcolorhandler;

import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.ChatColorHandlerSettings;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.messengers.LegacyMessenger;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.messengers.Messenger;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.messengers.MiniMessageMessenger;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.Parser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.ParserTypes;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.Parsers;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.HexParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.LegacyHexParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.LegacySpigotParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.MiniMessageColorParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.MiniMessageInteractionParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.MiniMessagePlaceholderParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.MiniMessageResolverParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.MiniMessageTextFormattingParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.MiniPlaceholdersParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.ParticleParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.PlaceholderAPIParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.SoundParser;
import com.fancyinnovations.fancydialogs.libs.chatcolorhandler.parsers.custom.SpigotParser;
import java.util.Collection;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatColorHandler {
    private static boolean initialised = false;
    private static Messenger messenger;
    private static final Parsers parsers;
    private static final ChatColorHandlerSettings settings;

    public static String translate(@Nullable String string) {
        return ChatColorHandler.translate(string, settings.defaultParsers());
    }

    public static String translate(@Nullable String string, @NotNull List<Parser> parsers) {
        return ChatColorHandler.translate(string, null, parsers);
    }

    public static String translate(@Nullable String string, Player player) {
        return ChatColorHandler.translate(string, player, settings.defaultParsers());
    }

    public static String translate(@Nullable String string, Player player, List<Parser> parsers) {
        ChatColorHandler.ensureInitialised();
        if (string == null || string.isBlank()) {
            return "";
        }
        return ChatColorHandler.parsers.parseString(string, Parser.OutputType.SPIGOT, player, parsers);
    }

    public static List<String> translate(@NotNull Collection<String> strings) {
        return ChatColorHandler.translate(strings, settings.defaultParsers());
    }

    public static List<String> translate(@NotNull Collection<String> strings, List<Parser> parsers) {
        return ChatColorHandler.translate(strings, null, parsers);
    }

    public static List<String> translate(@NotNull Collection<String> strings, Player player) {
        return ChatColorHandler.translate(strings, player, settings.defaultParsers());
    }

    public static List<String> translate(@NotNull Collection<String> strings, Player player, List<Parser> parsers) {
        return strings.stream().map(string -> ChatColorHandler.translate(string, player, parsers)).toList();
    }

    public static String stripColor(@Nullable String string) {
        ChatColorHandler.ensureInitialised();
        if (string == null || string.isBlank()) {
            return "";
        }
        return ChatColor.stripColor((String)ChatColorHandler.translate(string, ParserTypes.all()));
    }

    public static void sendMessage(@NotNull CommandSender recipient, @Nullable String message) {
        ChatColorHandler.messenger().sendMessage(recipient, message);
    }

    public static void sendMessage(@NotNull CommandSender recipient, String ... messages) {
        ChatColorHandler.messenger().sendMessage(recipient, messages);
    }

    public static void sendMessage(CommandSender[] recipients, @Nullable String message) {
        ChatColorHandler.messenger().sendMessage(recipients, message);
    }

    public static void sendMessage(CommandSender[] recipients, String ... messages) {
        ChatColorHandler.messenger().sendMessage(recipients, messages);
    }

    public static void broadcastMessage(@Nullable String message) {
        ChatColorHandler.messenger().broadcastMessage(message);
    }

    public static void broadcastMessage(String ... messages) {
        ChatColorHandler.messenger().broadcastMessage(messages);
    }

    public static void sendActionBarMessage(@NotNull Player player, @Nullable String message) {
        ChatColorHandler.messenger().sendActionBarMessage(player, message);
    }

    public static void sendActionBarMessage(@NotNull Player[] players, @Nullable String message) {
        ChatColorHandler.messenger().sendActionBarMessage(players, message);
    }

    public static void sendTitle(@NotNull Player player, @Nullable String title) {
        ChatColorHandler.messenger().sendTitle(player, title);
    }

    public static void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle) {
        ChatColorHandler.messenger().sendTitle(player, title, subtitle);
    }

    public static void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle, int fadeIn, int fadeOut) {
        ChatColorHandler.messenger().sendTitle(player, title, subtitle, fadeIn, fadeOut);
    }

    public static void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        ChatColorHandler.messenger().sendTitle(player, title, subtitle, fadeIn, stay, fadeOut);
    }

    public static void sendTitle(@NotNull Player[] players, @Nullable String title) {
        ChatColorHandler.messenger().sendTitle(players, title);
    }

    public static void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle) {
        ChatColorHandler.messenger().sendTitle(players, title, subtitle);
    }

    public static void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle, int fadeIn, int fadeOut) {
        ChatColorHandler.messenger().sendTitle(players, title, subtitle, fadeIn, fadeOut);
    }

    public static void sendTitle(@NotNull Player[] players, @Nullable String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        ChatColorHandler.messenger().sendTitle(players, title, subtitle, fadeIn, stay, fadeOut);
    }

    public static Messenger messenger() {
        ChatColorHandler.ensureInitialised();
        return messenger;
    }

    public static void messenger(Messenger messenger) {
        ChatColorHandler.messenger = messenger;
    }

    public static Parsers parsers() {
        ChatColorHandler.ensureInitialised();
        return parsers;
    }

    public static ChatColorHandlerSettings settings() {
        return settings;
    }

    protected static void debugLog(String log) {
        if (settings.debug()) {
            Bukkit.getLogger().info("[ChatColorHandler] " + log);
        }
    }

    public static synchronized void ensureInitialised() {
        if (!initialised) {
            ChatColorHandler.init();
        }
    }

    private static void init() {
        initialised = true;
        parsers.register(HexParser.INSTANCE, 83);
        parsers.register(SpigotParser.INSTANCE, 65);
        parsers.register(SoundParser.INSTANCE, 60);
        parsers.register(ParticleParser.INSTANCE, 59);
        if (ChatColorHandler.isPaper()) {
            ChatColorHandler.messenger(new MiniMessageMessenger());
            parsers.register(MiniMessageResolverParser.INSTANCE, 89);
            parsers.register(LegacyHexParser.INSTANCE, 75);
            parsers.register(LegacySpigotParser.INSTANCE, 74);
            parsers.register(MiniMessageColorParser.INSTANCE, 73);
            parsers.register(MiniMessageInteractionParser.INSTANCE, 72);
            parsers.register(MiniMessagePlaceholderParser.INSTANCE, 71);
            parsers.register(MiniMessageTextFormattingParser.INSTANCE, 70);
            ChatColorHandler.debugLog("Found MiniMessage in Server. MiniMessage support enabled.");
        } else {
            ChatColorHandler.messenger(new LegacyMessenger());
            ChatColorHandler.debugLog("Unable to find MiniMessage. MiniMessage support not enabled.");
        }
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        if (pluginManager.getPlugin("PlaceholderAPI") != null && pluginManager.isPluginEnabled("PlaceholderAPI")) {
            parsers.register(PlaceholderAPIParser.INSTANCE, 90);
            ChatColorHandler.debugLog("Found plugin \"PlaceholderAPI\". PlaceholderAPI support enabled.");
        }
        if (pluginManager.getPlugin("MiniPlaceholders") != null && pluginManager.isPluginEnabled("MiniPlaceholders")) {
            parsers.register(MiniPlaceholdersParser.INSTANCE, -1);
            ChatColorHandler.debugLog("Found plugin \"MiniPlaceholders\". MiniPlaceholders support enabled.");
        }
        ChatColorHandler.settings().defaultParsers(ParserTypes.all());
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isPaper() {
        if (ChatColorHandler.hasClass("com.destroystokyo.paper.PaperConfig") || ChatColorHandler.hasClass("io.papermc.paper.configuration.Configuration")) {
            try {
                Class.forName("net.kyori.adventure.text.minimessage.MiniMessage").getMethod("miniMessage", new Class[0]);
                return true;
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    private ChatColorHandler() {
    }

    static {
        parsers = new Parsers();
        settings = new ChatColorHandlerSettings();
    }
}

